/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldPrepender;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.ha.CommunicationProtocol;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterImpl;
import org.neo4j.kernel.ha.SlaveContext;
import org.neo4j.kernel.impl.util.StringLogger;

public class MasterServer
extends CommunicationProtocol
implements ChannelPipelineFactory {
    private static final int DEAD_CONNECTIONS_CHECK_INTERVAL = 3;
    private static final int MAX_NUMBER_OF_CONCURRENT_TRANSACTIONS = 200;
    private final ChannelFactory channelFactory;
    private final ServerBootstrap bootstrap;
    private final Master realMaster;
    private final ChannelGroup channelGroup;
    private final ScheduledExecutorService deadConnectionsPoller;
    private final Map<Channel, SlaveContext> connectedSlaveChannels = new HashMap<Channel, SlaveContext>();
    private final Map<Channel, Pair<ChannelBuffer, ByteBuffer>> channelBuffers = new HashMap<Channel, Pair<ChannelBuffer, ByteBuffer>>();
    private final ExecutorService executor;
    private final StringLogger msgLog;

    public MasterServer(Master realMaster, final int port, String storeDir) {
        this.realMaster = realMaster;
        this.msgLog = StringLogger.getLogger((String)(storeDir + "/messages.log"));
        this.executor = Executors.newCachedThreadPool();
        this.channelFactory = new NioServerSocketChannelFactory((Executor)this.executor, (Executor)this.executor, 200);
        this.bootstrap = new ServerBootstrap(this.channelFactory);
        this.bootstrap.setPipelineFactory((ChannelPipelineFactory)this);
        this.channelGroup = new DefaultChannelGroup();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                Channel channel = MasterServer.this.bootstrap.bind((SocketAddress)new InetSocketAddress(port));
                MasterServer.this.channelGroup.add((Object)channel);
                MasterServer.this.msgLog.logMessage("Master server bound to " + port, true);
            }
        });
        this.deadConnectionsPoller = new ScheduledThreadPoolExecutor(1);
        this.deadConnectionsPoller.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                MasterServer.this.checkForDeadChannels();
            }
        }, 3L, 3L, TimeUnit.SECONDS);
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(0x1000000, 0, 4, 0, 4));
        pipeline.addLast("frameEncoder", (ChannelHandler)new LengthFieldPrepender(4));
        pipeline.addLast("serverHandler", (ChannelHandler)new ServerHandler());
        return pipeline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pair<ChannelBuffer, ByteBuffer> mapSlave(Channel channel, SlaveContext slave) {
        this.channelGroup.add((Object)channel);
        Pair buffer = null;
        Map<Channel, SlaveContext> map = this.connectedSlaveChannels;
        synchronized (map) {
            if (slave != null) {
                this.connectedSlaveChannels.put(channel, slave);
            }
            if ((buffer = this.channelBuffers.get(channel)) == null) {
                buffer = Pair.of((Object)ChannelBuffers.dynamicBuffer(), (Object)ByteBuffer.allocateDirect(0x100000));
                this.channelBuffers.put(channel, (Pair<ChannelBuffer, ByteBuffer>)buffer);
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unmapSlave(Channel channel, SlaveContext slave) {
        Map<Channel, SlaveContext> map = this.connectedSlaveChannels;
        synchronized (map) {
            this.connectedSlaveChannels.remove(channel);
        }
    }

    public void shutdown() {
        this.deadConnectionsPoller.shutdown();
        this.msgLog.logMessage("Master server shutdown, closing all channels", true);
        this.channelGroup.close().awaitUninterruptibly();
        this.executor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForDeadChannels() {
        Map<Channel, SlaveContext> map = this.connectedSlaveChannels;
        synchronized (map) {
            ArrayList<Channel> channelsToRemove = new ArrayList<Channel>();
            for (Map.Entry<Channel, SlaveContext> entry : this.connectedSlaveChannels.entrySet()) {
                if (!this.channelIsOpen(entry.getKey())) {
                    System.out.println("Found dead channel " + entry.getKey() + ", " + entry.getValue());
                    this.realMaster.finishTransaction(entry.getValue());
                    System.out.println("Removed " + entry.getKey() + ", " + entry.getValue());
                }
                channelsToRemove.add(entry.getKey());
            }
            for (Channel channel : channelsToRemove) {
                this.connectedSlaveChannels.remove(channel);
                this.channelBuffers.remove(channel);
            }
        }
    }

    private boolean channelIsOpen(Channel channel) {
        return channel.isConnected() && channel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, Collection<SlaveContext>> getSlaveInformation() {
        HashSet<Integer> machineIds = new HashSet<Integer>();
        Map<Channel, SlaveContext> map = this.connectedSlaveChannels;
        synchronized (map) {
            for (SlaveContext context : this.connectedSlaveChannels.values()) {
                machineIds.add(context.machineId());
            }
        }
        Map<Integer, Collection<SlaveContext>> ongoingTransactions = ((MasterImpl)this.realMaster).getOngoingTransactions();
        for (Integer machineId : machineIds) {
            if (ongoingTransactions.containsKey(machineId)) continue;
            ongoingTransactions.put(machineId, Collections.emptyList());
        }
        return new TreeMap<Integer, Collection<SlaveContext>>(ongoingTransactions);
    }

    private class ServerHandler
    extends SimpleChannelHandler {
        private ServerHandler() {
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
            try {
                ChannelBuffer message = (ChannelBuffer)event.getMessage();
                ChannelBuffer result = CommunicationProtocol.handleRequest(MasterServer.this.realMaster, message, event.getChannel(), MasterServer.this);
                event.getChannel().write((Object)result);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            e.getCause().printStackTrace();
        }
    }
}

