/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.Arrays;
import org.neo4j.helpers.Pair;

public final class SlaveContext {
    private final int machineId;
    private final Pair<String, Long>[] lastAppliedTransactions;
    private final int eventIdentifier;
    private final int hashCode;

    public SlaveContext(int machineId, int eventIdentifier, Pair<String, Long>[] lastAppliedTransactions) {
        this.machineId = machineId;
        this.eventIdentifier = eventIdentifier;
        this.lastAppliedTransactions = lastAppliedTransactions;
        this.hashCode = 3 * eventIdentifier * machineId;
    }

    public int machineId() {
        return this.machineId;
    }

    public Pair<String, Long>[] lastAppliedTransactions() {
        return this.lastAppliedTransactions;
    }

    public int getEventIdentifier() {
        return this.eventIdentifier;
    }

    public String toString() {
        return "SlaveContext[ID:" + this.machineId + ", eventIdentifier:" + this.eventIdentifier + ", " + Arrays.asList(this.lastAppliedTransactions) + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SlaveContext)) {
            return false;
        }
        SlaveContext o = (SlaveContext)obj;
        return o.eventIdentifier == this.eventIdentifier && o.machineId == this.machineId;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

