/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import java.util.Arrays;
import javax.transaction.TransactionManager;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.HaCommunicationException;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.Response;
import org.neo4j.kernel.ha.ResponseReceiver;
import org.neo4j.kernel.ha.TransactionStream;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperException;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGeneratorFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

public class SlaveTxIdGenerator
implements TxIdGenerator {
    private final Broker broker;
    private final ResponseReceiver receiver;
    private final TxManager txManager;

    public SlaveTxIdGenerator(Broker broker, ResponseReceiver receiver, TransactionManager txManager) {
        this.broker = broker;
        this.receiver = receiver;
        this.txManager = (TxManager)txManager;
    }

    public long generate(XaDataSource dataSource, int identifier) {
        try {
            int eventIdentifier = this.txManager.getEventIdentifier();
            Pair tx = new Pair((Object)-1L, (Object)dataSource.getPreparedTransaction(identifier));
            Response<Long> response = ((Master)this.broker.getMaster().first()).commitSingleResourceTransaction(this.receiver.getSlaveContext(eventIdentifier), dataSource.getName(), new TransactionStream(Arrays.asList(tx)));
            return this.receiver.receive(response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ZooKeeperException e) {
            this.receiver.newMaster(null, e);
            throw e;
        }
        catch (HaCommunicationException e) {
            this.receiver.newMaster(null, e);
            throw e;
        }
    }

    public int getCurrentMasterId() {
        return ((Machine)this.broker.getMaster().other()).getMachineId();
    }

    public static class SlaveTxIdGeneratorFactory
    implements TxIdGeneratorFactory {
        private final Broker broker;
        private final ResponseReceiver receiver;

        public SlaveTxIdGeneratorFactory(Broker broker, ResponseReceiver receiver) {
            this.broker = broker;
            this.receiver = receiver;
        }

        public TxIdGenerator create(TransactionManager txManager) {
            return new SlaveTxIdGenerator(this.broker, this.receiver, txManager);
        }
    }
}

