/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.ha.TransactionStream;

public class TransactionStreams {
    public static final TransactionStreams EMPTY = new TransactionStreams(){

        @Override
        public void add(String resource, TransactionStream stream) {
            throw new UnsupportedOperationException("read-only instance");
        }
    };
    private List<Pair<String, TransactionStream>> streams;

    public void add(String resource, TransactionStream stream) {
        this.ensureListInstantiated();
        this.streams.add((Pair<String, TransactionStream>)new Pair((Object)resource, (Object)stream));
    }

    public Collection<Pair<String, TransactionStream>> getStreams() {
        return this.streams == null ? Collections.emptyList() : Collections.unmodifiableList(this.streams);
    }

    private void ensureListInstantiated() {
        if (this.streams == null) {
            this.streams = new ArrayList<Pair<String, TransactionStream>>();
        }
    }

    public void close() throws IOException {
        if (this.streams != null) {
            for (Pair<String, TransactionStream> stream : this.streams) {
                ((TransactionStream)stream.other()).close();
            }
        }
    }
}

