/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.comm;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Iterator;

class ByteArrayIteratorChannel
implements ReadableByteChannel {
    private int pos = 0;
    private byte[] current;
    private Iterator<byte[]> iterator;

    ByteArrayIteratorChannel(Iterator<byte[]> iterator) {
        this.current = iterator.hasNext() ? iterator.next() : new byte[0];
        this.iterator = iterator;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.pos >= this.current.length && !this.iterator.hasNext()) {
            return -1;
        }
        int size = 0;
        while (dst.hasRemaining() && (this.pos < this.current.length || this.iterator.hasNext())) {
            if (this.pos < this.current.length) {
                this.current = this.iterator.next();
                this.pos = 0;
            }
            int length = Math.min(this.current.length - this.pos, dst.limit() - dst.position());
            dst.put(this.current, this.pos, length);
            this.pos += length;
            size += length;
        }
        return size;
    }

    @Override
    public void close() throws IOException {
        this.current = null;
        this.iterator = null;
    }

    @Override
    public boolean isOpen() {
        return this.current != null;
    }
}

