/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.comm;

import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.kernel.ha.IdAllocation;
import org.neo4j.kernel.ha.LockResult;
import org.neo4j.kernel.ha.comm.CommunicationUtils;

public abstract class DataWriter {
    public static final DataWriter VOID = new DataWriter(){

        @Override
        public void write(ChannelBuffer buffer) {
        }
    };

    public abstract void write(ChannelBuffer var1);

    public static final class WriteIdArray
    extends DataWriter {
        private final long[] ids;

        public WriteIdArray(long[] ids) {
            this.ids = ids;
        }

        @Override
        public void write(ChannelBuffer buffer) {
            CommunicationUtils.writeIdArray(this.ids, buffer);
        }
    }

    public static final class WriteIdAllocation
    extends DataWriter {
        private final IdAllocation result;

        public WriteIdAllocation(IdAllocation result) {
            this.result = result;
        }

        @Override
        public void write(ChannelBuffer buffer) {
            CommunicationUtils.writeIdAllocation(this.result, buffer);
        }
    }

    public static final class WriteLockResult
    extends DataWriter {
        private final LockResult result;

        public WriteLockResult(LockResult result) {
            this.result = result;
        }

        @Override
        public void write(ChannelBuffer buffer) {
            CommunicationUtils.writeLockResult(this.result, buffer);
        }
    }

    public static final class WriteString
    extends DataWriter {
        private final String string;

        public WriteString(String string) {
            this.string = string;
        }

        @Override
        public void write(ChannelBuffer buffer) {
            CommunicationUtils.writeString(this.string, buffer, false);
        }
    }

    public static final class WriteLong
    extends DataWriter {
        private final long value;

        public WriteLong(long value) {
            this.value = value;
        }

        @Override
        public void write(ChannelBuffer buffer) {
            buffer.writeLong(this.value);
        }
    }

    public static final class WriteInt
    extends DataWriter {
        private final int value;

        public WriteInt(int value) {
            this.value = value;
        }

        @Override
        public void write(ChannelBuffer buffer) {
            buffer.writeInt(this.value);
        }
    }
}

