/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.comm;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterImpl;
import org.neo4j.kernel.ha.Response;
import org.neo4j.kernel.ha.SlaveContext;
import org.neo4j.kernel.ha.comm.ChunkedResponse;
import org.neo4j.kernel.ha.comm.DataWriter;
import org.neo4j.kernel.ha.comm.MasterInvoker;
import org.neo4j.kernel.ha.comm.RequestDecoder;
import org.neo4j.kernel.impl.util.StringLogger;

public class MasterServer
implements ChannelPipelineFactory {
    private static final int DEAD_CONNECTIONS_CHECK_INTERVAL = 10;
    private static final int MAX_NUMBER_OF_CONCURRENT_TRANSACTIONS = 200;
    private final ChannelFactory channelFactory;
    private final ServerBootstrap bootstrap;
    private final Master realMaster;
    private final ChannelGroup channelGroup;
    private final ScheduledExecutorService deadConnectionsPoller;
    private final Map<Channel, SlaveContext> connectedSlaveChannels = new HashMap<Channel, SlaveContext>();
    private final StringLogger msgLog;

    public MasterServer(Master realMaster, final int port, String storeDir) {
        this.realMaster = realMaster;
        this.msgLog = StringLogger.getLogger((String)(storeDir + "/messages.log"));
        ExecutorService executor = Executors.newCachedThreadPool();
        this.channelFactory = new NioServerSocketChannelFactory((Executor)executor, (Executor)executor, 200);
        this.bootstrap = new ServerBootstrap(this.channelFactory);
        this.bootstrap.setPipelineFactory((ChannelPipelineFactory)this);
        this.channelGroup = new DefaultChannelGroup();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                Channel channel = MasterServer.this.bootstrap.bind((SocketAddress)new InetSocketAddress(port));
                MasterServer.this.channelGroup.add((Object)channel);
                MasterServer.this.msgLog.logMessage("Master server bound to " + port, true);
            }
        });
        this.deadConnectionsPoller = new ScheduledThreadPoolExecutor(1);
        this.deadConnectionsPoller.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        pipeline.addLast("requestDecoder", (ChannelHandler)new RequestDecoder());
        pipeline.addLast("serverHandler", (ChannelHandler)new ServerHandler());
        return pipeline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mapSlave(Channel channel, SlaveContext slave) {
        this.channelGroup.add((Object)channel);
        Map<Channel, SlaveContext> map = this.connectedSlaveChannels;
        synchronized (map) {
            this.connectedSlaveChannels.put(channel, slave);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unmapSlave(Channel channel, SlaveContext slave) {
        Map<Channel, SlaveContext> map = this.connectedSlaveChannels;
        synchronized (map) {
            this.connectedSlaveChannels.remove(channel);
        }
    }

    public void shutdown() {
        this.deadConnectionsPoller.shutdown();
        this.msgLog.logMessage("Master server shutdown, closing all channels", true);
        this.channelGroup.close().awaitUninterruptibly();
    }

    private boolean channelIsClosed(Channel channel) {
        return channel.isConnected() && channel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, Collection<SlaveContext>> getSlaveInformation() {
        HashSet<Integer> machineIds = new HashSet<Integer>();
        Map<Channel, SlaveContext> map = this.connectedSlaveChannels;
        synchronized (map) {
            for (SlaveContext context : this.connectedSlaveChannels.values()) {
                machineIds.add(context.machineId());
            }
        }
        Map<Integer, Collection<SlaveContext>> ongoingTransactions = ((MasterImpl)this.realMaster).getOngoingTransactions();
        for (Integer machineId : machineIds) {
            if (ongoingTransactions.containsKey(machineId)) continue;
            ongoingTransactions.put(machineId, Collections.emptyList());
        }
        return new TreeMap<Integer, Collection<SlaveContext>>(ongoingTransactions);
    }

    private class ServerHandler
    extends SimpleChannelHandler {
        private ServerHandler() {
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
            try {
                MasterInvoker invoker = (MasterInvoker)event.getMessage();
                Response<DataWriter> result = invoker.invoke(MasterServer.this.realMaster);
                event.getChannel().write((Object)new ChunkedResponse(result));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            e.getCause().printStackTrace();
        }
    }
}

