/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.comm;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.neo4j.kernel.ha.comm.TransactionDataReader;

public class ResponseDecoder
extends FrameDecoder {
    private static final int HEADER_SIZE = 2;
    private TransactionDataReader data = null;

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (this.data != null) {
            Object result = this.data.read(buffer);
            if (result != null) {
                this.data = null;
            }
            return result;
        }
        if (buffer.readableBytes() >= 2) {
            short header = buffer.getShort(buffer.readerIndex());
            if (header < 0) {
                header = -header;
                this.data = TransactionDataReader.tryInitStream(header, buffer);
            } else {
                if (buffer.readableBytes() < 2 + header) {
                    return null;
                }
                ChannelBuffer frame = buffer.factory().getBuffer((int)header);
                int index = buffer.readerIndex() + 2;
                frame.writeBytes(buffer, index, (int)header);
                buffer.readerIndex(index + header);
                return frame;
            }
        }
        return null;
    }
}

