/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.comm;

import java.io.IOException;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.neo4j.kernel.ha.comm.TransactionEntry;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

public class TransactionApplier
extends SimpleChannelUpstreamHandler {
    private volatile XaDataSourceManager dataSourceManager;

    public void setDataSourceManager(XaDataSourceManager dataSourceManager) {
        this.dataSourceManager = dataSourceManager;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object message = e.getMessage();
        if (message instanceof TransactionEntry) {
            this.apply((TransactionEntry)message);
        } else {
            ctx.sendUpstream((ChannelEvent)e);
        }
    }

    private void apply(TransactionEntry transaction) throws IOException {
        XaDataSource dataSource = this.dataSourceManager.getXaDataSource(transaction.resource);
        dataSource.applyCommittedTransaction(transaction.txId, transaction.data);
    }
}

