/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.comm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.Response;
import org.neo4j.kernel.ha.SlaveContext;
import org.neo4j.kernel.ha.TransactionStream;
import org.neo4j.kernel.ha.comm.ByteArrayIteratorChannel;
import org.neo4j.kernel.ha.comm.CommunicationUtils;
import org.neo4j.kernel.ha.comm.DataWriter;
import org.neo4j.kernel.ha.comm.MasterInvoker;
import org.neo4j.kernel.ha.comm.TransactionEntry;

abstract class TransactionDataReader {
    private static final int TXID_SIZE = 8;
    private static final int DATASIZE_SIZE = 2;
    static final int HEADER_SIZE = 2;

    public static Single tryInitStream(int nameSize, ChannelBuffer buffer) {
        if (buffer.readableBytes() < nameSize + 2 + 8 + 2) {
            return null;
        }
        buffer.skipBytes(2);
        String resource = CommunicationUtils.readString(buffer, nameSize / 2);
        long txId = buffer.readLong();
        int datasize = buffer.readInt();
        return new Single(resource, txId, datasize);
    }

    private TransactionDataReader() {
    }

    abstract Object read(ChannelBuffer var1);

    private static class MultiTransactionEntry
    implements MasterInvoker {
        private final SlaveContext context;
        private final TransactionEntry[] transactions;

        MultiTransactionEntry(SlaveContext context, TransactionEntry[] transactions) {
            this.context = context;
            this.transactions = transactions;
        }

        @Override
        public Response<DataWriter> invoke(Master master) {
            for (int i = this.transactions.length - 1; i >= 0; --i) {
                this.applyTransaction(master, this.transactions[i]);
            }
            return null;
        }

        private Response<Long> applyTransaction(Master master, TransactionEntry transaction) {
            return master.commitSingleResourceTransaction(this.context, transaction.resource, new TransactionStream(Arrays.asList(new Pair((Object)transaction.txId, (Object)transaction.data))));
        }
    }

    public static final class Single
    extends TransactionDataReader {
        private final String resource;
        private final long txId;
        private int leftInChunk;
        private boolean moreChunks;
        private byte[] current;
        private final Collection<byte[]> data;

        Single(String resource, long txId, int chunkSize) {
            this.resource = resource;
            this.txId = txId;
            if (chunkSize < 0) {
                this.moreChunks = true;
                chunkSize = -chunkSize;
            } else {
                this.moreChunks = false;
            }
            this.leftInChunk = chunkSize;
            this.current = new byte[chunkSize];
            this.data = new ArrayList<byte[]>();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        TransactionEntry read(ChannelBuffer buffer) {
            if (this.current == null) {
                if (this.leftInChunk != 0) {
                    this.current = new byte[this.leftInChunk];
                } else {
                    if (!this.moreChunks) return this.done();
                    if (buffer.readableBytes() < 2) return null;
                    short chunkSize = buffer.readShort();
                    if (chunkSize < 0) {
                        this.moreChunks = true;
                        chunkSize = -chunkSize;
                    } else {
                        this.moreChunks = false;
                    }
                    this.leftInChunk = chunkSize;
                    if (chunkSize == 0) {
                        return this.done();
                    }
                    this.current = new byte[this.leftInChunk];
                    this.data.add(this.current);
                }
            }
            int toRead = Math.min(buffer.readableBytes(), this.leftInChunk);
            buffer.readBytes(this.current, this.current.length - this.leftInChunk, toRead);
            if (this.leftInChunk != 0) return null;
            this.current = null;
            if (this.moreChunks) return null;
            return this.done();
        }

        private TransactionEntry done() {
            return new TransactionEntry(this.resource, this.txId, new ByteArrayIteratorChannel(this.data.iterator()));
        }
    }

    public static final class Multiple
    extends TransactionDataReader {
        private final SlaveContext context;
        private int txLeft;
        private Single data = null;
        private final TransactionEntry[] transactions;

        public Multiple(SlaveContext context, int numTransactions) {
            this.context = context;
            this.txLeft = numTransactions;
            this.transactions = new TransactionEntry[numTransactions];
        }

        @Override
        MasterInvoker read(ChannelBuffer buffer) {
            if (this.data != null) {
                TransactionEntry entry = this.data.read(buffer);
                if (entry != null) {
                    this.data = null;
                    return this.addEntry(entry);
                }
            } else if (buffer.readableBytes() >= 2) {
                this.data = Multiple.tryInitStream(buffer.getUnsignedShort(buffer.readerIndex()), buffer);
            }
            return null;
        }

        private MasterInvoker addEntry(TransactionEntry entry) {
            this.transactions[--this.txLeft] = entry;
            if (this.txLeft == 0) {
                return new MultiTransactionEntry(this.context, this.transactions);
            }
            return null;
        }
    }
}

