/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.zookeeper;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperServerWrapper;

public class LocalZooKeeperCluster {
    private final int size;
    private final DataDirectoryPolicy dataDirectoryPolicy;
    private final PortPolicy clientPortPolicy;
    private final PortPolicy serverFirstPortPolicy;
    private final PortPolicy serverSecondPortPolicy;
    private final Collection<ZooKeeperServerWrapper> wrappers = new ArrayList<ZooKeeperServerWrapper>();
    private Collection<String> serversConfig;

    public LocalZooKeeperCluster(int size, File baseDir) throws IOException {
        this(size, LocalZooKeeperCluster.defaultDataDirectoryPolicy(baseDir), LocalZooKeeperCluster.defaultPortPolicy(2181), LocalZooKeeperCluster.defaultPortPolicy(2888), LocalZooKeeperCluster.defaultPortPolicy(3888));
    }

    public LocalZooKeeperCluster(int size, DataDirectoryPolicy dataDirectoryPolicy, PortPolicy clientPortPolicy, PortPolicy serverFirstPortPolicy, PortPolicy serverSecondPortPolicy) throws IOException {
        this.size = size;
        this.dataDirectoryPolicy = dataDirectoryPolicy;
        this.clientPortPolicy = clientPortPolicy;
        this.serverFirstPortPolicy = serverFirstPortPolicy;
        this.serverSecondPortPolicy = serverSecondPortPolicy;
        this.startCluster();
    }

    private void startCluster() throws IOException {
        int id;
        int i;
        ArrayList<String> servers = new ArrayList<String>();
        for (i = 0; i < this.size; ++i) {
            id = i + 1;
            servers.add("localhost:" + this.serverFirstPortPolicy.getPort(id) + ":" + this.serverSecondPortPolicy.getPort(id));
        }
        this.serversConfig = servers;
        for (i = 0; i < this.size; ++i) {
            id = i + 1;
            ZooKeeperServerWrapper wrapper = new ZooKeeperServerWrapper(id, this.dataDirectoryPolicy.getDataDirectory(id), this.clientPortPolicy.getPort(id), servers, Collections.<String, String>emptyMap());
            this.wrappers.add(wrapper);
        }
        this.waitForClusterToBeFullyStarted();
    }

    public Collection<String> getZooKeeperServersConfig() {
        return this.serversConfig;
    }

    public String getZooKeeperServersForHaInstance() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            builder.append((i > 0 ? "," : "") + "localhost:" + this.clientPortPolicy.getPort(i + 1));
        }
        return builder.toString();
    }

    private void waitForClusterToBeFullyStarted() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    public void shutdown() {
        for (ZooKeeperServerWrapper wrapper : this.wrappers) {
            wrapper.shutdown();
        }
    }

    public static DataDirectoryPolicy defaultDataDirectoryPolicy(final File baseDirectory) {
        return new DataDirectoryPolicy(){

            @Override
            public File getDataDirectory(int id) {
                return new File(baseDirectory, this.zeroLeadingId(id, 2));
            }

            private String zeroLeadingId(int id, int minLength) {
                String result = "" + id;
                while (result.length() < minLength) {
                    result = "0" + result;
                }
                return result;
            }
        };
    }

    public static PortPolicy defaultPortPolicy(final int startPort) {
        return new PortPolicy(){

            @Override
            public int getPort(int id) {
                return startPort + id - 1;
            }
        };
    }

    public int getSize() {
        return this.size;
    }

    public DataDirectoryPolicy getDataDirectoryPolicy() {
        return this.dataDirectoryPolicy;
    }

    public PortPolicy getClientPortPolicy() {
        return this.clientPortPolicy;
    }

    public PortPolicy getServerFirstPortPolicy() {
        return this.serverFirstPortPolicy;
    }

    public PortPolicy getServerSecondPortPolicy() {
        return this.serverSecondPortPolicy;
    }

    public static interface PortPolicy {
        public int getPort(int var1);
    }

    public static interface DataDirectoryPolicy {
        public File getDataDirectory(int var1);
    }
}

