/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.zookeeper;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class NeoStoreUtil {
    private static final int RECORD_SIZE = 9;
    private final long creationTime;
    private final long storeId;
    private final long txId;
    private final long version;

    public NeoStoreUtil(String storeDir) {
        try {
            FileChannel fileChannel = new RandomAccessFile(storeDir + "/neostore", "r").getChannel();
            ByteBuffer buf = ByteBuffer.allocate(36);
            if (fileChannel.read(buf) != 36) {
                throw new RuntimeException("Unable to read neo store header information");
            }
            buf.flip();
            buf.get();
            this.creationTime = buf.getLong();
            buf.get();
            this.storeId = buf.getLong();
            buf.get();
            this.version = buf.getLong();
            buf.get();
            this.txId = buf.getLong();
            fileChannel.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getStoreId() {
        return this.storeId;
    }

    public long getLastCommittedTx() {
        return this.txId;
    }

    public long getVersion() {
        return this.version;
    }
}

