/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.junit.Ignore;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.AbstractBroker;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.FakeMasterBroker;
import org.neo4j.kernel.ha.FakeSlaveBroker;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterClient;
import org.neo4j.management.HighAvailability;
import org.neo4j.test.SubProcess;
import slavetest.Job;

@Ignore
public class StandaloneDatabase {
    private final Controller process;

    public static StandaloneDatabase withDefaultBroker(String testMethodName, File path, int machineId, String zooKeeperConnection, String haServer, String[] extraArgs) {
        return new StandaloneDatabase(testMethodName, new Bootstrap(path, machineId, new String[]{"ha.server", haServer, "ha.zoo_keeper_servers", zooKeeperConnection}){

            @Override
            HighlyAvailableGraphDatabase start(String storeDir, Map<String, String> config) {
                HighlyAvailableGraphDatabase db = new HighlyAvailableGraphDatabase(storeDir, config);
                System.out.println("Started HA db (w/ zoo keeper)");
                return db;
            }
        });
    }

    public static StandaloneDatabase withFakeBroker(String testMethodName, File path, int machineId, final int masterId, String[] extraArgs) {
        StandaloneDatabase standalone = new StandaloneDatabase(testMethodName, new Bootstrap(path, machineId, new String[0]){

            @Override
            HighlyAvailableGraphDatabase start(String storeDir, Map<String, String> config) {
                Object broker = this.machineId == masterId ? new FakeMasterBroker(this.machineId, storeDir) : new FakeSlaveBroker((Master)new MasterClient("localhost", 8901, storeDir), masterId, this.machineId, storeDir);
                HighlyAvailableGraphDatabase db = new HighlyAvailableGraphDatabase(storeDir, config, AbstractBroker.wrapSingleBroker((Broker)broker));
                System.out.println("Started HA db (w/o zoo keeper)");
                return db;
            }
        });
        standalone.awaitStarted();
        return standalone;
    }

    private StandaloneDatabase(String testMethodName, Bootstrap bootstrap) {
        this.process = (Controller)new HaDbProcess(testMethodName).start(bootstrap);
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.process;
    }

    public void awaitStarted() {
        this.process.awaitStarted();
    }

    public <T> T executeJob(Job<T> job) throws Exception {
        return this.process.executeJob(job);
    }

    public int getMachineId() {
        return this.process.getMachineId();
    }

    public void pullUpdates() {
        this.process.pullUpdates();
    }

    public void shutdown() {
        SubProcess.stop((Object)this.process);
    }

    private static class TimestampStream
    extends PrintStream {
        ThreadLocal<DateFormat> timestamp = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat("[HH:mm:ss:SS] ");
            }
        };

        TimestampStream(PrintStream out) {
            super(out);
        }

        @Override
        public void println(String string) {
            super.println(this.timestamp.get().format(new Date()) + string);
        }
    }

    private static class HaDbProcess
    extends SubProcess<Controller, Bootstrap>
    implements Controller {
        private volatile transient DatabaseReference db = null;
        private final String testMethodName;

        private HaDbProcess(String testMethodName) {
            this.testMethodName = testMethodName;
        }

        private HighlyAvailableGraphDatabase db() {
            DatabaseReference ref = this.db;
            if (ref == null) {
                throw new IllegalStateException("database has not been started");
            }
            if (ref.graph == null) {
                throw new IllegalStateException("database has been shut down");
            }
            return ref.graph;
        }

        private synchronized boolean db(HighlyAvailableGraphDatabase graph) {
            if (this.db != null && graph != null) {
                return false;
            }
            this.db = new DatabaseReference(graph);
            return true;
        }

        public String toString() {
            return this.testMethodName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected synchronized void startup(Bootstrap bootstrap) {
            System.setOut(new TimestampStream(System.out));
            System.setErr(new TimestampStream(System.err));
            if (this.db != null) {
                throw new IllegalStateException("already started");
            }
            System.out.println("About to start");
            HighlyAvailableGraphDatabase graph = null;
            try {
                graph = bootstrap.start();
                System.out.println(graph != null ? "startup completed successfully" : "startup failed");
                if (this.db(graph) || graph == null) return;
            }
            catch (Throwable throwable) {
                System.out.println(graph != null ? "startup completed successfully" : "startup failed");
                if (this.db(graph) || graph == null) throw throwable;
                graph.shutdown();
                throw new IllegalStateException("already started");
            }
            graph.shutdown();
            throw new IllegalStateException("already started");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void shutdown() {
            DatabaseReference ref = this.db;
            if (ref == null) {
                System.out.println("Shutdown attempted before completion of startup");
                throw new IllegalStateException("database has not been started");
            }
            System.out.println("Shutdown started");
            try {
                if (ref.graph != null) {
                    ref.graph.shutdown();
                } else {
                    System.out.println("database has already been shutdown");
                }
            }
            finally {
                this.db(null);
            }
            System.out.println("Shutdown completed");
            super.shutdown();
        }

        @Override
        public void awaitStarted() {
            boolean interrupted = false;
            while (this.db == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    Thread.interrupted();
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public <T> T executeJob(Job<T> job) throws Exception {
            HighlyAvailableGraphDatabase database = this.db();
            System.out.println("Executing job " + job);
            T result = job.execute((GraphDatabaseService)database);
            System.out.println("Job " + job + " executed");
            return result;
        }

        @Override
        public int getMachineId() {
            return Integer.parseInt(((HighAvailability)this.db().getManagementBean(HighAvailability.class)).getMachineId());
        }

        @Override
        public void pullUpdates() {
            HighlyAvailableGraphDatabase database = this.db();
            System.out.println("pullUpdates");
            database.pullUpdates();
        }

        private static class DatabaseReference {
            final HighlyAvailableGraphDatabase graph;

            DatabaseReference(HighlyAvailableGraphDatabase graph) {
                this.graph = graph;
            }
        }
    }

    public static abstract class Bootstrap
    implements Serializable {
        private final String[] config;
        private final File storeDir;
        final int machineId;

        private Bootstrap(File storeDir, int machineId, String ... config) {
            this.storeDir = storeDir;
            this.machineId = machineId;
            this.config = config;
        }

        final HighlyAvailableGraphDatabase start() {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("ha.machine_id", Integer.toString(this.machineId));
            for (int i = 0; i < this.config.length; i += 2) {
                params.put(this.config[i], this.config[i + 1]);
            }
            return this.start(this.storeDir.getAbsolutePath(), params);
        }

        abstract HighlyAvailableGraphDatabase start(String var1, Map<String, String> var2);
    }

    public static interface Controller {
        public void pullUpdates();

        public void awaitStarted();

        public int getMachineId();

        public <T> T executeJob(Job<T> var1) throws Exception;
    }
}

