/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.neo4j.ha.LocalhostZooKeeperCluster;
import org.neo4j.ha.StandaloneDatabase;
import slavetest.Job;
import slavetest.MultiJvmTest;

@Ignore
public class MultiJvmWithZooKeeperTest
extends MultiJvmTest {
    private static final File BASE_ZOO_KEEPER_DATA_DIR = new File(new File("target"), "zookeeper-data");
    private static final int BASE_HA_SERVER_PORT = 5559;
    private static LocalhostZooKeeperCluster zooKeeperCluster;
    private final Map<Integer, StandaloneDatabase> jvmByMachineId = new HashMap<Integer, StandaloneDatabase>();

    @Before
    public void startZooKeeperCluster() throws Exception {
        FileUtils.deleteDirectory((File)BASE_ZOO_KEEPER_DATA_DIR);
        zooKeeperCluster = new LocalhostZooKeeperCluster(this.getClass(), 2181, 2182, 2183);
    }

    @Override
    protected void initializeDbs(int numSlaves, Map<String, String> config) throws Exception {
        super.initializeDbs(numSlaves, config);
        for (StandaloneDatabase db : this.jvmByMachineId.values()) {
            db.awaitStarted();
        }
    }

    @Override
    protected StandaloneDatabase spawnJvm(File path, int machineId, String ... extraArgs) throws Exception {
        StandaloneDatabase db = StandaloneDatabase.withDefaultBroker(this.testName.getMethodName(), path.getAbsoluteFile(), machineId, zooKeeperCluster.getConnectionString(), MultiJvmWithZooKeeperTest.buildHaServerConfigValue(machineId), extraArgs);
        this.jvmByMachineId.put(machineId + 1, db);
        return db;
    }

    private static String buildHaServerConfigValue(int machineId) {
        return "localhost:" + (5559 + machineId);
    }

    @Override
    protected <T> T executeJobOnMaster(Job<T> job) throws Exception {
        return this.jvmByMachineId.get(1).executeJob(job);
    }

    @After
    public void shutdownZooKeeperCluster() {
        zooKeeperCluster.shutdown();
    }
}

