/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldPrepender;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Triplet;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.ha.BlockLogBuffer;
import org.neo4j.kernel.ha.BlockLogReader;
import org.neo4j.kernel.ha.IdAllocation;
import org.neo4j.kernel.ha.LockResult;
import org.neo4j.kernel.ha.LockStatus;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.Response;
import org.neo4j.kernel.ha.SlaveContext;
import org.neo4j.kernel.ha.StoreWriter;
import org.neo4j.kernel.ha.TransactionStream;
import org.neo4j.kernel.ha.TxExtractor;
import org.neo4j.kernel.impl.nioneo.store.IdRange;

public abstract class CommunicationProtocol {
    public static final int PORT = 8901;
    private static final int MEGA = 0x100000;
    static final int MAX_FRAME_LENGTH = 0x1000000;
    static final ObjectSerializer<Integer> INTEGER_SERIALIZER = new ObjectSerializer<Integer>(){

        @Override
        public void write(Integer responseObject, ChannelBuffer result) throws IOException {
            result.writeInt(responseObject.intValue());
        }
    };
    static final ObjectSerializer<Long> LONG_SERIALIZER = new ObjectSerializer<Long>(){

        @Override
        public void write(Long responseObject, ChannelBuffer result) throws IOException {
            result.writeLong(responseObject.longValue());
        }
    };
    static final ObjectSerializer<Void> VOID_SERIALIZER = new ObjectSerializer<Void>(){

        @Override
        public void write(Void responseObject, ChannelBuffer result) throws IOException {
        }
    };
    static final ObjectSerializer<LockResult> LOCK_SERIALIZER = new ObjectSerializer<LockResult>(){

        @Override
        public void write(LockResult responseObject, ChannelBuffer result) throws IOException {
            result.writeByte(responseObject.getStatus().ordinal());
            if (responseObject.getStatus().hasMessage()) {
                CommunicationProtocol.writeString(result, responseObject.getDeadlockMessage());
            }
        }
    };
    protected static final Deserializer<LockResult> LOCK_RESULT_DESERIALIZER = new Deserializer<LockResult>(){

        @Override
        public LockResult read(ChannelBuffer buffer) throws IOException {
            LockStatus status = LockStatus.values()[buffer.readByte()];
            return status.hasMessage() ? new LockResult(CommunicationProtocol.readString(buffer)) : new LockResult(status);
        }
    };
    protected static final Deserializer<Integer> INTEGER_DESERIALIZER = new Deserializer<Integer>(){

        @Override
        public Integer read(ChannelBuffer buffer) throws IOException {
            return buffer.readInt();
        }
    };
    protected static final Deserializer<Void> VOID_DESERIALIZER = new Deserializer<Void>(){

        @Override
        public Void read(ChannelBuffer buffer) throws IOException {
            return null;
        }
    };
    protected static final Serializer EMPTY_SERIALIZER = new Serializer(){

        @Override
        public void write(ChannelBuffer buffer, ByteBuffer readBuffer) throws IOException {
        }
    };

    static void addLengthFieldPipes(ChannelPipeline pipeline) {
        pipeline.addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(0x1000004, 0, 4, 0, 4));
        pipeline.addLast("frameEncoder", (ChannelHandler)new LengthFieldPrepender(4));
    }

    static <T> void writeTransactionStreams(TransactionStream txStream, ChannelBuffer buffer, ByteBuffer readBuffer) throws IOException {
        String[] datasources = txStream.dataSourceNames();
        assert (datasources.length <= 255) : "too many data sources";
        buffer.writeByte(datasources.length);
        HashMap<String, Integer> datasourceId = new HashMap<String, Integer>();
        for (int i = 0; i < datasources.length; ++i) {
            String datasource = datasources[i];
            CommunicationProtocol.writeString(buffer, datasource);
            datasourceId.put(datasource, i + 1);
        }
        for (Triplet tx : IteratorUtil.asIterable((Iterator)((Object)txStream))) {
            buffer.writeByte(((Integer)datasourceId.get(tx.first())).intValue());
            buffer.writeLong(((Long)tx.second()).longValue());
            BlockLogBuffer blockBuffer = new BlockLogBuffer(buffer);
            ((TxExtractor)tx.third()).extract(blockBuffer);
            blockBuffer.done();
        }
        buffer.writeByte(0);
    }

    protected static TransactionStream readTransactionStreams(final ChannelBuffer buffer) {
        final String[] datasources = CommunicationProtocol.readTransactionStreamHeader(buffer);
        return new TransactionStream(new String[0]){

            protected Triplet<String, Long, TxExtractor> fetchNextOrNull() {
                CommunicationProtocol.makeSureNextTransactionIsFullyFetched(buffer);
                String datasource = datasources[buffer.readUnsignedByte()];
                if (datasource == null) {
                    return null;
                }
                long txId = buffer.readLong();
                TxExtractor extractor = TxExtractor.create(new BlockLogReader(buffer));
                return Triplet.of((Object)datasource, (Object)txId, (Object)extractor);
            }

            @Override
            public String[] dataSourceNames() {
                return Arrays.copyOfRange(datasources, 1, datasources.length);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void makeSureNextTransactionIsFullyFetched(ChannelBuffer buffer) {
        buffer.markReaderIndex();
        try {
            if (buffer.readUnsignedByte() > 0) {
                buffer.skipBytes(8);
                short blockSize = 0;
                while ((blockSize = buffer.readUnsignedByte()) == 0) {
                    buffer.skipBytes(255);
                }
                buffer.skipBytes((int)blockSize);
            }
        }
        finally {
            buffer.resetReaderIndex();
        }
    }

    protected static String[] readTransactionStreamHeader(ChannelBuffer buffer) {
        String[] datasources = new String[buffer.readUnsignedByte() + 1];
        datasources[0] = null;
        for (int i = 1; i < datasources.length; ++i) {
            datasources[i] = CommunicationProtocol.readString(buffer);
        }
        return datasources;
    }

    protected static IdAllocation readIdAllocation(ChannelBuffer buffer) {
        int numberOfDefragIds = buffer.readInt();
        long[] defragIds = new long[numberOfDefragIds];
        for (int i = 0; i < numberOfDefragIds; ++i) {
            defragIds[i] = buffer.readLong();
        }
        long rangeStart = buffer.readLong();
        int rangeLength = buffer.readInt();
        long highId = buffer.readLong();
        long defragCount = buffer.readLong();
        return new IdAllocation(new IdRange(defragIds, rangeStart, rangeLength), highId, defragCount);
    }

    protected static void writeString(ChannelBuffer buffer, String name) {
        char[] chars = name.toCharArray();
        buffer.writeInt(chars.length);
        CommunicationProtocol.writeChars(buffer, chars);
    }

    private static void writeChars(ChannelBuffer buffer, char[] chars) {
        for (char ch : chars) {
            buffer.writeChar((int)ch);
        }
    }

    protected static String readString(ChannelBuffer buffer) {
        return CommunicationProtocol.readString(buffer, buffer.readInt());
    }

    protected static String readString(ChannelBuffer buffer, int length) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = buffer.readChar();
        }
        return new String(chars);
    }

    protected static void writeSlaveContext(ChannelBuffer buffer, SlaveContext context) {
        buffer.writeInt(context.machineId());
        buffer.writeInt(context.getEventIdentifier());
        Pair<String, Long>[] txs = context.lastAppliedTransactions();
        buffer.writeByte(txs.length);
        for (Pair<String, Long> tx : txs) {
            CommunicationProtocol.writeString(buffer, (String)tx.first());
            buffer.writeLong(((Long)tx.other()).longValue());
        }
    }

    static SlaveContext readSlaveContext(ChannelBuffer buffer) {
        int machineId = buffer.readInt();
        int eventIdentifier = buffer.readInt();
        int txsSize = buffer.readByte();
        Pair[] lastAppliedTransactions = new Pair[txsSize];
        for (int i = 0; i < txsSize; ++i) {
            lastAppliedTransactions[i] = Pair.of((Object)CommunicationProtocol.readString(buffer), (Object)buffer.readLong());
        }
        return new SlaveContext(machineId, eventIdentifier, lastAppliedTransactions);
    }

    protected static interface MasterCaller<T> {
        public Response<T> callMaster(Master var1, SlaveContext var2, ChannelBuffer var3, ChannelBuffer var4);
    }

    protected static interface ObjectSerializer<T> {
        public void write(T var1, ChannelBuffer var2) throws IOException;
    }

    protected static interface Deserializer<T> {
        public T read(ChannelBuffer var1) throws IOException;
    }

    protected static interface Serializer {
        public void write(ChannelBuffer var1, ByteBuffer var2) throws IOException;
    }

    static abstract class AquireLockCall
    implements MasterCaller<LockResult> {
        AquireLockCall() {
        }

        @Override
        public Response<LockResult> callMaster(Master master, SlaveContext context, ChannelBuffer input, ChannelBuffer target) {
            long[] ids = new long[input.readInt()];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = input.readLong();
            }
            return this.lock(master, context, ids);
        }

        abstract Response<LockResult> lock(Master var1, SlaveContext var2, long ... var3);
    }

    protected static class AcquireLockSerializer
    implements Serializer {
        private final long[] entities;

        AcquireLockSerializer(long ... entities) {
            this.entities = entities;
        }

        @Override
        public void write(ChannelBuffer buffer, ByteBuffer readBuffer) throws IOException {
            buffer.writeInt(this.entities.length);
            for (long entity : this.entities) {
                buffer.writeLong(entity);
            }
        }
    }

    public static enum RequestType {
        ALLOCATE_IDS(new MasterCaller<IdAllocation>(){

            @Override
            public Response<IdAllocation> callMaster(Master master, SlaveContext context, ChannelBuffer input, ChannelBuffer target) {
                IdType idType = IdType.values()[input.readByte()];
                return Response.wrapResponseObjectOnly(master.allocateIds(idType));
            }
        }, new ObjectSerializer<IdAllocation>(){

            @Override
            public void write(IdAllocation idAllocation, ChannelBuffer result) throws IOException {
                IdRange idRange = idAllocation.getIdRange();
                result.writeInt(idRange.getDefragIds().length);
                for (long id : idRange.getDefragIds()) {
                    result.writeLong(id);
                }
                result.writeLong(idRange.getRangeStart());
                result.writeInt(idRange.getRangeLength());
                result.writeLong(idAllocation.getHighestIdInUse());
                result.writeLong(idAllocation.getDefragCount());
            }
        }, false),
        CREATE_RELATIONSHIP_TYPE(new MasterCaller<Integer>(){

            @Override
            public Response<Integer> callMaster(Master master, SlaveContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.createRelationshipType(context, CommunicationProtocol.readString(input));
            }
        }, INTEGER_SERIALIZER),
        ACQUIRE_NODE_WRITE_LOCK(new AquireLockCall(){

            @Override
            Response<LockResult> lock(Master master, SlaveContext context, long ... ids) {
                return master.acquireNodeWriteLock(context, ids);
            }
        }, LOCK_SERIALIZER),
        ACQUIRE_NODE_READ_LOCK(new AquireLockCall(){

            @Override
            Response<LockResult> lock(Master master, SlaveContext context, long ... ids) {
                return master.acquireNodeReadLock(context, ids);
            }
        }, LOCK_SERIALIZER),
        ACQUIRE_RELATIONSHIP_WRITE_LOCK(new AquireLockCall(){

            @Override
            Response<LockResult> lock(Master master, SlaveContext context, long ... ids) {
                return master.acquireRelationshipWriteLock(context, ids);
            }
        }, LOCK_SERIALIZER),
        ACQUIRE_RELATIONSHIP_READ_LOCK(new AquireLockCall(){

            @Override
            Response<LockResult> lock(Master master, SlaveContext context, long ... ids) {
                return master.acquireRelationshipReadLock(context, ids);
            }
        }, LOCK_SERIALIZER),
        COMMIT(new MasterCaller<Long>(){

            @Override
            public Response<Long> callMaster(Master master, SlaveContext context, ChannelBuffer input, ChannelBuffer target) {
                String resource = CommunicationProtocol.readString(input);
                BlockLogReader reader = new BlockLogReader(input);
                return master.commitSingleResourceTransaction(context, resource, TxExtractor.create(reader));
            }
        }, LONG_SERIALIZER),
        PULL_UPDATES(new MasterCaller<Void>(){

            @Override
            public Response<Void> callMaster(Master master, SlaveContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.pullUpdates(context);
            }
        }, VOID_SERIALIZER),
        FINISH(new MasterCaller<Void>(){

            @Override
            public Response<Void> callMaster(Master master, SlaveContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.finishTransaction(context);
            }
        }, VOID_SERIALIZER),
        GET_MASTER_ID_FOR_TX(new MasterCaller<Integer>(){

            @Override
            public Response<Integer> callMaster(Master master, SlaveContext context, ChannelBuffer input, ChannelBuffer target) {
                int masterId = master.getMasterIdForCommittedTx(input.readLong());
                return Response.wrapResponseObjectOnly(masterId);
            }
        }, INTEGER_SERIALIZER, false),
        COPY_STORE(new MasterCaller<Void>(){

            @Override
            public Response<Void> callMaster(Master master, SlaveContext context, ChannelBuffer input, final ChannelBuffer target) {
                return master.copyStore(context, new StoreWriter(){

                    @Override
                    public void write(String path, ReadableByteChannel data, boolean hasData) throws IOException {
                        char[] chars = path.toCharArray();
                        target.writeShort(chars.length);
                        CommunicationProtocol.writeChars(target, chars);
                        target.writeByte(hasData ? 1 : 0);
                        BlockLogBuffer buffer = new BlockLogBuffer(target);
                        if (hasData) {
                            buffer.write(data);
                            buffer.done();
                        }
                    }

                    @Override
                    public void done() {
                        target.writeShort(0);
                    }
                });
            }
        }, VOID_SERIALIZER);

        final MasterCaller caller;
        final ObjectSerializer serializer;
        private final boolean includesSlaveContext;

        private <T> RequestType(MasterCaller<T> caller, ObjectSerializer<T> serializer, boolean includesSlaveContext) {
            this.caller = caller;
            this.serializer = serializer;
            this.includesSlaveContext = includesSlaveContext;
        }

        private <T> RequestType(MasterCaller<T> caller, ObjectSerializer<T> serializer) {
            this(caller, serializer, true);
        }

        public boolean includesSlaveContext() {
            return this.includesSlaveContext;
        }
    }
}

