/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBufferIndexFinder;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.queue.BlockingReadHandler;
import org.neo4j.kernel.ha.HaCommunicationException;

public class DechunkingChannelBuffer
implements ChannelBuffer {
    private final BlockingReadHandler<ChannelBuffer> reader;
    private ChannelBuffer buffer;
    private boolean more;
    private boolean hasMarkedReaderIndex;

    DechunkingChannelBuffer(BlockingReadHandler<ChannelBuffer> reader) {
        this.reader = reader;
        this.readNextChunk();
    }

    protected ChannelBuffer readNext() {
        try {
            return (ChannelBuffer)this.reader.read(20L, TimeUnit.SECONDS);
        }
        catch (IOException e) {
            throw new HaCommunicationException(e);
        }
        catch (InterruptedException e) {
            throw new HaCommunicationException(e);
        }
    }

    private void readNextChunkIfNeeded(int bytesPlus) {
        if (this.buffer.readableBytes() < bytesPlus && this.more) {
            this.readNextChunk();
        }
    }

    private void readNextChunk() {
        ChannelBuffer readBuffer = this.readNext();
        boolean bl = this.more = readBuffer.readByte() == 1;
        if (!this.more && this.buffer == null) {
            this.buffer = readBuffer;
        } else {
            this.buffer = this.buffer == null ? ChannelBuffers.dynamicBuffer() : this.buffer;
            this.discardReadBytes();
            this.buffer.writeBytes(readBuffer);
        }
    }

    public ChannelBufferFactory factory() {
        return this.buffer.factory();
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public ByteOrder order() {
        return this.buffer.order();
    }

    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    public int readerIndex() {
        return this.buffer.readerIndex();
    }

    public void readerIndex(int readerIndex) {
        this.buffer.readerIndex(readerIndex);
    }

    public int writerIndex() {
        return this.buffer.writerIndex();
    }

    public void writerIndex(int writerIndex) {
        this.buffer.writerIndex(writerIndex);
    }

    public void setIndex(int readerIndex, int writerIndex) {
        this.buffer.setIndex(readerIndex, writerIndex);
    }

    public int readableBytes() {
        return this.buffer.readableBytes();
    }

    public int writableBytes() {
        return 0;
    }

    public boolean readable() {
        this.readNextChunkIfNeeded(1);
        return this.buffer.readable();
    }

    public boolean writable() {
        return this.buffer.writable();
    }

    public void clear() {
        this.buffer.clear();
    }

    public void markReaderIndex() {
        this.buffer.markReaderIndex();
        this.hasMarkedReaderIndex = true;
    }

    public void resetReaderIndex() {
        this.buffer.resetReaderIndex();
        this.hasMarkedReaderIndex = false;
    }

    public void markWriterIndex() {
        this.buffer.markWriterIndex();
    }

    public void resetWriterIndex() {
        this.buffer.resetWriterIndex();
    }

    public void discardReadBytes() {
        int oldReaderIndex = this.buffer.readerIndex();
        if (this.hasMarkedReaderIndex) {
            this.buffer.resetReaderIndex();
        }
        int bytesToDiscard = this.buffer.readerIndex();
        this.buffer.discardReadBytes();
        if (this.hasMarkedReaderIndex) {
            this.buffer.readerIndex(oldReaderIndex - bytesToDiscard);
        }
    }

    public void ensureWritableBytes(int writableBytes) {
        this.buffer.ensureWritableBytes(writableBytes);
    }

    public byte getByte(int index) {
        this.readNextChunkIfNeeded(1);
        return this.buffer.getByte(index);
    }

    public short getUnsignedByte(int index) {
        this.readNextChunkIfNeeded(1);
        return this.buffer.getUnsignedByte(index);
    }

    public short getShort(int index) {
        this.readNextChunkIfNeeded(2);
        return this.buffer.getShort(index);
    }

    public int getUnsignedShort(int index) {
        this.readNextChunkIfNeeded(2);
        return this.buffer.getUnsignedShort(index);
    }

    public int getMedium(int index) {
        this.readNextChunkIfNeeded(4);
        return this.buffer.getMedium(index);
    }

    public int getUnsignedMedium(int index) {
        this.readNextChunkIfNeeded(4);
        return this.buffer.getUnsignedMedium(index);
    }

    public int getInt(int index) {
        this.readNextChunkIfNeeded(4);
        return this.buffer.getInt(index);
    }

    public long getUnsignedInt(int index) {
        this.readNextChunkIfNeeded(4);
        return this.buffer.getUnsignedInt(index);
    }

    public long getLong(int index) {
        this.readNextChunkIfNeeded(8);
        return this.buffer.getLong(index);
    }

    public char getChar(int index) {
        this.readNextChunkIfNeeded(2);
        return this.buffer.getChar(index);
    }

    public float getFloat(int index) {
        this.readNextChunkIfNeeded(8);
        return this.buffer.getFloat(index);
    }

    public double getDouble(int index) {
        this.readNextChunkIfNeeded(8);
        return this.buffer.getDouble(index);
    }

    public void getBytes(int index, ChannelBuffer dst) {
        this.readNextChunkIfNeeded(dst.writableBytes());
        this.buffer.getBytes(index, dst);
    }

    public void getBytes(int index, ChannelBuffer dst, int length) {
        this.readNextChunkIfNeeded(length);
        this.buffer.getBytes(index, dst, length);
    }

    public void getBytes(int index, ChannelBuffer dst, int dstIndex, int length) {
        this.readNextChunkIfNeeded(length);
        this.buffer.getBytes(index, dst, dstIndex, length);
    }

    public void getBytes(int index, byte[] dst) {
        this.readNextChunkIfNeeded(dst.length);
        this.buffer.getBytes(index, dst);
    }

    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.readNextChunkIfNeeded(length);
        this.buffer.getBytes(index, dst, dstIndex, length);
    }

    public void getBytes(int index, ByteBuffer dst) {
        this.readNextChunkIfNeeded(dst.limit());
        this.buffer.getBytes(index, dst);
    }

    public void getBytes(int index, OutputStream out, int length) throws IOException {
        this.readNextChunkIfNeeded(length);
        this.buffer.getBytes(index, out, length);
    }

    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        this.readNextChunkIfNeeded(length);
        return this.buffer.getBytes(index, out, length);
    }

    private UnsupportedOperationException unsupportedOperation() {
        return new UnsupportedOperationException("Not supported in a DechunkingChannelBuffer, it's used merely for reading");
    }

    public void setByte(int index, int value) {
        throw this.unsupportedOperation();
    }

    public void setShort(int index, int value) {
        throw this.unsupportedOperation();
    }

    public void setMedium(int index, int value) {
        throw this.unsupportedOperation();
    }

    public void setInt(int index, int value) {
        throw this.unsupportedOperation();
    }

    public void setLong(int index, long value) {
        throw this.unsupportedOperation();
    }

    public void setChar(int index, int value) {
        throw this.unsupportedOperation();
    }

    public void setFloat(int index, float value) {
        throw this.unsupportedOperation();
    }

    public void setDouble(int index, double value) {
        throw this.unsupportedOperation();
    }

    public void setBytes(int index, ChannelBuffer src) {
        throw this.unsupportedOperation();
    }

    public void setBytes(int index, ChannelBuffer src, int length) {
        throw this.unsupportedOperation();
    }

    public void setBytes(int index, ChannelBuffer src, int srcIndex, int length) {
        throw this.unsupportedOperation();
    }

    public void setBytes(int index, byte[] src) {
        throw this.unsupportedOperation();
    }

    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        throw this.unsupportedOperation();
    }

    public void setBytes(int index, ByteBuffer src) {
        throw this.unsupportedOperation();
    }

    public int setBytes(int index, InputStream in, int length) throws IOException {
        throw this.unsupportedOperation();
    }

    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        throw this.unsupportedOperation();
    }

    public void setZero(int index, int length) {
        throw this.unsupportedOperation();
    }

    public byte readByte() {
        this.readNextChunkIfNeeded(1);
        return this.buffer.readByte();
    }

    public short readUnsignedByte() {
        this.readNextChunkIfNeeded(1);
        return this.buffer.readUnsignedByte();
    }

    public short readShort() {
        this.readNextChunkIfNeeded(2);
        return this.buffer.readShort();
    }

    public int readUnsignedShort() {
        this.readNextChunkIfNeeded(2);
        return this.buffer.readUnsignedShort();
    }

    public int readMedium() {
        this.readNextChunkIfNeeded(4);
        return this.buffer.readMedium();
    }

    public int readUnsignedMedium() {
        this.readNextChunkIfNeeded(4);
        return this.buffer.readUnsignedMedium();
    }

    public int readInt() {
        this.readNextChunkIfNeeded(4);
        return this.buffer.readInt();
    }

    public long readUnsignedInt() {
        this.readNextChunkIfNeeded(4);
        return this.buffer.readUnsignedInt();
    }

    public long readLong() {
        this.readNextChunkIfNeeded(8);
        return this.buffer.readLong();
    }

    public char readChar() {
        this.readNextChunkIfNeeded(2);
        return this.buffer.readChar();
    }

    public float readFloat() {
        this.readNextChunkIfNeeded(8);
        return this.buffer.readFloat();
    }

    public double readDouble() {
        this.readNextChunkIfNeeded(8);
        return this.buffer.readDouble();
    }

    public ChannelBuffer readBytes(int length) {
        this.readNextChunkIfNeeded(length);
        return this.buffer.readBytes(length);
    }

    public ChannelBuffer readBytes(ChannelBufferIndexFinder indexFinder) {
        throw this.unsupportedOperation();
    }

    public ChannelBuffer readSlice(int length) {
        this.readNextChunkIfNeeded(length);
        return this.buffer.readSlice(length);
    }

    public ChannelBuffer readSlice(ChannelBufferIndexFinder indexFinder) {
        throw this.unsupportedOperation();
    }

    public void readBytes(ChannelBuffer dst) {
        this.readNextChunkIfNeeded(dst.writableBytes());
        this.buffer.readBytes(dst);
    }

    public void readBytes(ChannelBuffer dst, int length) {
        this.readNextChunkIfNeeded(length);
        this.buffer.readBytes(dst, length);
    }

    public void readBytes(ChannelBuffer dst, int dstIndex, int length) {
        this.readNextChunkIfNeeded(length);
        this.buffer.readBytes(dst, dstIndex, length);
    }

    public void readBytes(byte[] dst) {
        this.readNextChunkIfNeeded(dst.length);
        this.buffer.readBytes(dst);
    }

    public void readBytes(byte[] dst, int dstIndex, int length) {
        this.readNextChunkIfNeeded(length);
        this.buffer.readBytes(dst, dstIndex, length);
    }

    public void readBytes(ByteBuffer dst) {
        this.readNextChunkIfNeeded(dst.limit());
        this.buffer.readBytes(dst);
    }

    public void readBytes(OutputStream out, int length) throws IOException {
        this.readNextChunkIfNeeded(length);
        this.buffer.readBytes(out, length);
    }

    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        this.readNextChunkIfNeeded(length);
        return this.buffer.readBytes(out, length);
    }

    public void skipBytes(int length) {
        this.readNextChunkIfNeeded(length);
        this.buffer.skipBytes(length);
    }

    public int skipBytes(ChannelBufferIndexFinder indexFinder) {
        throw this.unsupportedOperation();
    }

    public void writeByte(int value) {
        throw this.unsupportedOperation();
    }

    public void writeShort(int value) {
        throw this.unsupportedOperation();
    }

    public void writeMedium(int value) {
        throw this.unsupportedOperation();
    }

    public void writeInt(int value) {
        throw this.unsupportedOperation();
    }

    public void writeLong(long value) {
        throw this.unsupportedOperation();
    }

    public void writeChar(int value) {
        throw this.unsupportedOperation();
    }

    public void writeFloat(float value) {
        throw this.unsupportedOperation();
    }

    public void writeDouble(double value) {
        throw this.unsupportedOperation();
    }

    public void writeBytes(ChannelBuffer src) {
        throw this.unsupportedOperation();
    }

    public void writeBytes(ChannelBuffer src, int length) {
        throw this.unsupportedOperation();
    }

    public void writeBytes(ChannelBuffer src, int srcIndex, int length) {
        throw this.unsupportedOperation();
    }

    public void writeBytes(byte[] src) {
        throw this.unsupportedOperation();
    }

    public void writeBytes(byte[] src, int srcIndex, int length) {
        throw this.unsupportedOperation();
    }

    public void writeBytes(ByteBuffer src) {
        throw this.unsupportedOperation();
    }

    public int writeBytes(InputStream in, int length) throws IOException {
        throw this.unsupportedOperation();
    }

    public int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        throw this.unsupportedOperation();
    }

    public void writeZero(int length) {
        throw this.unsupportedOperation();
    }

    public int indexOf(int fromIndex, int toIndex, byte value) {
        throw this.unsupportedOperation();
    }

    public int indexOf(int fromIndex, int toIndex, ChannelBufferIndexFinder indexFinder) {
        throw this.unsupportedOperation();
    }

    public int bytesBefore(byte value) {
        throw this.unsupportedOperation();
    }

    public int bytesBefore(ChannelBufferIndexFinder indexFinder) {
        throw this.unsupportedOperation();
    }

    public int bytesBefore(int length, byte value) {
        throw this.unsupportedOperation();
    }

    public int bytesBefore(int length, ChannelBufferIndexFinder indexFinder) {
        throw this.unsupportedOperation();
    }

    public int bytesBefore(int index, int length, byte value) {
        throw this.unsupportedOperation();
    }

    public int bytesBefore(int index, int length, ChannelBufferIndexFinder indexFinder) {
        throw this.unsupportedOperation();
    }

    public ChannelBuffer copy() {
        throw this.unsupportedOperation();
    }

    public ChannelBuffer copy(int index, int length) {
        throw this.unsupportedOperation();
    }

    public ChannelBuffer slice() {
        throw this.unsupportedOperation();
    }

    public ChannelBuffer slice(int index, int length) {
        throw this.unsupportedOperation();
    }

    public ChannelBuffer duplicate() {
        throw this.unsupportedOperation();
    }

    public ByteBuffer toByteBuffer() {
        throw this.unsupportedOperation();
    }

    public ByteBuffer toByteBuffer(int index, int length) {
        throw this.unsupportedOperation();
    }

    public ByteBuffer[] toByteBuffers() {
        throw this.unsupportedOperation();
    }

    public ByteBuffer[] toByteBuffers(int index, int length) {
        throw this.unsupportedOperation();
    }

    public boolean hasArray() {
        throw this.unsupportedOperation();
    }

    public byte[] array() {
        throw this.unsupportedOperation();
    }

    public int arrayOffset() {
        throw this.unsupportedOperation();
    }

    public String toString(Charset charset) {
        return this.buffer.toString(charset);
    }

    public String toString(int index, int length, Charset charset) {
        return this.buffer.toString(index, length, charset);
    }

    public String toString(String charsetName) {
        return this.buffer.toString(charsetName);
    }

    public String toString(String charsetName, ChannelBufferIndexFinder terminatorFinder) {
        return this.buffer.toString(charsetName, terminatorFinder);
    }

    public String toString(int index, int length, String charsetName) {
        return this.buffer.toString(index, length, charsetName);
    }

    public String toString(int index, int length, String charsetName, ChannelBufferIndexFinder terminatorFinder) {
        return this.buffer.toString(index, length, charsetName, terminatorFinder);
    }

    public int hashCode() {
        return this.buffer.hashCode();
    }

    public boolean equals(Object obj) {
        return this.buffer.equals(obj);
    }

    public int compareTo(ChannelBuffer buffer) {
        return buffer.compareTo(buffer);
    }

    public String toString() {
        return this.buffer.toString();
    }
}

