/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.kernel.ha.StoreWriter;

public class ToFileStoreWriter
implements StoreWriter {
    private final File basePath;

    public ToFileStoreWriter(String graphDbStoreDir) {
        this.basePath = new File(graphDbStoreDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String path, ReadableByteChannel data, boolean hasData) throws IOException {
        try {
            File file = new File(this.basePath, path);
            RandomAccessFile randomAccessFile = null;
            try {
                file.getParentFile().mkdirs();
                randomAccessFile = new RandomAccessFile(file, "rw");
                if (hasData) {
                    ByteBuffer intermediateBuffer = ByteBuffer.allocateDirect(1024);
                    FileChannel channel = randomAccessFile.getChannel();
                    while (data.read(intermediateBuffer) >= 0) {
                        intermediateBuffer.flip();
                        channel.write(intermediateBuffer);
                        intermediateBuffer.clear();
                    }
                }
            }
            finally {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException(t);
        }
    }

    @Override
    public void done() {
    }
}

