/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.zookeeper;

import java.util.Map;
import javax.management.remote.JMXServiceURL;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.KernelExtension;
import org.neo4j.kernel.ha.AbstractBroker;
import org.neo4j.kernel.ha.ConnectionInformation;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterImpl;
import org.neo4j.kernel.ha.MasterServer;
import org.neo4j.kernel.ha.ResponseReceiver;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.ha.zookeeper.NeoStoreUtil;
import org.neo4j.kernel.ha.zookeeper.RootPathGetter;
import org.neo4j.kernel.ha.zookeeper.ZooClient;
import org.neo4j.management.Neo4jManager;

public class ZooKeeperBroker
extends AbstractBroker {
    private final ZooClient zooClient;
    private final String haServer;
    private final int machineId;

    public ZooKeeperBroker(String storeDir, int machineId, String zooKeeperServers, String haServer, ResponseReceiver receiver) {
        super(machineId, storeDir);
        this.machineId = machineId;
        this.haServer = haServer;
        this.zooClient = new ZooClient(zooKeeperServers, machineId, this.getRootPathGetter(storeDir), receiver, haServer, storeDir);
    }

    private RootPathGetter getRootPathGetter(String storeDir) {
        try {
            new NeoStoreUtil(storeDir);
            return RootPathGetter.forKnownStore(storeDir);
        }
        catch (RuntimeException e) {
            return RootPathGetter.forUnknownStore(storeDir);
        }
    }

    @Override
    public void setConnectionInformation(KernelExtension.KernelData kernel) {
        String instanceId = kernel.instanceId();
        JMXServiceURL url = Neo4jManager.getConnectionURL((KernelExtension.KernelData)kernel);
        if (instanceId != null && url != null) {
            this.zooClient.setJmxConnectionData(url, instanceId);
        }
    }

    @Override
    public ConnectionInformation getConnectionInformation(int machineId) {
        for (ConnectionInformation connection : this.getConnectionInformation()) {
            if (connection.getMachineId() != machineId) continue;
            return connection;
        }
        return null;
    }

    @Override
    public ConnectionInformation[] getConnectionInformation() {
        Map<Integer, Machine> machines = this.zooClient.getAllMachines(false);
        Machine master = this.zooClient.getMasterBasedOn(machines.values());
        ConnectionInformation[] result = new ConnectionInformation[machines.size()];
        int i = 0;
        for (Machine machine : machines.values()) {
            result[i++] = this.addJmxInfo(new ConnectionInformation(machine, master.equals(machine)));
        }
        return result;
    }

    private ConnectionInformation addJmxInfo(ConnectionInformation connect) {
        this.zooClient.getJmxConnectionData(connect);
        return connect;
    }

    @Override
    public Pair<Master, Machine> getMaster() {
        return this.zooClient.getCachedMaster();
    }

    @Override
    public Pair<Master, Machine> getMasterReally() {
        return this.zooClient.getMasterFromZooKeeper(true);
    }

    @Override
    public Machine getMasterExceptMyself() {
        Map<Integer, Machine> machines = this.zooClient.getAllMachines(true);
        machines.remove(this.machineId);
        return this.zooClient.getMasterBasedOn(machines.values());
    }

    @Override
    public Object instantiateMasterServer(GraphDatabaseService graphDb) {
        MasterServer server = new MasterServer(new MasterImpl(graphDb), (Integer)Machine.splitIpAndPort(this.haServer).other(), this.getStoreDir());
        return server;
    }

    @Override
    public void setLastCommittedTxId(long txId) {
        this.zooClient.setCommittedTx(txId);
    }

    @Override
    public boolean iAmMaster() {
        return ((Machine)this.zooClient.getCachedMaster().other()).getMachineId() == this.getMyMachineId();
    }

    @Override
    public void shutdown() {
        this.zooClient.shutdown();
    }

    @Override
    public void rebindMaster() {
        this.zooClient.setDataChangeWatcher("master-rebound", this.machineId);
    }
}

