/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.Map;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.AbstractBroker;
import org.neo4j.kernel.ha.BackupBroker;
import org.neo4j.kernel.ha.MasterClient;
import org.neo4j.kernel.ha.zookeeper.ClusterManager;
import org.neo4j.kernel.ha.zookeeper.Machine;

public class BackupFromHaCluster {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Args arguments;
        String storeDir = arguments.get("path", !(arguments = new Args(args)).orphans().isEmpty() ? (String)arguments.orphans().get(0) : null);
        ClusterManager cluster = new ClusterManager(arguments.get("ha.zoo_keeper_servers", null));
        cluster.waitForSyncConnected();
        Machine master = (Machine)cluster.getCachedMaster().other();
        System.out.println("Master:" + master);
        Map config = MapUtil.stringMap((String[])new String[]{"ha.machine_id", String.valueOf(master.getMachineId())});
        HighlyAvailableGraphDatabase db = new HighlyAvailableGraphDatabase(storeDir, config, AbstractBroker.wrapSingleBroker(new BackupBroker(new MasterClient((String)master.getServer().first(), (Integer)master.getServer().other(), storeDir), storeDir)));
        System.out.println("Leaching backup from master " + master);
        try {
            db.pullUpdates();
            System.out.println("Backup completed successfully");
        }
        finally {
            db.shutdown();
            cluster.shutdown();
        }
    }
}

