/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import javax.transaction.TransactionManager;
import org.neo4j.com.Response;
import org.neo4j.com.TxExtractor;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.HaCommunicationException;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.ResponseReceiver;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperException;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGeneratorFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

public class SlaveTxIdGenerator
implements TxIdGenerator {
    private final Broker broker;
    private final ResponseReceiver receiver;
    private final TxManager txManager;

    public SlaveTxIdGenerator(Broker broker, ResponseReceiver receiver, TransactionManager txManager) {
        this.broker = broker;
        this.receiver = receiver;
        this.txManager = (TxManager)txManager;
    }

    public long generate(final XaDataSource dataSource, final int identifier) {
        try {
            int eventIdentifier = this.txManager.getEventIdentifier();
            Response<Long> response = ((Master)this.broker.getMaster().first()).commitSingleResourceTransaction(this.receiver.getSlaveContext(eventIdentifier), dataSource.getName(), new TxExtractor(){

                public void extract(LogBuffer buffer) {
                    try {
                        dataSource.getPreparedTransaction(identifier, buffer);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                public ReadableByteChannel extract() {
                    try {
                        return dataSource.getPreparedTransaction(identifier);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            return this.receiver.receive(response);
        }
        catch (ZooKeeperException e) {
            this.receiver.newMaster(null, e);
            throw e;
        }
        catch (HaCommunicationException e) {
            this.receiver.newMaster(null, e);
            throw e;
        }
    }

    public int getCurrentMasterId() {
        return ((Machine)this.broker.getMaster().other()).getMachineId();
    }

    public static class SlaveTxIdGeneratorFactory
    implements TxIdGeneratorFactory {
        private final Broker broker;
        private final ResponseReceiver receiver;

        public SlaveTxIdGeneratorFactory(Broker broker, ResponseReceiver receiver) {
            this.broker = broker;
            this.receiver = receiver;
        }

        public TxIdGenerator create(TransactionManager txManager) {
            return new SlaveTxIdGenerator(this.broker, this.receiver, txManager);
        }
    }
}

