/*
 * Decompiled with CFR 0.152.
 */
package jmx;

import java.io.File;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ha.CreateEmptyDb;
import org.neo4j.ha.LocalhostZooKeeperCluster;
import org.neo4j.ha.Neo4jHaCluster;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.management.HighAvailability;
import org.neo4j.management.InstanceInfo;
import org.neo4j.management.Kernel;
import org.neo4j.management.Neo4jManager;
import org.neo4j.test.TargetDirectory;

public class TestHaBean {
    private static final TargetDirectory dir = TargetDirectory.forTest(TestHaBean.class);
    private static LocalhostZooKeeperCluster zk;
    private static HighlyAvailableGraphDatabase db;

    @BeforeClass
    public static void startDb() throws Exception {
        zk = new LocalhostZooKeeperCluster(dir, 2181, 2182);
        File storeDir = dir.graphDbDir(true);
        CreateEmptyDb.at(storeDir);
        db = Neo4jHaCluster.single(zk, storeDir, 3377, MapUtil.stringMap((String[])new String[]{"jmx.port", "9913"}));
    }

    @AfterClass
    public static void stopDb() {
        if (db != null) {
            db.shutdown();
        }
        db = null;
        if (zk != null) {
            zk.shutdown();
        }
        zk = null;
        dir.cleanup();
    }

    @Test
    public void canGetHaBean() throws Exception {
        Neo4jManager neo4j = new Neo4jManager((Kernel)db.getManagementBean(Kernel.class));
        HighAvailability ha = (HighAvailability)neo4j.getBean(HighAvailability.class);
        Assert.assertNotNull((String)"could not get ha bean", (Object)ha);
        Assert.assertTrue((String)"single instance should be master", (boolean)ha.isMaster());
    }

    @Test
    public void canGetInstanceConnectionInformation() throws Exception {
        Neo4jManager neo4j = new Neo4jManager((Kernel)db.getManagementBean(Kernel.class));
        InstanceInfo[] instances = ((HighAvailability)neo4j.getBean(HighAvailability.class)).getInstancesInCluster();
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.length);
        InstanceInfo instance = instances[0];
        Assert.assertNotNull((Object)instance);
        String address = instance.getAddress();
        Assert.assertNotNull((String)"No JMX address for instance", (Object)address);
        String id = instance.getInstanceId();
        Assert.assertNotNull((String)"No instance id", (Object)id);
    }

    @Test
    public void canConnectToInstance() throws Exception {
        Neo4jManager neo4j = new Neo4jManager((Kernel)db.getManagementBean(Kernel.class));
        HighAvailability ha = (HighAvailability)neo4j.getBean(HighAvailability.class);
        InstanceInfo[] instances = ha.getInstancesInCluster();
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.length);
        InstanceInfo instance = instances[0];
        Assert.assertNotNull((Object)instance);
        Pair proc = instance.connect();
        Assert.assertNotNull((String)"could not connect", (Object)proc);
        neo4j = (Neo4jManager)proc.first();
        ha = (HighAvailability)proc.other();
        Assert.assertNotNull((Object)neo4j);
        Assert.assertNotNull((Object)ha);
        instances = ha.getInstancesInCluster();
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.length);
        Assert.assertEquals((Object)instance.getAddress(), (Object)instances[0].getAddress());
        Assert.assertEquals((Object)instance.getInstanceId(), (Object)instances[0].getInstanceId());
    }
}

