/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.BrokerFactory;
import slavetest.CommonJobs;
import slavetest.DoubleLatch;
import slavetest.Fetcher;
import slavetest.Job;
import slavetest.PlaceHolderGraphDatabaseService;

public abstract class AbstractHaTest {
    static final RelationshipType REL_TYPE = DynamicRelationshipType.withName((String)"HA_TEST");
    static final File PARENT_PATH = new File("target/havar");
    static final File DBS_PATH = new File(PARENT_PATH, "dbs");
    static final File SKELETON_DB_PATH = new File(DBS_PATH, "skeleton");
    private boolean expectsResults;
    private int nodeCount;
    private int relCount;
    private int nodePropCount;
    private int relPropCount;
    private int nodeIndexServicePropCount;
    private int nodeIndexProviderPropCount;
    @Rule
    public TestName testName = new TestName(){

        public String getMethodName() {
            return AbstractHaTest.this.getClass().getName() + "." + super.getMethodName();
        }
    };

    public static BrokerFactory wrapBrokerAndSetPlaceHolderDb(final PlaceHolderGraphDatabaseService placeHolderDb, final Broker broker) {
        return new BrokerFactory(){

            public Broker create(GraphDatabaseService graphDb, Map<String, String> graphDbConfig) {
                placeHolderDb.setDb(graphDb);
                return broker;
            }
        };
    }

    protected static File dbPath(int num) {
        return new File(DBS_PATH, "" + num);
    }

    @Before
    public void clearExpectedResults() throws Exception {
        this.clearDbs();
        this.expectsResults = false;
    }

    public void verify(GraphDatabaseService refDb, GraphDatabaseService ... dbs) {
        for (GraphDatabaseService otherDb : dbs) {
            int vNodeCount = 0;
            int vRelCount = 0;
            int vNodePropCount = 0;
            int vRelPropCount = 0;
            int vNodeIndexServicePropCount = 0;
            int vNodeIndexProviderPropCount = 0;
            Set otherNodes = (Set)IteratorUtil.addToCollection(otherDb.getAllNodes().iterator(), new HashSet());
            for (Node node : refDb.getAllNodes()) {
                Node otherNode = otherDb.getNodeById(node.getId());
                int[] counts = AbstractHaTest.verifyNode(node, otherNode, refDb, otherDb);
                vRelCount += counts[0];
                vNodePropCount += counts[1];
                vRelPropCount += counts[2];
                vNodeIndexServicePropCount += counts[3];
                vNodeIndexProviderPropCount += counts[4];
                otherNodes.remove(otherNode);
                ++vNodeCount;
            }
            Assert.assertTrue((boolean)otherNodes.isEmpty());
            if (!this.expectsResults) continue;
            Assert.assertEquals((long)this.nodeCount, (long)vNodeCount);
            Assert.assertEquals((long)this.relCount, (long)vRelCount);
            Assert.assertEquals((long)this.nodePropCount, (long)vNodePropCount);
            Assert.assertEquals((long)this.relPropCount, (long)vRelPropCount);
            Assert.assertEquals((long)this.nodeIndexProviderPropCount, (long)vNodeIndexProviderPropCount);
        }
    }

    private static int[] verifyNode(Node node, Node otherNode, GraphDatabaseService refDb, GraphDatabaseService otherDb) {
        int vNodePropCount = AbstractHaTest.verifyProperties((PropertyContainer)node, (PropertyContainer)otherNode);
        int vNodeIndexProviderProCount = AbstractHaTest.verifyIndexProvider(node, otherNode, refDb, otherDb);
        HashSet<Long> otherRelIds = new HashSet<Long>();
        for (Relationship otherRel : otherNode.getRelationships(Direction.OUTGOING)) {
            otherRelIds.add(otherRel.getId());
        }
        int vRelCount = 0;
        int vRelPropCount = 0;
        for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
            Relationship otherRel = otherDb.getRelationshipById(rel.getId());
            vRelPropCount += AbstractHaTest.verifyProperties((PropertyContainer)rel, (PropertyContainer)otherRel);
            if (rel.getStartNode().getId() != otherRel.getStartNode().getId()) {
                throw new RuntimeException("Start node differs on " + rel);
            }
            if (rel.getEndNode().getId() != otherRel.getEndNode().getId()) {
                throw new RuntimeException("End node differs on " + rel);
            }
            if (!rel.getType().name().equals(otherRel.getType().name())) {
                throw new RuntimeException("Type differs on " + rel);
            }
            otherRelIds.remove(rel.getId());
            ++vRelCount;
        }
        if (!otherRelIds.isEmpty()) {
            Assert.fail((String)("Other node " + otherNode + " has more relationships " + otherRelIds));
        }
        return new int[]{vRelCount, vNodePropCount, vRelPropCount, -1, vNodeIndexProviderProCount};
    }

    private static int verifyIndexProvider(Node node, Node otherNode, GraphDatabaseService refDb, GraphDatabaseService otherDb) {
        int count = 0;
        HashSet<String> otherKeys = new HashSet<String>();
        for (String key : otherNode.getPropertyKeys()) {
            if (!AbstractHaTest.isIndexedWithIndexProvider(otherNode, otherDb, key)) continue;
            otherKeys.add(key);
        }
        count = otherKeys.size();
        for (String key : node.getPropertyKeys()) {
            if (otherKeys.remove(key) == AbstractHaTest.isIndexedWithIndexProvider(node, refDb, key)) continue;
            throw new RuntimeException("Index differs on " + node + ", " + key);
        }
        if (!otherKeys.isEmpty()) {
            throw new RuntimeException("Other node " + otherNode + " has more indexing: " + otherKeys);
        }
        return count;
    }

    private static boolean isIndexedWithIndexProvider(Node node, GraphDatabaseService db, String key) {
        return db.index().forNodes("users").get(key, node.getProperty(key)).getSingle() != null;
    }

    private static int verifyProperties(PropertyContainer entity, PropertyContainer otherEntity) {
        int count = 0;
        Set otherKeys = (Set)IteratorUtil.addToCollection(otherEntity.getPropertyKeys().iterator(), new HashSet());
        for (String key : entity.getPropertyKeys()) {
            Object value1 = entity.getProperty(key);
            Object value2 = otherEntity.getProperty(key);
            if (!(value1.getClass().isArray() && value2.getClass().isArray() || value1.equals(value2))) {
                throw new RuntimeException(entity + " not equals property '" + key + "': " + value1 + ", " + value2);
            }
            otherKeys.remove(key);
            ++count;
        }
        if (!otherKeys.isEmpty()) {
            throw new RuntimeException("Other node " + otherEntity + " has more properties: " + otherKeys);
        }
        return count;
    }

    public static <T> void assertCollection(Collection<T> collection, T ... expectedItems) {
        String collectionString = AbstractHaTest.join(", ", collection.toArray());
        Assert.assertEquals((String)collectionString, (long)expectedItems.length, (long)collection.size());
        for (T item : expectedItems) {
            Assert.assertTrue((boolean)collection.contains(item));
        }
    }

    public static <T> String join(String delimiter, T ... items) {
        StringBuffer buffer = new StringBuffer();
        for (T item : items) {
            if (buffer.length() > 0) {
                buffer.append(delimiter);
            }
            buffer.append(item.toString());
        }
        return buffer.toString();
    }

    private void clearDbs() throws IOException {
        FileUtils.deleteDirectory((File)PARENT_PATH);
    }

    protected void initializeDbs(int numSlaves) throws Exception {
        this.initializeDbs(numSlaves, MapUtil.stringMap((String[])new String[0]));
    }

    protected void initializeDbs(int numSlaves, Map<String, String> config) throws Exception {
        this.startUpMaster(config);
        for (int i = 0; i < numSlaves; ++i) {
            this.addDb(config);
        }
    }

    protected abstract void awaitAllStarted() throws Exception;

    protected abstract void addDb(Map<String, String> var1) throws Exception;

    protected abstract void pullUpdates(int ... var1) throws Exception;

    protected abstract <T> T executeJob(Job<T> var1, int var2) throws Exception;

    protected abstract <T> T executeJobOnMaster(Job<T> var1) throws Exception;

    protected abstract void startUpMaster(Map<String, String> var1) throws Exception;

    protected abstract CommonJobs.ShutdownDispatcher getMasterShutdownDispatcher();

    protected abstract void shutdownDbs() throws Exception;

    protected abstract Fetcher<DoubleLatch> getDoubleLatch() throws Exception;

    protected void setExpectedResults(int nodeCount, int relCount, int nodePropCount, int relPropCount, int nodeIndexServicePropCount, int nodeIndexProviderPropCount) {
        this.expectsResults = true;
        this.nodeCount = nodeCount;
        this.relCount = relCount;
        this.nodePropCount = nodePropCount;
        this.relPropCount = relPropCount;
        this.nodeIndexServicePropCount = nodeIndexServicePropCount;
        this.nodeIndexProviderPropCount = nodeIndexProviderPropCount;
    }

    @Test
    public void slaveCreateNode() throws Exception {
        this.setExpectedResults(3, 2, 2, 2, 0, 0);
        this.initializeDbs(1);
        this.executeJob(new CommonJobs.CreateSomeEntitiesJob(), 0);
    }

    @Test
    public void testMultipleSlaves() throws Exception {
        this.setExpectedResults(2, 1, 1, 1, 0, 0);
        this.initializeDbs(3);
        this.executeJob(new CommonJobs.CreateSubRefNodeJob(CommonJobs.REL_TYPE.name(), null, null), 0);
        this.executeJob(new CommonJobs.SetSubRefPropertyJob("name", "Hello"), 1);
        this.pullUpdates(0, 2);
    }

    @Test
    public void testMasterFailure() throws Exception {
        this.initializeDbs(1);
        Serializable[] result = this.executeJob(new CommonJobs.CreateSubRefNodeMasterFailJob(this.getMasterShutdownDispatcher()), 0);
        Assert.assertFalse((boolean)((Boolean)result[0]));
        this.startUpMaster(MapUtil.stringMap((String[])new String[0]));
        long nodeId = (Long)result[1];
        Boolean existed = this.executeJob(new CommonJobs.GetNodeByIdJob(nodeId), 0);
        Assert.assertFalse((boolean)existed);
    }

    @Test
    public void testSlaveConstraintViolation() throws Exception {
        this.setExpectedResults(2, 1, 0, 1, 0, 0);
        this.initializeDbs(1);
        Long nodeId = this.executeJob(new CommonJobs.CreateSubRefNodeJob(CommonJobs.REL_TYPE.name(), null, null), 0);
        Boolean successful = this.executeJob(new CommonJobs.DeleteNodeJob(nodeId, false), 0);
        Assert.assertFalse((boolean)successful);
    }

    @Test
    public void testMasterConstraintViolation() throws Exception {
        this.setExpectedResults(2, 1, 1, 1, 0, 0);
        this.initializeDbs(1);
        Long nodeId = this.executeJob(new CommonJobs.CreateSubRefNodeJob(CommonJobs.REL_TYPE.name(), "name", "Mattias"), 0);
        Boolean successful = this.executeJobOnMaster(new CommonJobs.DeleteNodeJob(nodeId, false));
        Assert.assertFalse((boolean)successful);
        this.pullUpdates(new int[0]);
    }

    @Test
    public void testGetRelationships() throws Exception {
        this.setExpectedResults(3, 2, 0, 0, 0, 0);
        this.initializeDbs(1);
        Assert.assertEquals((Object)1, (Object)this.executeJob(new CommonJobs.CreateSubRefNodeWithRelCountJob(CommonJobs.REL_TYPE.name(), CommonJobs.REL_TYPE.name(), CommonJobs.KNOWS.name()), 0));
        Assert.assertEquals((Object)2, (Object)this.executeJob(new CommonJobs.CreateSubRefNodeWithRelCountJob(CommonJobs.REL_TYPE.name(), CommonJobs.REL_TYPE.name(), CommonJobs.KNOWS.name()), 0));
        Assert.assertEquals((Object)2, (Object)this.executeJob(new CommonJobs.GetRelationshipCountJob(CommonJobs.REL_TYPE.name(), CommonJobs.KNOWS.name()), 0));
        Assert.assertEquals((Object)2, (Object)this.executeJobOnMaster(new CommonJobs.GetRelationshipCountJob(CommonJobs.REL_TYPE.name(), CommonJobs.KNOWS.name())));
    }

    @Test
    public void testNoTransaction() throws Exception {
        this.setExpectedResults(2, 1, 0, 1, 0, 0);
        this.initializeDbs(1);
        this.executeJobOnMaster(new CommonJobs.CreateSubRefNodeJob(CommonJobs.REL_TYPE.name(), null, null));
        Assert.assertFalse((boolean)this.executeJob(new CommonJobs.CreateNodeOutsideOfTxJob(), 0));
        Assert.assertFalse((boolean)this.executeJobOnMaster(new CommonJobs.CreateNodeOutsideOfTxJob()));
    }

    @Test
    public void testNodeDeleted() throws Exception {
        this.setExpectedResults(1, 0, 0, 0, 0, 0);
        this.initializeDbs(1);
        Long nodeId = this.executeJobOnMaster(new CommonJobs.CreateNodeJob());
        this.pullUpdates(new int[0]);
        Assert.assertTrue((boolean)this.executeJobOnMaster(new CommonJobs.DeleteNodeJob(nodeId, false)));
        Assert.assertFalse((boolean)this.executeJob(new CommonJobs.SetNodePropertyJob(nodeId, "something", "some thing"), 0));
    }

    @Test
    public void testDeadlock() throws Exception {
        this.initializeDbs(2);
        Long[] nodes = this.executeJobOnMaster(new CommonJobs.CreateNodesJob(2));
        this.pullUpdates(new int[0]);
        Fetcher<DoubleLatch> fetcher = this.getDoubleLatch();
        Worker w1 = new Worker(0, new CommonJobs.Worker1Job(nodes[0], nodes[1], fetcher));
        Worker w2 = new Worker(1, new CommonJobs.Worker2Job(nodes[0], nodes[1], fetcher));
        w1.start();
        w2.start();
        w1.join();
        w2.join();
        boolean case1 = w2.successfull && !w2.deadlocked && !w1.successfull && w1.deadlocked;
        boolean case2 = !w2.successfull && w2.deadlocked && w1.successfull && !w1.deadlocked;
        Assert.assertTrue((case1 != case2 ? 1 : 0) != 0);
        Assert.assertTrue((case1 || case2 ? 1 : 0) != 0);
        this.pullUpdates(new int[0]);
    }

    @Test
    public void createNodeAndIndex() throws Exception {
        this.setExpectedResults(2, 0, 1, 0, 1, 0);
        this.initializeDbs(1);
        this.executeJob(new CommonJobs.CreateNodeAndIndexJob("name", "Neo"), 0);
    }

    @Test
    public void indexingAndTwoSlaves() throws Exception {
        this.initializeDbs(2);
        long id = this.executeJobOnMaster(new CommonJobs.CreateNodeAndIndexJob("name", "Morpheus"));
        this.pullUpdates(new int[0]);
        long id2 = this.executeJobOnMaster(new CommonJobs.CreateNodeAndIndexJob("name", "Trinity"));
        this.executeJob(new CommonJobs.AddIndex(id, MapUtil.map((Object[])new Object[]{"key1", new String[]{"value1", "value2"}, "key 2", Float.valueOf(105.43f)})), 1);
        this.pullUpdates(new int[0]);
    }

    @Test
    public void testNewIndexFramework() throws Exception {
        this.setExpectedResults(2, 0, 2, 0, 0, 2);
        this.initializeDbs(2);
        long id = this.executeJobOnMaster(new CommonJobs.CreateNodeAndNewIndexJob("users", "name", "Morpheus", "rank", "Captain"));
        this.pullUpdates(new int[0]);
    }

    @Test
    public void testLargeTransaction() throws Exception {
        this.initializeDbs(1);
        this.executeJob(new CommonJobs.LargeTransactionJob(20, 1), 0);
    }

    @Test
    public void testPullLargeTransaction() throws Exception {
        this.initializeDbs(1);
        this.executeJobOnMaster(new CommonJobs.LargeTransactionJob(20, 1));
        this.pullUpdates(new int[0]);
    }

    @Test
    public void testLargeTransactionData() throws Exception {
        this.initializeDbs(1);
        this.executeJob(new CommonJobs.LargeTransactionJob(1, 20), 0);
    }

    @Test
    public void testPullLargeTransactionData() throws Exception {
        this.initializeDbs(1);
        this.executeJobOnMaster(new CommonJobs.LargeTransactionJob(1, 20));
        this.pullUpdates(new int[0]);
    }

    @Test
    public void makeSureSlaveCanCopyLargeInitialDatabase() throws Exception {
        this.startUpMaster(MapUtil.stringMap((String[])new String[0]));
        this.executeJobOnMaster(new CommonJobs.LargeTransactionJob(1, 60));
        this.addDb(MapUtil.stringMap((String[])new String[0]));
        this.awaitAllStarted();
        this.executeJob(new CommonJobs.CreateSubRefNodeJob("whatever", "my_key", "my_value"), 0);
    }

    @Test
    public void canCopyInitialDbWithLuceneIndexes() throws Exception {
        int additionalNodeCount = 50;
        this.setExpectedResults(1 + additionalNodeCount, 0, additionalNodeCount * 2, 0, 0, additionalNodeCount * 2);
        this.startUpMaster(MapUtil.stringMap((String[])new String[0]));
        for (int i = 0; i < additionalNodeCount; ++i) {
            this.executeJobOnMaster(new CommonJobs.CreateNodeAndNewIndexJob("users", "the key " + i, "the best value", "a key " + i, "the worst value"));
        }
        this.addDb(MapUtil.stringMap((String[])new String[0]));
        this.awaitAllStarted();
    }

    private class Worker
    extends Thread {
        private boolean successfull;
        private boolean deadlocked;
        private final int slave;
        private final Job<Boolean[]> job;

        Worker(int slave, Job<Boolean[]> job) {
            this.slave = slave;
            this.job = job;
        }

        @Override
        public void run() {
            try {
                Boolean[] result = AbstractHaTest.this.executeJob(this.job, this.slave);
                this.successfull = result[0];
                this.deadlocked = result[1];
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

