/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.neo4j.com.FailedResponse;
import org.neo4j.com.MasterUtil;
import org.neo4j.com.Response;
import org.neo4j.com.SlaveContext;
import org.neo4j.com.StoreWriter;
import org.neo4j.com.TxExtractor;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Predicate;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.ha.IdAllocation;
import org.neo4j.kernel.ha.LockResult;
import org.neo4j.kernel.ha.LockStatus;
import org.neo4j.kernel.ha.LockableNode;
import org.neo4j.kernel.ha.LockableRelationship;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.nioneo.store.IdGenerator;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.IllegalResourceException;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

public class MasterImpl
implements Master {
    private static final int ID_GRAB_SIZE = 1000;
    private final GraphDatabaseService graphDb;
    private final Config graphDbConfig;
    private final Map<SlaveContext, Transaction> transactions = Collections.synchronizedMap(new HashMap());
    private static LockGrabber READ_LOCK_GRABBER = new LockGrabber(){

        @Override
        public void grab(LockManager lockManager, LockReleaser lockReleaser, Object entity) {
            lockManager.getReadLock(entity);
            lockReleaser.addLockToTransaction(entity, LockType.READ);
        }
    };
    private static LockGrabber WRITE_LOCK_GRABBER = new LockGrabber(){

        @Override
        public void grab(LockManager lockManager, LockReleaser lockReleaser, Object entity) {
            lockManager.getWriteLock(entity);
            lockReleaser.addLockToTransaction(entity, LockType.WRITE);
        }
    };

    public MasterImpl(GraphDatabaseService db) {
        this.graphDb = db;
        this.graphDbConfig = ((AbstractGraphDatabase)db).getConfig();
    }

    public GraphDatabaseService getGraphDb() {
        return this.graphDb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends PropertyContainer> Response<LockResult> acquireLock(SlaveContext context, LockGrabber lockGrabber, T ... entities) {
        Transaction otherTx = this.suspendOtherAndResumeThis(context);
        try {
            LockManager lockManager = this.graphDbConfig.getLockManager();
            LockReleaser lockReleaser = this.graphDbConfig.getLockReleaser();
            for (T entity : entities) {
                lockGrabber.grab(lockManager, lockReleaser, entity);
            }
            Response<LockResult> response = this.packResponse(context, new LockResult(LockStatus.OK_LOCKED));
            return response;
        }
        catch (DeadlockDetectedException e) {
            Response<LockResult> response = this.packResponse(context, new LockResult(e.getMessage()));
            return response;
        }
        catch (IllegalResourceException e) {
            Response<LockResult> response = this.packResponse(context, new LockResult(LockStatus.NOT_LOCKED));
            return response;
        }
        finally {
            this.suspendThisAndResumeOther(otherTx, context);
        }
    }

    private <T> Response<T> packResponse(SlaveContext context, T response) {
        return this.packResponse(context, response, (Predicate<Long>)MasterUtil.ALL);
    }

    private <T> Response<T> packResponse(SlaveContext context, T response, Predicate<Long> filter) {
        return MasterUtil.packResponse((GraphDatabaseService)this.graphDb, (SlaveContext)context, response, filter);
    }

    private Transaction getTx(SlaveContext txId) {
        return this.transactions.get(txId);
    }

    private Transaction beginTx(SlaveContext txId) {
        try {
            TransactionManager txManager = this.graphDbConfig.getTxModule().getTxManager();
            txManager.begin();
            Transaction tx = txManager.getTransaction();
            this.transactions.put(txId, tx);
            return tx;
        }
        catch (NotSupportedException e) {
            throw new RuntimeException(e);
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    Transaction suspendOtherAndResumeThis(SlaveContext txId) {
        try {
            TransactionManager txManager = this.graphDbConfig.getTxModule().getTxManager();
            Transaction otherTx = txManager.getTransaction();
            Transaction transaction = this.getTx(txId);
            if (otherTx != null && otherTx == transaction) {
                return null;
            }
            if (otherTx != null) {
                txManager.suspend();
            }
            if (transaction == null) {
                this.beginTx(txId);
            } else {
                txManager.resume(transaction);
            }
            return otherTx;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    void suspendThisAndResumeOther(Transaction otherTx, SlaveContext txId) {
        try {
            TransactionManager txManager = this.graphDbConfig.getTxModule().getTxManager();
            txManager.suspend();
            if (otherTx != null) {
                txManager.resume(otherTx);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    void rollbackThisAndResumeOther(Transaction otherTx, SlaveContext txId) {
        try {
            TransactionManager txManager = this.graphDbConfig.getTxModule().getTxManager();
            txManager.rollback();
            this.transactions.remove(txId);
            if (otherTx != null) {
                txManager.resume(otherTx);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public Response<LockResult> acquireNodeReadLock(SlaveContext context, long ... nodes) {
        return this.acquireLock(context, READ_LOCK_GRABBER, (PropertyContainer[])this.nodesById(nodes));
    }

    @Override
    public Response<LockResult> acquireNodeWriteLock(SlaveContext context, long ... nodes) {
        return this.acquireLock(context, WRITE_LOCK_GRABBER, (PropertyContainer[])this.nodesById(nodes));
    }

    @Override
    public Response<LockResult> acquireRelationshipReadLock(SlaveContext context, long ... relationships) {
        return this.acquireLock(context, READ_LOCK_GRABBER, (PropertyContainer[])this.relationshipsById(relationships));
    }

    @Override
    public Response<LockResult> acquireRelationshipWriteLock(SlaveContext context, long ... relationships) {
        return this.acquireLock(context, WRITE_LOCK_GRABBER, (PropertyContainer[])this.relationshipsById(relationships));
    }

    private Node[] nodesById(long[] ids) {
        Node[] result = new Node[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            result[i] = new LockableNode((int)ids[i]);
        }
        return result;
    }

    private Relationship[] relationshipsById(long[] ids) {
        Relationship[] result = new Relationship[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            result[i] = new LockableRelationship((int)ids[i]);
        }
        return result;
    }

    @Override
    public Response<IdAllocation> allocateIds(IdType idType) {
        IdGenerator generator = this.graphDbConfig.getIdGeneratorFactory().get(idType);
        IdAllocation result = new IdAllocation(generator.nextIdBatch(1000), generator.getHighId(), generator.getDefragCount());
        return MasterUtil.packResponseWithoutTransactionStream((GraphDatabaseService)this.graphDb, (SlaveContext)SlaveContext.EMPTY, (Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<Long> commitSingleResourceTransaction(SlaveContext context, String resource, TxExtractor txGetter) {
        Transaction otherTx = this.suspendOtherAndResumeThis(context);
        try {
            XaDataSource dataSource = this.graphDbConfig.getTxModule().getXaDataSourceManager().getXaDataSource(resource);
            final long txId = dataSource.applyPreparedTransaction(txGetter.extract());
            Predicate<Long> notThisTx = new Predicate<Long>(){

                public boolean accept(Long item) {
                    return item != txId;
                }
            };
            Response<Long> response = this.packResponse(context, txId, notThisTx);
            return response;
        }
        catch (IOException e) {
            e.printStackTrace();
            FailedResponse failedResponse = new FailedResponse();
            return failedResponse;
        }
        finally {
            this.suspendThisAndResumeOther(otherTx, context);
        }
    }

    @Override
    public Response<Void> finishTransaction(SlaveContext context) {
        Transaction otherTx = this.suspendOtherAndResumeThis(context);
        this.rollbackThisAndResumeOther(otherTx, context);
        return this.packResponse(context, null);
    }

    @Override
    public Response<Integer> createRelationshipType(SlaveContext context, String name) {
        Integer id = this.graphDbConfig.getRelationshipTypeHolder().getIdFor(name);
        if (id != null) {
            return this.packResponse(context, id);
        }
        id = this.graphDbConfig.getRelationshipTypeCreator().getOrCreate(this.graphDbConfig.getTxModule().getTxManager(), this.graphDbConfig.getIdGeneratorModule().getIdGenerator(), this.graphDbConfig.getPersistenceModule().getPersistenceManager(), this.graphDbConfig.getRelationshipTypeHolder(), name);
        return this.packResponse(context, id);
    }

    @Override
    public Response<Void> pullUpdates(SlaveContext context) {
        return this.packResponse(context, null);
    }

    @Override
    public Response<Integer> getMasterIdForCommittedTx(long txId) {
        try {
            XaDataSource nioneoDataSource = this.graphDbConfig.getTxModule().getXaDataSourceManager().getXaDataSource("nioneodb");
            return MasterUtil.packResponseWithoutTransactionStream((GraphDatabaseService)this.graphDb, (SlaveContext)SlaveContext.EMPTY, (Object)nioneoDataSource.getMasterForCommittedTx(txId));
        }
        catch (IOException e) {
            return MasterUtil.packResponseWithoutTransactionStream((GraphDatabaseService)this.graphDb, (SlaveContext)SlaveContext.EMPTY, (Object)-1);
        }
    }

    @Override
    public Response<Void> copyStore(SlaveContext context, StoreWriter writer) {
        try {
            context = MasterUtil.rotateLogsAndStreamStoreFiles((GraphDatabaseService)this.graphDb, (StoreWriter)writer);
        }
        catch (Exception e) {
            return new FailedResponse();
        }
        writer.done();
        context = this.makeSureThereIsAtLeastOneKernelTx(context);
        return this.packResponse(context, null);
    }

    private SlaveContext makeSureThereIsAtLeastOneKernelTx(SlaveContext context) {
        ArrayList<Pair> txs = new ArrayList<Pair>();
        for (Pair txEntry : context.lastAppliedTransactions()) {
            String resourceName = (String)txEntry.first();
            XaDataSource dataSource = this.graphDbConfig.getTxModule().getXaDataSourceManager().getXaDataSource(resourceName);
            if (dataSource instanceof NeoStoreXaDataSource) {
                if ((Long)txEntry.other() == 1L || (Long)txEntry.other() < dataSource.getLastCommittedTxId()) {
                    return context;
                }
                txs.add(Pair.of((Object)resourceName, (Object)(dataSource.getLastCommittedTxId() - 1L)));
                System.out.println("Pushed in one extra tx " + dataSource.getLastCommittedTxId());
                continue;
            }
            txs.add(Pair.of((Object)resourceName, (Object)dataSource.getLastCommittedTxId()));
        }
        return new SlaveContext(context.machineId(), context.getEventIdentifier(), txs.toArray(new Pair[0]));
    }

    private File getBaseDir() {
        File file = new File(((AbstractGraphDatabase)this.graphDb).getStoreDir());
        try {
            return file.getCanonicalFile().getAbsoluteFile();
        }
        catch (IOException e) {
            return file.getAbsoluteFile();
        }
    }

    private String relativePath(File baseDir, File storeFile) throws FileNotFoundException {
        String prefix = baseDir.getAbsolutePath();
        String path = storeFile.getAbsolutePath();
        if (!path.startsWith(prefix)) {
            throw new FileNotFoundException();
        }
        if ((path = path.substring(prefix.length())).startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }

    public Map<Integer, Collection<SlaveContext>> getOngoingTransactions() {
        HashMap<Integer, Collection<SlaveContext>> result = new HashMap<Integer, Collection<SlaveContext>>();
        for (SlaveContext context : this.transactions.keySet()) {
            ArrayList<SlaveContext> txs = (ArrayList<SlaveContext>)result.get(context.machineId());
            if (txs == null) {
                txs = new ArrayList<SlaveContext>();
                result.put(context.machineId(), txs);
            }
            txs.add(context);
        }
        return result;
    }

    private static interface LockGrabber {
        public void grab(LockManager var1, LockReleaser var2, Object var3);
    }
}

