/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.BrokerFactory;
import org.neo4j.kernel.ha.ConnectionInformation;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.impl.nioneo.store.StoreId;

public abstract class AbstractBroker
implements Broker {
    private final int myMachineId;
    private final GraphDatabaseService graphDb;

    public AbstractBroker(int myMachineId, GraphDatabaseService graphDb) {
        this.myMachineId = myMachineId;
        this.graphDb = graphDb;
    }

    @Override
    public void setLastCommittedTxId(long txId) {
    }

    @Override
    public int getMyMachineId() {
        return this.myMachineId;
    }

    public String getStoreDir() {
        return ((AbstractGraphDatabase)this.graphDb).getStoreDir();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public Machine getMasterExceptMyself() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rebindMaster() {
    }

    public static BrokerFactory wrapSingleBroker(final Broker broker) {
        return new BrokerFactory(){

            @Override
            public Broker create(GraphDatabaseService graphDb, Map<String, String> graphDbConfig) {
                return broker;
            }
        };
    }

    @Override
    public void setConnectionInformation(KernelData kernel) {
    }

    @Override
    public ConnectionInformation getConnectionInformation(int machineId) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support ConnectionInformation");
    }

    @Override
    public ConnectionInformation[] getConnectionInformation() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support ConnectionInformation");
    }

    @Override
    public StoreId createCluster(StoreId storeIdSuggestion) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }
}

