/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.zookeeper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.neo4j.kernel.ha.zookeeper.AbstractZooKeeperManager;
import org.neo4j.kernel.ha.zookeeper.Machine;

public class ClusterManager
extends AbstractZooKeeperManager {
    private final ZooKeeper zooKeeper;
    private String rootPath;
    private Watcher.Event.KeeperState state = Watcher.Event.KeeperState.Disconnected;

    public ClusterManager(String zooKeeperServers) {
        super(zooKeeperServers, null);
        this.zooKeeper = this.instantiateZooKeeper();
    }

    @Override
    protected int getMyMachineId() {
        throw new UnsupportedOperationException("Not implemented ClusterManager.getMyMachineId()");
    }

    @Override
    public void waitForSyncConnected() {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 5000L && this.state != Watcher.Event.KeeperState.SyncConnected) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
    }

    public int getBackupPort(int machineId) {
        int port = (Integer)this.readHaServer(machineId, true).other();
        return port != 0 ? port : 6362;
    }

    public void process(WatchedEvent event) {
        String path = event.getPath();
        if (path == null) {
            this.state = event.getState();
        }
    }

    public Machine getMaster() {
        return this.getMasterBasedOn(this.getAllMachines(true).values());
    }

    @Override
    public String getRoot() {
        if (this.rootPath == null) {
            this.rootPath = this.readRootPath();
        }
        return this.rootPath;
    }

    private String readRootPath() {
        this.waitForSyncConnected();
        String result = ClusterManager.getSingleRootPath(this.getZooKeeper());
        if (result == null) {
            throw new RuntimeException("No root child found in zoo keeper");
        }
        return result;
    }

    public static String getSingleRootPath(ZooKeeper keeper) {
        try {
            List children = keeper.getChildren("/", false);
            String foundChild = null;
            for (String child : children) {
                if (!child.contains("_")) continue;
                if (foundChild != null) {
                    throw new RuntimeException("Multiple roots found, " + foundChild + " and " + child);
                }
                foundChild = child;
            }
            if (foundChild != null) {
                return "/" + foundChild;
            }
            return null;
        }
        catch (KeeperException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public Machine[] getConnectedSlaves() {
        Map<Integer, Machine> machines = this.getAllMachines(true);
        Machine master = this.getMasterBasedOn(machines.values());
        ArrayList<Machine> result = new ArrayList<Machine>(machines.values());
        result.remove(master);
        return result.toArray(new Machine[result.size()]);
    }

    @Override
    protected ZooKeeper getZooKeeper() {
        return this.zooKeeper;
    }
}

