/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.ha.StandaloneDatabase;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import slavetest.AbstractHaTest;
import slavetest.CommonJobs;
import slavetest.DoubleLatch;
import slavetest.Fetcher;
import slavetest.Job;
import slavetest.MultiJvmDLFetcher;

public class MultiJvmTest
extends AbstractHaTest {
    private static final int MASTER_PORT = 8990;
    private final List<StandaloneDatabase> jvms = new ArrayList<StandaloneDatabase>();

    @Override
    protected void addDb(Map<String, String> config) throws Exception {
        int machineId = this.jvms.size();
        File slavePath = MultiJvmTest.dbPath(machineId);
        StandaloneDatabase slaveJvm = this.spawnJvm(slavePath, machineId, MultiJvmTest.buildExtraArgs(config));
        this.jvms.add(slaveJvm);
    }

    @Override
    protected void awaitAllStarted() throws Exception {
        for (StandaloneDatabase jvm : this.jvms) {
            jvm.awaitStarted();
        }
    }

    protected static String[] buildExtraArgs(Map<String, String> config) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, String> entry : config.entrySet()) {
            list.add("-" + entry.getKey());
            list.add(entry.getValue());
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void shutdownDbsAndVerify() throws Exception {
        this.shutdownDbs();
        EmbeddedGraphDatabase masterDb = new EmbeddedGraphDatabase(MultiJvmTest.dbPath(0).getAbsolutePath());
        try {
            for (int i = 1; i < this.jvms.size(); ++i) {
                EmbeddedGraphDatabase slaveDb = new EmbeddedGraphDatabase(MultiJvmTest.dbPath(i).getAbsolutePath());
                try {
                    this.verify((GraphDatabaseService)masterDb, new GraphDatabaseService[]{slaveDb});
                    continue;
                }
                finally {
                    slaveDb.shutdown();
                }
            }
        }
        finally {
            masterDb.shutdown();
        }
    }

    @Override
    protected void shutdownDbs() throws Exception {
        for (StandaloneDatabase slave : this.jvms) {
            slave.shutdown();
        }
    }

    protected StandaloneDatabase spawnJvm(File path, int machineId, String ... extraArgs) throws Exception {
        return StandaloneDatabase.withFakeBroker(this.testName.getMethodName(), path.getAbsoluteFile(), machineId, 0, extraArgs);
    }

    @Override
    protected void pullUpdates(int ... slaves) throws Exception {
        if (slaves.length == 0) {
            for (int i = 1; i < this.jvms.size(); ++i) {
                this.jvms.get(i).pullUpdates();
            }
        } else {
            for (int slave : slaves) {
                this.jvms.get(slave + 1).pullUpdates();
            }
        }
    }

    @Override
    protected <T> T executeJob(Job<T> job, int onSlave) throws Exception {
        return this.jvms.get(onSlave + 1).executeJob(job);
    }

    @Override
    protected <T> T executeJobOnMaster(Job<T> job) throws Exception {
        return this.jvms.get(0).executeJob(job);
    }

    @Override
    protected void startUpMaster(Map<String, String> config) throws Exception {
        HashMap<String, String> newConfig = new HashMap<String, String>(config);
        newConfig.put("master", "true");
        StandaloneDatabase com = this.spawnJvm(MultiJvmTest.dbPath(0), 0, MultiJvmTest.buildExtraArgs(newConfig));
        if (this.jvms.isEmpty()) {
            this.jvms.add(com);
        } else {
            this.jvms.set(0, com);
        }
        com.awaitStarted();
    }

    @Override
    protected CommonJobs.ShutdownDispatcher getMasterShutdownDispatcher() {
        try {
            return new CommonJobs.ShutdownJvm(this.jvms.get(0));
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Fetcher<DoubleLatch> getDoubleLatch() throws Exception {
        return new MultiJvmDLFetcher();
    }
}

