/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.shell;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.neo4j.com.SlaveContext;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.MasterServer;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.ReadOnlyGraphDatabaseApp;

public class Hainfo
extends ReadOnlyGraphDatabaseApp {
    protected String exec(AppCommandParser parser, Session session, Output out) throws Exception {
        if (!(this.getServer().getDb() instanceof HighlyAvailableGraphDatabase)) {
            throw new ShellException("Your database isn't started in HA mode");
        }
        HighlyAvailableGraphDatabase db = (HighlyAvailableGraphDatabase)this.getServer().getDb();
        MasterServer master = db.getMasterServerIfMaster();
        out.println((Serializable)((Object)("I'm currently " + (db.isMaster() ? "master" : "slave"))));
        if (master != null) {
            out.println((Serializable)((Object)"Connected slaves:"));
            for (Map.Entry<Integer, Collection<SlaveContext>> entry : master.getSlaveInformation().entrySet()) {
                out.println((Serializable)((Object)("\tMachine ID " + entry.getKey())));
                if (entry.getValue() == null) continue;
                for (SlaveContext tx : entry.getValue()) {
                    out.println((Serializable)((Object)("\t\tRunning tx: " + tx)));
                }
            }
        }
        return null;
    }
}

