/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.zookeeper.server.quorum.QuorumMXBean;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;
import org.jboss.netty.handler.timeout.TimeoutException;
import org.junit.Ignore;
import org.neo4j.helpers.Predicate;
import org.neo4j.kernel.ha.zookeeper.ClusterManager;
import org.neo4j.test.SubProcess;
import org.neo4j.test.SubProcessBreakPoint;
import org.neo4j.test.TargetDirectory;

@Ignore
public final class LocalhostZooKeeperCluster {
    private final ZooKeeper[] keeper;
    private final String connection;

    public LocalhostZooKeeperCluster(Class<?> owningTest, int ... ports) {
        this(TargetDirectory.forTest(owningTest), ports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalhostZooKeeperCluster(TargetDirectory target, int ... ports) {
        this.keeper = new ZooKeeper[ports.length];
        boolean success = false;
        try {
            ZooKeeperProcess subprocess = new ZooKeeperProcess(null);
            StringBuilder connection = new StringBuilder();
            for (int i = 0; i < this.keeper.length; ++i) {
                this.keeper[i] = (ZooKeeper)subprocess.start(new String[]{this.config(target, i + 1, ports[i])}, new SubProcessBreakPoint[0]);
                if (connection.length() > 0) {
                    connection.append(",");
                }
                connection.append("localhost:" + ports[i]);
            }
            this.connection = connection.toString();
            this.await(this.keeper, 15L, TimeUnit.SECONDS);
            success = true;
        }
        finally {
            if (!success) {
                this.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void await(ZooKeeper[] keepers, long timeout, TimeUnit unit) {
        timeout = System.currentTimeMillis() + unit.toMillis(timeout);
        while (true) {
            ClusterManager cm = null;
            try {
                cm = new ClusterManager(this.getConnectionString());
                cm.waitForSyncConnected();
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (cm != null) {
                    try {
                        cm.shutdown();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
            if (System.currentTimeMillis() > timeout) {
                throw new TimeoutException("waiting for ZooKeeper cluster to start");
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getConnectionString() + "]";
    }

    public synchronized String getConnectionString() {
        return this.connection;
    }

    String getStatus() {
        StringBuilder result = new StringBuilder();
        String prefix = "";
        for (ZooKeeper zk : this.keeper) {
            result.append(prefix).append(zk).append(": ").append(zk.getStatus());
            prefix = "; ";
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String config(TargetDirectory target, int id, int port) {
        File config = target.file("zookeeper" + id + ".cfg");
        File dataDir = target.directory("zk" + id + "data", true);
        try {
            PrintWriter conf = new PrintWriter(config);
            try {
                conf.println("tickTime=2000");
                conf.println("initLimit=10");
                conf.println("syncLimit=5");
                conf.println("dataDir=" + dataDir.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\"));
                conf.println("clientPort=" + port);
                for (int j = 0; j < this.keeper.length; ++j) {
                    conf.println("server." + (j + 1) + "=localhost:" + (2888 + j) + ":" + (3888 + j));
                }
            }
            finally {
                conf.close();
            }
            PrintWriter myid = new PrintWriter(new File(dataDir, "myid"));
            try {
                myid.println(Integer.toString(id));
            }
            finally {
                myid.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not write ZooKeeper configuration", e);
        }
        return config.getAbsolutePath();
    }

    public synchronized void shutdown() {
        if (this.keeper.length > 0 && this.keeper[0] == null) {
            return;
        }
        for (ZooKeeper zk : this.keeper) {
            if (zk == null) continue;
            SubProcess.stop((Object)zk);
        }
        Arrays.fill(this.keeper, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        LocalhostZooKeeperCluster cluster = new LocalhostZooKeeperCluster(ZooKeeperProcess.class, 2181, 2182, 2183);
        try {
            System.out.println("press return to exit");
            System.in.read();
        }
        finally {
            cluster.shutdown();
        }
    }

    private static class ZooKeeperProcess
    extends SubProcess<ZooKeeper, String[]>
    implements ZooKeeper {
        private final String name;

        ZooKeeperProcess(String name) {
            super((Predicate)new Predicate<String>(){

                public boolean accept(String item) {
                    return !item.contains("slf4j");
                }
            });
            this.name = name;
        }

        protected void startup(String[] parameters) {
            System.out.println("parameters=" + Arrays.toString(parameters));
            QuorumPeerMain.main((String[])parameters);
        }

        public String toString() {
            if (this.name != null) {
                return super.toString() + ":" + this.name;
            }
            return super.toString();
        }

        @Override
        public int getQuorumSize() {
            try {
                return this.quorumBean().getQuorumSize();
            }
            catch (Exception e) {
                return 0;
            }
        }

        @Override
        public String getStatus() {
            try {
                return this.status(this.quorumBean());
            }
            catch (Exception e) {
                return "-down-";
            }
        }

        private QuorumMXBean quorumBean() throws MalformedObjectNameException {
            Set<ObjectName> names = ManagementFactory.getPlatformMBeanServer().queryNames(new ObjectName("org.apache.ZooKeeperService:name0=ReplicatedServer_id*"), null);
            QuorumMXBean quorum = MBeanServerInvocationHandler.newProxyInstance(ManagementFactory.getPlatformMBeanServer(), names.iterator().next(), QuorumMXBean.class, false);
            return quorum;
        }

        private String status(QuorumMXBean quorumBean) {
            long time = System.currentTimeMillis();
            String name = quorumBean.getName();
            int size = quorumBean.getQuorumSize();
            return String.format("name=%s, size=%s, time=%s (+%sms)", name, size, this.format(time), System.currentTimeMillis() - time);
        }

        private String format(long time) {
            return new SimpleDateFormat("[HH:mm:ss:SS] ").format(new Date(time));
        }
    }

    public static interface ZooKeeper {
        public int getQuorumSize();

        public String getStatus();
    }
}

