/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.ha.StandaloneDatabase;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.ha.LockableNode;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.nioneo.store.IdGenerator;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockType;
import slavetest.DoubleLatch;
import slavetest.Fetcher;
import slavetest.Job;

public abstract class CommonJobs {
    public static final RelationshipType REL_TYPE = DynamicRelationshipType.withName((String)"HA_TEST");
    public static final RelationshipType KNOWS = DynamicRelationshipType.withName((String)"KNOWS");

    private static RelationshipType[] toRelationshipTypes(String ... names) {
        RelationshipType[] types = new RelationshipType[names.length];
        for (int i = 0; i < names.length; ++i) {
            types[i] = DynamicRelationshipType.withName((String)names[i]);
        }
        return types;
    }

    public static class LargeTransactionJob
    extends AbstractJob<Void> {
        private final int txSizeMb;
        private final int numTxs;

        public LargeTransactionJob(int txSizeMb, int numTxs) {
            this.txSizeMb = txSizeMb;
            this.numTxs = numTxs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void execute(GraphDatabaseService db) throws RemoteException {
            byte[] largeArray = new byte[1045504];
            for (int t = 0; t < this.numTxs; ++t) {
                Transaction tx = db.beginTx();
                try {
                    int i;
                    for (i = 0; i < largeArray.length; ++i) {
                        largeArray[i] = (byte)(i % 256);
                    }
                    for (i = 0; i < this.txSizeMb; ++i) {
                        Node node = db.createNode();
                        node.setProperty("data", (Object)largeArray);
                    }
                    tx.success();
                    continue;
                }
                finally {
                    tx.finish();
                }
            }
            return null;
        }
    }

    public static class AddIndex
    extends TransactionalJob<Void> {
        private final Map<String, Object> properties;
        private final long nodeId;

        public AddIndex(long nodeId, Map<String, Object> properties) {
            this.nodeId = nodeId;
            this.properties = properties;
        }

        @Override
        protected Void executeInTransaction(GraphDatabaseService db, Transaction tx) {
            Node node = db.getNodeById(this.nodeId);
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            }
            tx.success();
            return null;
        }
    }

    public static class CreateNodeAndNewIndexJob
    extends TransactionalJob<Long> {
        private final String key;
        private final Object value;
        private final String indexName;
        private final String key2;
        private final Object value2;

        public CreateNodeAndNewIndexJob(String indexName, String key, Object value, String key2, Object value2) {
            this.indexName = indexName;
            this.key = key;
            this.value = value;
            this.key2 = key2;
            this.value2 = value2;
        }

        @Override
        protected Long executeInTransaction(GraphDatabaseService db, Transaction tx) {
            Node node = db.createNode();
            node.setProperty(this.key, this.value);
            node.setProperty(this.key2, this.value2);
            Index index = db.index().forNodes(this.indexName);
            index.add((PropertyContainer)node, this.key, this.value);
            index.add((PropertyContainer)node, this.key2, this.value2);
            tx.success();
            return node.getId();
        }
    }

    public static class CreateNodeAndIndexJob
    extends TransactionalJob<Long> {
        private final String key;
        private final Object value;

        public CreateNodeAndIndexJob(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        protected Long executeInTransaction(GraphDatabaseService db, Transaction tx) {
            Node node = db.createNode();
            node.setProperty(this.key, this.value);
            tx.success();
            return node.getId();
        }
    }

    public static class PerformanceCreateNodesJob
    extends AbstractJob<Void> {
        private final int numTx;
        private final int numNodesInEach;

        public PerformanceCreateNodesJob(int numTx, int numNodesInEach) {
            this.numTx = numTx;
            this.numNodesInEach = numNodesInEach;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void execute(GraphDatabaseService db) throws RemoteException {
            for (int i = 0; i < this.numTx; ++i) {
                Transaction tx = db.beginTx();
                try {
                    for (int ii = 0; ii < this.numNodesInEach; ++ii) {
                        db.createNode();
                    }
                    tx.success();
                    continue;
                }
                finally {
                    tx.finish();
                }
            }
            return null;
        }
    }

    public static class PerformanceIdAllocationJob
    extends AbstractJob<Void> {
        private final int count;

        public PerformanceIdAllocationJob(int count) {
            this.count = count;
        }

        @Override
        public Void execute(GraphDatabaseService db) {
            Config config = this.getConfig(db);
            IdGenerator generator = config.getIdGeneratorFactory().get(IdType.NODE);
            for (int i = 0; i < this.count; ++i) {
                generator.nextId();
            }
            return null;
        }
    }

    public static class PerformanceAcquireWriteLocksJob
    extends TransactionalJob<Void> {
        private final int amount;

        public PerformanceAcquireWriteLocksJob(int amount) {
            this.amount = amount;
        }

        @Override
        protected Void executeInTransaction(GraphDatabaseService db, Transaction tx) {
            Config config = this.getConfig(db);
            LockManager lockManager = config.getLockManager();
            LockReleaser lockReleaser = config.getLockReleaser();
            for (int i = 0; i < this.amount; ++i) {
                LockableNode resource = new LockableNode((long)i);
                lockManager.getWriteLock((Object)resource);
                lockReleaser.addLockToTransaction((Object)resource, LockType.WRITE);
            }
            return null;
        }
    }

    public static class Worker2Job
    extends TransactionalJob<Boolean[]> {
        private final long node1;
        private final long node2;
        private final Fetcher<DoubleLatch> fetcher;

        public Worker2Job(long node1, long node2, Fetcher<DoubleLatch> fetcher) {
            this.node1 = node1;
            this.node2 = node2;
            this.fetcher = fetcher;
        }

        @Override
        protected Boolean[] executeInTransaction(GraphDatabaseService db, Transaction tx) {
            boolean success = false;
            boolean deadlock = false;
            try {
                DoubleLatch latch = this.fetcher.fetch();
                db.getNodeById(this.node2).setProperty("2", (Object)"T2 2");
                latch.countDownFirst();
                latch.awaitSecond();
                db.getNodeById(this.node1).setProperty("1", (Object)"T2 2");
                tx.success();
                success = true;
            }
            catch (DeadlockDetectedException e) {
                deadlock = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return new Boolean[]{success, deadlock};
        }
    }

    public static class Worker1Job
    extends TransactionalJob<Boolean[]> {
        private final long node1;
        private final long node2;
        private final Fetcher<DoubleLatch> fetcher;

        public Worker1Job(long node1, long node2, Fetcher<DoubleLatch> fetcher) {
            this.node1 = node1;
            this.node2 = node2;
            this.fetcher = fetcher;
        }

        @Override
        protected Boolean[] executeInTransaction(GraphDatabaseService db, Transaction tx) {
            boolean success = false;
            boolean deadlock = false;
            try {
                DoubleLatch latch = this.fetcher.fetch();
                db.getNodeById(this.node1).setProperty("1", (Object)"T1 1");
                latch.countDownSecond();
                latch.awaitFirst();
                db.getNodeById(this.node2).removeProperty("2");
                db.getNodeById(this.node1).removeProperty("1");
                tx.success();
                success = true;
            }
            catch (DeadlockDetectedException e) {
                deadlock = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return new Boolean[]{success, deadlock};
        }
    }

    public static class CreateNodesJob
    extends TransactionalJob<Long[]> {
        private final int count;

        public CreateNodesJob(int count) {
            this.count = count;
        }

        @Override
        protected Long[] executeInTransaction(GraphDatabaseService db, Transaction tx) {
            Long[] result = new Long[this.count];
            for (int i = 0; i < this.count; ++i) {
                result[i] = db.createNode().getId();
            }
            tx.success();
            return result;
        }
    }

    public static class SetNodePropertyJob
    extends TransactionalJob<Boolean> {
        private final long id;
        private final String key;
        private final Object value;

        public SetNodePropertyJob(long id, String key, Object value) {
            this.id = id;
            this.key = key;
            this.value = value;
        }

        @Override
        protected Boolean executeInTransaction(GraphDatabaseService db, Transaction tx) {
            try {
                db.getNodeById(this.id).setProperty(this.key, this.value);
                tx.success();
                return Boolean.TRUE;
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        }
    }

    public static class CreateNodeJob
    extends TransactionalJob<Long> {
        @Override
        protected Long executeInTransaction(GraphDatabaseService db, Transaction tx) {
            Node node = db.createNode();
            tx.success();
            return node.getId();
        }
    }

    public static class CreateNodeOutsideOfTxJob
    implements Job<Boolean> {
        @Override
        public Boolean execute(GraphDatabaseService db) throws RemoteException {
            try {
                db.getReferenceNode().createRelationshipTo(db.createNode(), REL_TYPE);
                return Boolean.TRUE;
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        }
    }

    public static class GetRelationshipCountJob
    implements Job<Integer> {
        private final String[] types;

        public GetRelationshipCountJob(String ... types) {
            this.types = types;
        }

        @Override
        public Integer execute(GraphDatabaseService db) {
            int counter = 0;
            for (Relationship rel : db.getReferenceNode().getRelationships(CommonJobs.toRelationshipTypes(this.types))) {
                ++counter;
            }
            return counter;
        }
    }

    public static class DeleteNodeJob
    implements Job<Boolean> {
        private final long id;
        private final boolean deleteIndexing;

        public DeleteNodeJob(long id, boolean deleteIndexing) {
            this.id = id;
            this.deleteIndexing = deleteIndexing;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean execute(GraphDatabaseService db) throws RemoteException {
            Transaction tx = db.beginTx();
            boolean successful = false;
            try {
                Node node = db.getNodeById(this.id);
                node.delete();
                tx.success();
            }
            finally {
                try {
                    tx.finish();
                    successful = true;
                }
                catch (RuntimeException e) {}
            }
            return successful;
        }
    }

    public static class ShutdownJvm
    extends UnicastRemoteObject
    implements ShutdownDispatcher {
        private final StandaloneDatabase jvm;

        public ShutdownJvm(StandaloneDatabase jvm) throws RemoteException {
            this.jvm = jvm;
        }

        @Override
        public void doShutdown() {
            this.jvm.shutdown();
        }
    }

    public static interface ShutdownDispatcher
    extends Remote {
        public void doShutdown() throws RemoteException;
    }

    public static class GetNodeByIdJob
    implements Job<Boolean> {
        private final long id;

        public GetNodeByIdJob(long id) {
            this.id = id;
        }

        @Override
        public Boolean execute(GraphDatabaseService db) {
            try {
                db.getNodeById(this.id);
                return Boolean.TRUE;
            }
            catch (NotFoundException e) {
                return Boolean.FALSE;
            }
        }
    }

    public static class CreateSomeEntitiesJob
    extends TransactionalJob<Void> {
        @Override
        protected Void executeInTransaction(GraphDatabaseService db, Transaction tx) {
            Node node1 = db.createNode();
            Relationship rel1 = db.getReferenceNode().createRelationshipTo(node1, REL_TYPE);
            node1.setProperty("name", (Object)"Mattias");
            rel1.setProperty("something else", (Object)"Somewhat different");
            Node node2 = db.createNode();
            Relationship rel2 = node1.createRelationshipTo(node2, REL_TYPE);
            node2.setProperty("why o why", (Object)"Stuff");
            rel2.setProperty("random integer", (Object)"4");
            tx.success();
            return null;
        }
    }

    public static class SetSubRefPropertyJob
    extends TransactionalJob<Object> {
        private final String key;
        private final Object value;

        public SetSubRefPropertyJob(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        protected Object executeInTransaction(GraphDatabaseService db, Transaction tx) {
            Node refNode = db.getReferenceNode();
            refNode.removeProperty("yoyoyoyo");
            Node node = refNode.getSingleRelationship(REL_TYPE, Direction.OUTGOING).getEndNode();
            Object oldValue = node.getProperty(this.key, null);
            node.setProperty(this.key, this.value);
            tx.success();
            return oldValue;
        }
    }

    public static class CreateSubRefNodeMasterFailJob
    implements Job<Serializable[]> {
        private final ShutdownDispatcher shutdownDispatcher;

        public CreateSubRefNodeMasterFailJob(ShutdownDispatcher shutdownDispatcher) {
            this.shutdownDispatcher = shutdownDispatcher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Serializable[] execute(GraphDatabaseService db) throws RemoteException {
            Transaction tx = db.beginTx();
            boolean successful = false;
            long nodeId = 0L;
            try {
                Node node = db.createNode();
                nodeId = node.getId();
                db.getReferenceNode().createRelationshipTo(node, REL_TYPE);
                tx.success();
            }
            finally {
                this.shutdownDispatcher.doShutdown();
                try {
                    tx.finish();
                    successful = true;
                }
                catch (RuntimeException e) {}
            }
            return new Serializable[]{Boolean.valueOf(successful), Long.valueOf(nodeId)};
        }
    }

    public static class CreateSubRefNodeWithRelCountJob
    extends TransactionalJob<Integer> {
        private final String type;
        private final String[] typesToAsk;

        public CreateSubRefNodeWithRelCountJob(String type, String ... typesToAsk) {
            this.type = type;
            this.typesToAsk = typesToAsk;
        }

        @Override
        protected Integer executeInTransaction(GraphDatabaseService db, Transaction tx) {
            Node node = db.createNode();
            db.getReferenceNode().createRelationshipTo(node, (RelationshipType)DynamicRelationshipType.withName((String)this.type));
            int counter = 0;
            for (Relationship rel : db.getReferenceNode().getRelationships(CommonJobs.toRelationshipTypes(this.typesToAsk))) {
                ++counter;
            }
            tx.success();
            return counter;
        }
    }

    public static class CreateSubRefNodeJob
    extends TransactionalJob<Long> {
        private final String type;
        private final String key;
        private final Object value;

        public CreateSubRefNodeJob(String type, String key, Object value) {
            this.type = type;
            this.key = key;
            this.value = value;
        }

        @Override
        protected Long executeInTransaction(GraphDatabaseService db, Transaction tx) {
            Node node = db.createNode();
            Relationship rel = db.getReferenceNode().createRelationshipTo(node, (RelationshipType)DynamicRelationshipType.withName((String)this.type));
            rel.setProperty("something else", (Object)"Somewhat different");
            if (this.value != null) {
                node.setProperty(this.key, this.value);
            }
            tx.success();
            return node.getId();
        }
    }

    public static abstract class TransactionalJob<T>
    extends AbstractJob<T> {
        @Override
        public final T execute(GraphDatabaseService db) throws RemoteException {
            Transaction tx = db.beginTx();
            try {
                T t = this.executeInTransaction(db, tx);
                return t;
            }
            catch (RuntimeException e) {
                e.printStackTrace(System.out);
                throw e;
            }
            finally {
                this.beforeFinish();
                tx.finish();
            }
        }

        protected void beforeFinish() {
        }

        protected abstract T executeInTransaction(GraphDatabaseService var1, Transaction var2);
    }

    public static abstract class AbstractJob<T>
    implements Job<T> {
        protected Config getConfig(GraphDatabaseService db) {
            Object config = null;
            try {
                return (Config)db.getClass().getDeclaredMethod("getConfig", new Class[0]).invoke((Object)db, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

