/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import javax.transaction.TransactionManager;
import org.neo4j.com.ComException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.LockManagerFactory;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.LockResult;
import org.neo4j.kernel.ha.LockStatus;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.ResponseReceiver;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperException;
import org.neo4j.kernel.impl.transaction.IllegalResourceException;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.impl.transaction.TxModule;

public class SlaveLockManager
extends LockManager {
    private final Broker broker;
    private final TransactionManager tm;
    private final ResponseReceiver receiver;

    public SlaveLockManager(TransactionManager tm, Broker broker, ResponseReceiver receiver) {
        super(tm);
        this.tm = tm;
        this.broker = broker;
        this.receiver = receiver;
    }

    private int getLocalTxId() {
        return ((TxManager)this.tm).getEventIdentifier();
    }

    public void getReadLock(Object resource) throws DeadlockDetectedException, IllegalResourceException {
        try {
            Relationship relationship;
            Node node = resource instanceof Node ? (Node)resource : null;
            Relationship relationship2 = relationship = resource instanceof Relationship ? (Relationship)resource : null;
            if (node == null && relationship == null) {
                super.getReadLock(resource);
                return;
            }
            LockResult result = null;
            do {
                int eventIdentifier = this.getLocalTxId();
                result = node != null ? this.receiver.receive(((Master)this.broker.getMaster().first()).acquireNodeReadLock(this.receiver.getSlaveContext(eventIdentifier), node.getId())) : this.receiver.receive(((Master)this.broker.getMaster().first()).acquireRelationshipReadLock(this.receiver.getSlaveContext(eventIdentifier), relationship.getId()));
                switch (result.getStatus()) {
                    case OK_LOCKED: {
                        super.getReadLock(resource);
                        return;
                    }
                    case DEAD_LOCKED: {
                        throw new DeadlockDetectedException(result.getDeadlockMessage());
                    }
                }
            } while (result.getStatus() == LockStatus.NOT_LOCKED);
        }
        catch (ZooKeeperException e) {
            this.receiver.newMaster(null, e);
            throw e;
        }
        catch (ComException e) {
            this.receiver.newMaster(null, (Exception)((Object)e));
            throw e;
        }
    }

    public void getWriteLock(Object resource) throws DeadlockDetectedException, IllegalResourceException {
        try {
            Relationship relationship;
            Node node = resource instanceof Node ? (Node)resource : null;
            Relationship relationship2 = relationship = resource instanceof Relationship ? (Relationship)resource : null;
            if (node == null && relationship == null) {
                super.getWriteLock(resource);
                return;
            }
            LockResult result = null;
            do {
                int eventIdentifier = this.getLocalTxId();
                result = node != null ? this.receiver.receive(((Master)this.broker.getMaster().first()).acquireNodeWriteLock(this.receiver.getSlaveContext(eventIdentifier), node.getId())) : this.receiver.receive(((Master)this.broker.getMaster().first()).acquireRelationshipWriteLock(this.receiver.getSlaveContext(eventIdentifier), relationship.getId()));
                switch (result.getStatus()) {
                    case OK_LOCKED: {
                        super.getWriteLock(resource);
                        return;
                    }
                    case DEAD_LOCKED: {
                        throw new DeadlockDetectedException(result.getDeadlockMessage());
                    }
                }
            } while (result.getStatus() == LockStatus.NOT_LOCKED);
        }
        catch (ZooKeeperException e) {
            this.receiver.newMaster(null, e);
            throw e;
        }
        catch (ComException e) {
            this.receiver.newMaster(null, (Exception)((Object)e));
            throw e;
        }
    }

    public static class SlaveLockManagerFactory
    implements LockManagerFactory {
        private final Broker broker;
        private final ResponseReceiver receiver;

        public SlaveLockManagerFactory(Broker broker, ResponseReceiver receiver) {
            this.broker = broker;
            this.receiver = receiver;
        }

        public LockManager create(TxModule txModule) {
            return new SlaveLockManager(txModule.getTxManager(), this.broker, this.receiver);
        }
    }
}

