/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.zookeeper;

import org.apache.zookeeper.ZooKeeper;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.ha.zookeeper.ClusterManager;
import org.neo4j.kernel.ha.zookeeper.NeoStoreUtil;

public abstract class RootPathGetter {
    public abstract Pair<String, Long> getRootPath(ZooKeeper var1);

    public static RootPathGetter forKnownStore(final String storeDir) {
        return new RootPathGetter(){

            @Override
            public Pair<String, Long> getRootPath(ZooKeeper keeper) {
                NeoStoreUtil store = new NeoStoreUtil(storeDir);
                return Pair.of((Object)("/" + store.getCreationTime() + "_" + store.getStoreId()), (Object)store.getLastCommittedTx());
            }
        };
    }

    public static RootPathGetter forUnknownStore(final String storeDir) {
        return new RootPathGetter(){

            @Override
            public Pair<String, Long> getRootPath(ZooKeeper keeper) {
                String result = ClusterManager.getSingleRootPath(keeper);
                if (result == null) {
                    new EmbeddedGraphDatabase(storeDir).shutdown();
                    return RootPathGetter.forKnownStore(storeDir).getRootPath(keeper);
                }
                return Pair.of((Object)result, (Object)1L);
            }
        };
    }
}

