/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.ha;

import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.junit.Ignore;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.FakeMasterBroker;
import org.neo4j.kernel.ha.FakeSlaveBroker;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterClient;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperException;
import org.neo4j.management.HighAvailability;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;
import org.neo4j.test.subprocess.BreakPoint;
import org.neo4j.test.subprocess.SubProcess;
import slavetest.AbstractHaTest;
import slavetest.Job;
import slavetest.PlaceHolderGraphDatabaseService;

@Ignore
public class StandaloneDatabase {
    private final Controller process;

    public static StandaloneDatabase withDefaultBroker(String testMethodName, File path, int machineId, final LocalhostZooKeeperCluster zooKeeper, String haServer, String[] extraArgs) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("ha.server");
        args.add(haServer);
        args.add("ha.zoo_keeper_servers");
        args.add(zooKeeper.getConnectionString());
        args.addAll(Arrays.asList(extraArgs));
        return new StandaloneDatabase(testMethodName, new Bootstrap(path, machineId, args.toArray(new String[args.size()])){

            @Override
            HighlyAvailableGraphDatabase start(String storeDir, Map<String, String> config) {
                config = StandaloneDatabase.removeDashes(config);
                HighlyAvailableGraphDatabase db = new HighlyAvailableGraphDatabase(storeDir, config);
                System.out.println("Started HA db (w/ zoo keeper)");
                return db;
            }
        }){

            @Override
            IllegalStateException format(StartupFailureException e) {
                return e.format(zooKeeper);
            }
        };
    }

    protected static Map<String, String> removeDashes(Map<String, String> config) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : config.entrySet()) {
            String key = entry.getKey();
            key = key.startsWith("-") ? key.substring(1) : key;
            result.put(key, entry.getValue());
        }
        return result;
    }

    public static StandaloneDatabase withFakeBroker(String testMethodName, final File path, int machineId, final int masterId, String[] extraArgs) {
        StandaloneDatabase standalone = new StandaloneDatabase(testMethodName, new Bootstrap(path, machineId, extraArgs){

            @Override
            HighlyAvailableGraphDatabase start(String storeDir, Map<String, String> config) {
                PlaceHolderGraphDatabaseService placeHolderGraphDb = new PlaceHolderGraphDatabaseService(path.getAbsolutePath());
                Object broker = this.machineId == masterId ? new FakeMasterBroker(this.machineId, (GraphDatabaseService)placeHolderGraphDb) : new FakeSlaveBroker((Master)new MasterClient("localhost", 8901, (GraphDatabaseService)placeHolderGraphDb), masterId, this.machineId, (GraphDatabaseService)placeHolderGraphDb);
                config = StandaloneDatabase.removeDashes(config);
                HighlyAvailableGraphDatabase db = new HighlyAvailableGraphDatabase(storeDir, config, AbstractHaTest.wrapBrokerAndSetPlaceHolderDb(placeHolderGraphDb, (Broker)broker));
                placeHolderGraphDb.setDb((GraphDatabaseService)db);
                System.out.println("Started HA db (w/o zoo keeper)");
                return db;
            }
        });
        return standalone;
    }

    private StandaloneDatabase(String testMethodName, Bootstrap bootstrap) {
        this.process = (Controller)new HaDbProcess(testMethodName).start(bootstrap, new BreakPoint[0]);
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.process;
    }

    public void awaitStarted() {
        try {
            this.process.awaitStarted();
        }
        catch (StartupFailureException e) {
            throw this.format(e);
        }
    }

    public <T> T executeJob(Job<T> job) throws Exception {
        try {
            return this.process.executeJob(job);
        }
        catch (StartupFailureException e) {
            throw this.format(e);
        }
    }

    public int getMachineId() {
        try {
            return this.process.getMachineId();
        }
        catch (StartupFailureException e) {
            throw this.format(e);
        }
    }

    public void pullUpdates() {
        try {
            this.process.pullUpdates();
        }
        catch (StartupFailureException e) {
            throw this.format(e);
        }
    }

    IllegalStateException format(StartupFailureException e) {
        return e.format();
    }

    public void shutdown() {
        SubProcess.stop((Object)this.process);
    }

    public void kill() {
        SubProcess.kill((Object)this.process);
    }

    private static class TimestampStream
    extends PrintStream {
        static ThreadLocal<DateFormat> timestamp = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat("[HH:mm:ss:SS] ");
            }
        };

        static String format(Date date) {
            return timestamp.get().format(date);
        }

        TimestampStream(PrintStream out) {
            super(out);
        }

        @Override
        public void println(String string) {
            super.println(TimestampStream.format(new Date()) + string);
        }
    }

    private static class HaDbProcess
    extends SubProcess<Controller, Bootstrap>
    implements Controller {
        private volatile transient DatabaseReference db = null;
        private final String testMethodName;

        private HaDbProcess(String testMethodName) {
            this.testMethodName = testMethodName;
        }

        private HighlyAvailableGraphDatabase db() throws StartupFailureException {
            DatabaseReference ref = this.db;
            if (ref == null) {
                throw new IllegalStateException("database has not been started");
            }
            return ref.graph();
        }

        private synchronized void db(final HighlyAvailableGraphDatabase graph) {
            if (this.db != null && graph != null) {
                graph.shutdown();
                throw new IllegalStateException("database has already been started");
            }
            this.db = new DatabaseReference(){

                @Override
                HighlyAvailableGraphDatabase graph() {
                    if (graph == null) {
                        throw new IllegalStateException("database has been shut down");
                    }
                    return graph;
                }

                @Override
                void shutdown() {
                    if (graph == null) {
                        System.out.println("database has already been shut down");
                    } else {
                        graph.shutdown();
                    }
                }
            };
        }

        private synchronized Throwable db(final Throwable cause) {
            this.db = new DatabaseReference(){

                @Override
                HighlyAvailableGraphDatabase graph() throws StartupFailureException {
                    throw new StartupFailureException(cause);
                }
            };
            return cause;
        }

        public String toString() {
            return this.testMethodName;
        }

        protected synchronized void startup(Bootstrap bootstrap) throws Throwable {
            System.setOut(new TimestampStream(System.out));
            System.setErr(new TimestampStream(System.err));
            if (this.db != null) {
                throw new IllegalStateException("already started");
            }
            System.out.println("About to start");
            try {
                this.db(bootstrap.start());
            }
            catch (Throwable exception) {
                System.out.println("Startup failed: " + exception);
                throw this.db(exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void shutdown() {
            DatabaseReference ref = this.db;
            if (ref == null) {
                System.out.println("Shutdown attempted before completion of startup");
                throw new IllegalStateException("database has not been started");
            }
            System.out.println("Shutdown started");
            try {
                ref.shutdown();
            }
            finally {
                this.db((HighlyAvailableGraphDatabase)null);
            }
            System.out.println("Shutdown completed");
            super.shutdown();
        }

        @Override
        public void awaitStarted() throws StartupFailureException {
            boolean interrupted = false;
            while (this.db == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    Thread.interrupted();
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            this.db();
        }

        @Override
        public <T> T executeJob(Job<T> job) throws Exception {
            HighlyAvailableGraphDatabase database = this.db();
            System.out.println("Executing job " + job);
            T result = job.execute((GraphDatabaseService)database);
            System.out.println("Job " + job + " executed");
            return result;
        }

        @Override
        public int getMachineId() throws StartupFailureException {
            return Integer.parseInt(((HighAvailability)this.db().getManagementBean(HighAvailability.class)).getMachineId());
        }

        @Override
        public void pullUpdates() throws StartupFailureException {
            HighlyAvailableGraphDatabase database = this.db();
            System.out.println("pullUpdates");
            database.pullUpdates();
        }
    }

    private static abstract class DatabaseReference {
        private DatabaseReference() {
        }

        abstract HighlyAvailableGraphDatabase graph() throws StartupFailureException;

        void shutdown() {
        }
    }

    public static abstract class Bootstrap
    implements Serializable {
        private final String[] config;
        private final File storeDir;
        final int machineId;

        private Bootstrap(File storeDir, int machineId, String ... config) {
            this.storeDir = storeDir;
            this.machineId = machineId;
            this.config = config;
        }

        final HighlyAvailableGraphDatabase start() {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("ha.machine_id", Integer.toString(this.machineId));
            for (int i = 0; i < this.config.length; i += 2) {
                params.put(this.config[i], this.config[i + 1]);
            }
            return this.start(this.storeDir.getAbsolutePath(), params);
        }

        abstract HighlyAvailableGraphDatabase start(String var1, Map<String, String> var2);
    }

    public static class StartupFailureException
    extends Exception {
        private final long timestamp = new Date().getTime();

        StartupFailureException(Throwable cause) {
            super(cause);
        }

        public IllegalStateException format() {
            return new IllegalStateException(this.message(), this.getCause());
        }

        private String message() {
            return "database failed to start @ " + TimestampStream.format(new Date(this.timestamp));
        }

        IllegalStateException format(LocalhostZooKeeperCluster zooKeeper) {
            Throwable cause = this.getCause();
            String message = this.message();
            if (cause instanceof ZooKeeperException) {
                message = message + ". ZooKeeper status: " + zooKeeper.getStatus();
            }
            return new IllegalStateException(message, cause);
        }
    }

    public static interface Controller {
        public void pullUpdates() throws StartupFailureException;

        public void awaitStarted() throws StartupFailureException;

        public int getMachineId() throws StartupFailureException;

        public <T> T executeJob(Job<T> var1) throws Exception;
    }
}

