/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.FakeMasterBroker;
import org.neo4j.kernel.ha.FakeSlaveBroker;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterImpl;
import slavetest.AbstractHaTest;
import slavetest.CommonJobs;
import slavetest.DoubleLatch;
import slavetest.Fetcher;
import slavetest.Job;
import slavetest.PlaceHolderGraphDatabaseService;

public class SingleJvmTest
extends AbstractHaTest {
    private MasterImpl master;
    private List<GraphDatabaseService> haDbs;

    protected GraphDatabaseService getSlave(int nr) {
        return this.haDbs.get(nr);
    }

    @Override
    protected int addDb(Map<String, String> config, boolean awaitStarted) {
        this.haDbs = this.haDbs != null ? this.haDbs : new ArrayList<GraphDatabaseService>();
        int machineId = this.haDbs.size() + 1;
        this.haDbs.add(null);
        this.startDb(machineId, config, awaitStarted);
        return machineId;
    }

    @Override
    protected void startDb(int machineId, Map<String, String> config, boolean awaitStarted) {
        this.haDbs = this.haDbs != null ? this.haDbs : new ArrayList<GraphDatabaseService>();
        File slavePath = this.dbPath(machineId);
        PlaceHolderGraphDatabaseService placeHolderDb = new PlaceHolderGraphDatabaseService(slavePath.getAbsolutePath());
        Broker broker = this.makeSlaveBroker(this.master, 0, machineId, (GraphDatabaseService)placeHolderDb);
        HashMap<String, String> cfg = new HashMap<String, String>(config);
        cfg.put("ha.machine_id", Integer.toString(machineId));
        cfg.put("keep_logical_logs", "true");
        HighlyAvailableGraphDatabase db = new HighlyAvailableGraphDatabase(slavePath.getAbsolutePath(), cfg, SingleJvmTest.wrapBrokerAndSetPlaceHolderDb(placeHolderDb, broker));
        placeHolderDb.setDb((GraphDatabaseService)db);
        this.haDbs.set(machineId - 1, (GraphDatabaseService)db);
    }

    @Override
    protected void awaitAllStarted() throws Exception {
    }

    @Override
    protected void shutdownDb(int machineId) {
        this.haDbs.get(machineId - 1).shutdown();
    }

    @Override
    protected void startUpMaster(Map<String, String> extraConfig) throws Exception {
        int masterId = 0;
        Map config = MapUtil.stringMap(extraConfig, (String[])new String[]{"ha.machine_id", String.valueOf(masterId)});
        String path = this.dbPath(0).getAbsolutePath();
        PlaceHolderGraphDatabaseService placeHolderDb = new PlaceHolderGraphDatabaseService(path);
        Broker broker = this.makeMasterBroker(this.master, masterId, (GraphDatabaseService)placeHolderDb);
        HighlyAvailableGraphDatabase db = new HighlyAvailableGraphDatabase(path, config, SingleJvmTest.wrapBrokerAndSetPlaceHolderDb(placeHolderDb, broker));
        placeHolderDb.setDb((GraphDatabaseService)db);
        this.master = new MasterImpl((GraphDatabaseService)db);
    }

    protected Broker makeMasterBroker(MasterImpl master, int masterId, GraphDatabaseService graphDb) {
        return new FakeMasterBroker(masterId, graphDb);
    }

    protected Broker makeSlaveBroker(MasterImpl master, int masterId, int id, GraphDatabaseService graphDb) {
        return new FakeSlaveBroker((Master)master, masterId, id, graphDb);
    }

    protected MasterImpl getMaster() {
        return this.master;
    }

    @Override
    protected void shutdownDbs() {
        for (GraphDatabaseService haDb : this.haDbs) {
            haDb.shutdown();
        }
        this.master.getGraphDb().shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void verifyAndShutdownDbs() {
        try {
            this.verify(this.master.getGraphDb(), this.haDbs.toArray(new GraphDatabaseService[this.haDbs.size()]));
        }
        finally {
            this.shutdownDbs();
        }
        if (!this.shouldDoVerificationAfterTests()) {
            return;
        }
        EmbeddedGraphDatabase masterOfflineDb = new EmbeddedGraphDatabase(this.dbPath(0).getAbsolutePath());
        GraphDatabaseService[] slaveOfflineDbs = new GraphDatabaseService[this.haDbs.size()];
        for (int i = 1; i <= this.haDbs.size(); ++i) {
            slaveOfflineDbs[i - 1] = new EmbeddedGraphDatabase(this.dbPath(i).getAbsolutePath());
        }
        try {
            this.verify((GraphDatabaseService)masterOfflineDb, slaveOfflineDbs);
        }
        finally {
            masterOfflineDb.shutdown();
            for (GraphDatabaseService db : slaveOfflineDbs) {
                db.shutdown();
            }
        }
    }

    @Override
    protected <T> T executeJob(Job<T> job, int slave) throws Exception {
        return job.execute(this.haDbs.get(slave));
    }

    @Override
    protected <T> T executeJobOnMaster(Job<T> job) throws Exception {
        return job.execute(this.master.getGraphDb());
    }

    @Override
    protected void pullUpdates(int ... ids) {
        if (ids.length == 0) {
            for (GraphDatabaseService db : this.haDbs) {
                ((HighlyAvailableGraphDatabase)db).pullUpdates();
            }
        } else {
            for (int id : ids) {
                ((HighlyAvailableGraphDatabase)this.haDbs.get(id)).pullUpdates();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMixingEntitiesFromWrongDbs() throws Exception {
        this.initializeDbs(1);
        GraphDatabaseService haDb1 = this.haDbs.get(0);
        GraphDatabaseService mDb = this.master.getGraphDb();
        Transaction tx = mDb.beginTx();
        try {
            Node masterNode = mDb.createNode();
            mDb.getReferenceNode().createRelationshipTo(masterNode, CommonJobs.REL_TYPE);
            tx.success();
        }
        finally {
            tx.finish();
        }
        tx = haDb1.beginTx();
        try {
            Node node = haDb1.createNode();
            mDb.getReferenceNode().createRelationshipTo(node, CommonJobs.KNOWS);
            Assert.fail((String)"Should throw not found exception");
        }
        catch (NotFoundException e) {
        }
        finally {
            tx.finish();
        }
    }

    @Override
    protected CommonJobs.ShutdownDispatcher getMasterShutdownDispatcher() {
        return new CommonJobs.ShutdownDispatcher(){

            @Override
            public void doShutdown() {
                SingleJvmTest.this.master.getGraphDb().shutdown();
            }
        };
    }

    @Override
    protected Fetcher<DoubleLatch> getDoubleLatch() {
        return new Fetcher<DoubleLatch>(){
            private final DoubleLatch latch = new DoubleLatch(){
                private final CountDownLatch first = new CountDownLatch(1);
                private final CountDownLatch second = new CountDownLatch(1);

                @Override
                public void countDownSecond() {
                    this.second.countDown();
                }

                @Override
                public void countDownFirst() {
                    this.first.countDown();
                }

                @Override
                public void awaitSecond() {
                    this.await(this.second);
                }

                @Override
                public void awaitFirst() {
                    this.await(this.first);
                }

                private void await(CountDownLatch latch) {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        e.printStackTrace();
                    }
                }
            };

            @Override
            public DoubleLatch fetch() {
                return this.latch;
            }

            @Override
            public void close() {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void slaveWriteThatOnlyModifyRelationshipRecordsCanUpdateCachedNodeOnMaster() throws Exception {
        long relId;
        Node node;
        this.initializeDbs(1, MapUtil.stringMap((String[])new String[]{"cache_type", "strong"}));
        HighlyAvailableGraphDatabase sDb = (HighlyAvailableGraphDatabase)this.haDbs.get(0);
        HighlyAvailableGraphDatabase mDb = (HighlyAvailableGraphDatabase)this.master.getGraphDb();
        Transaction tx = mDb.beginTx();
        try {
            node = mDb.createNode();
            node.createRelationshipTo(mDb.createNode(), REL_TYPE);
            relId = node.createRelationshipTo(mDb.createNode(), REL_TYPE).getId();
            node.createRelationshipTo(mDb.createNode(), REL_TYPE);
            tx.success();
        }
        finally {
            tx.finish();
        }
        sDb.pullUpdates();
        tx = sDb.beginTx();
        try {
            sDb.getRelationshipById(relId).delete();
            tx.success();
        }
        finally {
            tx.finish();
        }
        int relCount = 0;
        for (Relationship rel : node.getRelationships()) {
            rel.getOtherNode(node);
            ++relCount;
        }
        Assert.assertEquals((String)"wrong number of relationships", (long)2L, (long)relCount);
    }
}

