/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.zookeeper;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Triplet;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterClient;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperException;
import org.neo4j.kernel.impl.util.StringLogger;

public abstract class AbstractZooKeeperManager
implements Watcher {
    protected static final String HA_SERVERS_CHILD = "ha-servers";
    protected static final int SESSION_TIME_OUT = 5000;
    private final String servers;
    private final Map<Integer, String> haServersCache = Collections.synchronizedMap(new HashMap());
    private Pair<Master, Machine> cachedMaster = Pair.of(null, (Object)Machine.NO_MACHINE);
    private final GraphDatabaseService graphDb;
    private final StringLogger msgLog;

    public AbstractZooKeeperManager(String servers, GraphDatabaseService graphDb) {
        this.servers = servers;
        this.graphDb = graphDb;
        if (graphDb != null) {
            String storeDir = ((AbstractGraphDatabase)graphDb).getStoreDir();
            this.msgLog = StringLogger.getLogger((String)storeDir);
        } else {
            this.msgLog = null;
        }
    }

    protected ZooKeeper instantiateZooKeeper() {
        try {
            return new ZooKeeper(this.servers, 5000, (Watcher)this);
        }
        catch (IOException e) {
            throw new ZooKeeperException("Unable to create zoo keeper client", e);
        }
    }

    protected abstract ZooKeeper getZooKeeper();

    public abstract String getRoot();

    protected GraphDatabaseService getGraphDb() {
        return this.graphDb;
    }

    protected Pair<Integer, Integer> parseChild(String child) {
        int index = child.indexOf(95);
        if (index == -1) {
            return null;
        }
        int id = Integer.parseInt(child.substring(0, index));
        int seq = Integer.parseInt(child.substring(index + 1));
        return Pair.of((Object)id, (Object)seq);
    }

    protected Pair<Long, Integer> readDataRepresentingInstance(String path) throws InterruptedException, KeeperException {
        byte[] data = this.getZooKeeper().getData(path, false, null);
        ByteBuffer buf = ByteBuffer.wrap(data);
        return Pair.of((Object)buf.getLong(), (Object)buf.getInt());
    }

    private void invalidateMaster() {
        if (this.cachedMaster != null) {
            MasterClient client = (MasterClient)this.cachedMaster.first();
            if (client != null) {
                client.shutdown();
            }
            this.cachedMaster = Pair.of(null, (Object)Machine.NO_MACHINE);
        }
    }

    protected Pair<Master, Machine> getMasterFromZooKeeper(boolean wait) {
        Machine master = this.getMasterBasedOn(this.getAllMachines(wait).values());
        MasterClient masterClient = null;
        if (((Machine)this.cachedMaster.other()).getMachineId() != master.getMachineId()) {
            this.invalidateMaster();
            if (master != Machine.NO_MACHINE && master.getMachineId() != this.getMyMachineId()) {
                masterClient = new MasterClient(master, this.graphDb);
            }
            this.cachedMaster = Pair.of(masterClient, (Object)master);
        }
        return this.cachedMaster;
    }

    protected abstract int getMyMachineId();

    public Pair<Master, Machine> getCachedMaster() {
        return this.cachedMaster;
    }

    protected Machine getMasterBasedOn(Collection<Machine> machines) {
        ArrayList<Triplet> debugData = new ArrayList<Triplet>();
        Machine master = null;
        int lowestSeq = Integer.MAX_VALUE;
        long highestTxId = -1L;
        for (Machine info : machines) {
            debugData.add(Triplet.of((Object)info.getMachineId(), (Object)info.getLastCommittedTxId(), (Object)info.getSequenceId()));
            if (info.getLastCommittedTxId() < highestTxId || info.getLastCommittedTxId() <= highestTxId && !info.wasCommittingMaster() && (master.wasCommittingMaster() || info.getSequenceId() >= lowestSeq)) continue;
            master = info;
            lowestSeq = info.getSequenceId();
            highestTxId = info.getLastCommittedTxId();
        }
        this.log("getMaster " + (master != null ? Integer.valueOf(master.getMachineId()) : "none") + " based on " + debugData);
        return master != null ? master : Machine.NO_MACHINE;
    }

    protected Map<Integer, Machine> getAllMachines(boolean wait) {
        if (wait) {
            this.waitForSyncConnected();
        }
        try {
            HashMap<Integer, Machine> result = new HashMap<Integer, Machine>();
            String root = this.getRoot();
            List children = this.getZooKeeper().getChildren(root, false);
            for (String child : children) {
                Pair<Integer, Integer> parsedChild = this.parseChild(child);
                if (parsedChild == null) continue;
                try {
                    int id = (Integer)parsedChild.first();
                    int seq = (Integer)parsedChild.other();
                    Pair<Long, Integer> instanceData = this.readDataRepresentingInstance(root + "/" + child);
                    if (result.containsKey(id) && seq <= ((Machine)result.get(id)).getSequenceId()) continue;
                    result.put(id, new Machine(id, seq, (Long)instanceData.first(), (Integer)instanceData.other(), this.getHaServer(id, wait)));
                }
                catch (KeeperException inner) {
                    if (inner.code() == KeeperException.Code.NONODE) continue;
                    throw new ZooKeeperException("Unabe to get master.", inner);
                }
            }
            return result;
        }
        catch (KeeperException e) {
            throw new ZooKeeperException("Unable to get master", e);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ZooKeeperException("Interrupted.", e);
        }
    }

    protected String getHaServer(int machineId, boolean wait) {
        String result = this.haServersCache.get(machineId);
        if (result == null) {
            result = (String)this.readHaServer(machineId, wait).first();
            this.haServersCache.put(machineId, result);
        }
        return result;
    }

    protected Pair<String, Integer> readHaServer(int machineId, boolean wait) {
        if (wait) {
            this.waitForSyncConnected();
        }
        String rootPath = this.getRoot();
        String haServerPath = rootPath + "/" + HA_SERVERS_CHILD + "/" + machineId;
        try {
            byte[] serverData = this.getZooKeeper().getData(haServerPath, false, null);
            ByteBuffer buffer = ByteBuffer.wrap(serverData);
            int backupPort = buffer.getInt();
            byte length = buffer.get();
            char[] chars = new char[length];
            buffer.asCharBuffer().get(chars);
            String result = String.valueOf(chars);
            this.log("Read HA server:" + result + " (for machineID " + machineId + ") from zoo keeper");
            return Pair.of((Object)result, (Object)backupPort);
        }
        catch (KeeperException e) {
            throw new ZooKeeperException("Couldn't find the HA server: " + rootPath, e);
        }
        catch (InterruptedException e) {
            throw new ZooKeeperException("Interrupted", e);
        }
    }

    private void log(String string) {
        if (this.msgLog != null) {
            this.msgLog.logMessage(string);
        }
    }

    public void shutdown() {
        try {
            this.invalidateMaster();
            this.cachedMaster = Pair.of(null, (Object)Machine.NO_MACHINE);
            this.getZooKeeper().close();
        }
        catch (InterruptedException e) {
            throw new ZooKeeperException("Error closing zookeeper connection", e);
        }
    }

    public abstract void waitForSyncConnected();
}

