/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.zookeeper;

import org.neo4j.com.SlaveContext;
import org.neo4j.helpers.Pair;

public class Machine {
    public static final Machine NO_MACHINE = new Machine(-1, -1, 1L, SlaveContext.EMPTY.machineId(), null);
    private final int machineId;
    private final int sequenceId;
    private final long lastCommittedTxId;
    private final Pair<String, Integer> server;
    private final int masterForCommittedTxId;

    public Machine(int machineId, int sequenceId, long lastCommittedTxId, int masterForCommittedTxId, String server) {
        this.machineId = machineId;
        this.sequenceId = sequenceId;
        this.lastCommittedTxId = lastCommittedTxId;
        this.masterForCommittedTxId = masterForCommittedTxId;
        this.server = server != null ? Machine.splitIpAndPort(server) : null;
    }

    public int getMachineId() {
        return this.machineId;
    }

    public long getLastCommittedTxId() {
        return this.lastCommittedTxId;
    }

    public boolean wasCommittingMaster() {
        return this.masterForCommittedTxId == this.machineId;
    }

    public int getMasterForCommittedTxId() {
        return this.masterForCommittedTxId;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public Pair<String, Integer> getServer() {
        return this.server;
    }

    public String toString() {
        return "MachineInfo[ID:" + this.machineId + ", sequence:" + this.sequenceId + ", last committed tx id:" + this.lastCommittedTxId + ", server:" + this.server + "]";
    }

    public boolean equals(Object obj) {
        return obj instanceof Machine && ((Machine)obj).machineId == this.machineId;
    }

    public int hashCode() {
        return this.machineId * 19;
    }

    public static Pair<String, Integer> splitIpAndPort(String server) {
        int pos = server.indexOf(":");
        return Pair.of((Object)server.substring(0, pos), (Object)Integer.parseInt(server.substring(pos + 1)));
    }
}

