/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.Map;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.BrokerFactory;
import org.neo4j.kernel.ha.ConnectionInformation;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.util.StringLogger;

public abstract class AbstractBroker
implements Broker {
    private final int myMachineId;
    private final AbstractGraphDatabase graphDb;

    public AbstractBroker(int myMachineId, AbstractGraphDatabase graphDb) {
        this.myMachineId = myMachineId;
        this.graphDb = graphDb;
    }

    @Override
    public void setLastCommittedTxId(long txId) {
    }

    @Override
    public int getMyMachineId() {
        return this.myMachineId;
    }

    @Override
    public void notifyMasterChange(Machine newMaster) {
    }

    public String getStoreDir() {
        return this.graphDb.getStoreDir();
    }

    protected AbstractGraphDatabase getGraphDb() {
        return this.graphDb;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void restart() {
    }

    @Override
    public Machine getMasterExceptMyself() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rebindMaster() {
    }

    public static BrokerFactory wrapSingleBroker(final Broker broker) {
        return new BrokerFactory(){

            @Override
            public Broker create(AbstractGraphDatabase graphDb, Map<String, String> graphDbConfig) {
                return broker;
            }
        };
    }

    @Override
    public void setConnectionInformation(KernelData kernel) {
    }

    @Override
    public ConnectionInformation getConnectionInformation(int machineId) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support ConnectionInformation");
    }

    @Override
    public ConnectionInformation[] getConnectionInformation() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support ConnectionInformation");
    }

    @Override
    public StoreId getClusterStoreId() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void logStatus(StringLogger msgLog) {
    }
}

