/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Arrays;
import java.util.HashSet;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.test.TargetDirectory;

public class TestHABugWorkaroundGraphDatabaseWrapper {
    private static final TargetDirectory target = TargetDirectory.forTest(TestHABugWorkaroundGraphDatabaseWrapper.class);
    private static GraphDatabaseService graphdb;

    @BeforeClass
    public static void startGraphDB() throws Exception {
        graphdb = new HighlyAvailableGraphDatabase((AbstractGraphDatabase)new EmbeddedGraphDatabase(target.graphDbDir(true).getAbsolutePath()));
    }

    @AfterClass
    public static void stopGraphDB() throws Exception {
        if (graphdb != null) {
            graphdb.shutdown();
        }
        graphdb = null;
    }

    @Test
    public void canCreateNode() {
        this.createNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=NotFoundException.class)
    public void canRemoveNode() {
        Node node = this.createNode();
        long id = node.getId();
        Transaction tx = graphdb.beginTx();
        try {
            node.delete();
            tx.success();
        }
        finally {
            tx.finish();
        }
        graphdb.getNodeById(id);
    }

    @Test
    public void canCreateRelationship() {
        Node node1 = this.createNode();
        Node node2 = this.createNode();
        Relationship rel = this.createRelationship(node1, node2, TestTypes.TEST);
        Assert.assertEquals((Object)node1, (Object)rel.getStartNode());
        Assert.assertEquals((Object)node2, (Object)rel.getEndNode());
        Assert.assertEquals((Object)TestTypes.TEST.name(), (Object)rel.getType().name());
        Assert.assertArrayEquals((Object[])new Node[]{node1, node2}, (Object[])rel.getNodes());
        Assert.assertTrue((boolean)rel.isType((RelationshipType)TestTypes.TEST));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=NotFoundException.class)
    public void canDeleteRelationship() {
        Node node1 = this.createNode();
        Node node2 = this.createNode();
        Relationship rel = this.createRelationship(node1, node2, TestTypes.TEST);
        long id = rel.getId();
        Transaction tx = graphdb.beginTx();
        try {
            rel.delete();
            tx.success();
        }
        finally {
            tx.finish();
        }
        graphdb.getRelationshipById(id);
    }

    @Test
    public void canOperateWithNodeProperty() throws Exception {
        this.canOperateWithProperty(EntityType.NODE);
    }

    @Test
    public void canOperateWithRelationshipProperty() throws Exception {
        this.canOperateWithProperty(EntityType.REL);
    }

    @Test
    public void canReadRelationships() {
        Node node1 = this.createNode();
        Node node2 = this.createNode();
        Node node3 = this.createNode();
        this.createRelationship(node1, node2, TestTypes.TEST);
        this.createRelationship(node3, node1, TestTypes.FOO);
        this.assertContainsAll((Iterable)((Object)RelationshipOtherNodeIterableWrapper.otherNodes(node1, node1.getRelationships())), (T[])new Node[]{node2, node3});
        this.assertContainsAll((Iterable)((Object)RelationshipOtherNodeIterableWrapper.otherNodes(node1, node1.getRelationships(Direction.OUTGOING))), (T[])new Node[]{node2});
        this.assertContainsAll((Iterable)((Object)RelationshipOtherNodeIterableWrapper.otherNodes(node1, node1.getRelationships(new RelationshipType[]{TestTypes.FOO}))), (T[])new Node[]{node3});
        this.assertContainsAll((Iterable)((Object)RelationshipOtherNodeIterableWrapper.otherNodes(node1, node1.getRelationships(Direction.OUTGOING, new RelationshipType[]{TestTypes.FOO, TestTypes.TEST}))), (T[])new Node[]{node2});
        this.assertContainsAll((Iterable)((Object)RelationshipOtherNodeIterableWrapper.otherNodes(node1, node1.getRelationships((RelationshipType)TestTypes.FOO, Direction.INCOMING))), (T[])new Node[]{node3});
        Assert.assertEquals((Object)node2, (Object)node1.getSingleRelationship((RelationshipType)TestTypes.TEST, Direction.OUTGOING).getOtherNode(node1));
        Assert.assertTrue((boolean)node1.hasRelationship(Direction.OUTGOING));
        Assert.assertTrue((boolean)node1.hasRelationship(Direction.INCOMING, new RelationshipType[]{TestTypes.FOO}));
        Assert.assertTrue((boolean)node1.hasRelationship(new RelationshipType[]{TestTypes.FOO}));
        Assert.assertTrue((boolean)node1.hasRelationship((RelationshipType)TestTypes.TEST, Direction.OUTGOING));
        Assert.assertTrue((boolean)node1.hasRelationship());
        Assert.assertFalse((boolean)node1.hasRelationship((RelationshipType)TestTypes.TEST, Direction.INCOMING));
        Assert.assertNotNull((Object)node2.getSingleRelationship((RelationshipType)TestTypes.TEST, Direction.BOTH));
        Assert.assertNull((Object)node2.getSingleRelationship((RelationshipType)TestTypes.FOO, Direction.BOTH));
    }

    @Test
    public void canUseNodeIndex() {
        Node node = this.createNode();
        Index nodeIndex = graphdb.index().forNodes("nodeIndex");
        this.indexAdd(nodeIndex, node, "key", "value");
        Assert.assertEquals((Object)node, (Object)nodeIndex.get("key", (Object)"value").getSingle());
        Assert.assertEquals((Object)node, (Object)nodeIndex.query((Object)"key:value").getSingle());
        Assert.assertEquals((Object)node, (Object)nodeIndex.query("key", (Object)"value").getSingle());
        this.assertContainsAll((Iterable)nodeIndex.get("key", (Object)"value"), (T[])new Node[]{node});
        Assert.assertEquals((long)1L, (long)nodeIndex.get("key", (Object)"value").size());
        this.indexRemove(nodeIndex, node);
        Assert.assertNull((Object)nodeIndex.get("key", (Object)"value").getSingle());
        this.indexAdd(nodeIndex, node, "key", "value");
        Assert.assertEquals((Object)node, (Object)nodeIndex.get("key", (Object)"value").getSingle());
        this.indexRemove(nodeIndex, node, "key");
        Assert.assertNull((Object)nodeIndex.get("key", (Object)"value").getSingle());
        this.indexAdd(nodeIndex, node, "key", "value");
        Assert.assertEquals((Object)node, (Object)nodeIndex.get("key", (Object)"value").getSingle());
        this.indexRemove(nodeIndex, node, "key", "value");
        Assert.assertNull((Object)nodeIndex.get("key", (Object)"value").getSingle());
        Assert.assertEquals((Object)"nodeIndex", (Object)nodeIndex.getName());
        Assert.assertEquals(Node.class, (Object)nodeIndex.getEntityType());
    }

    @Test
    public void canUseRelationshipIndex() {
        Node node1 = this.createNode();
        Node node2 = this.createNode();
        Node node3 = this.createNode();
        Relationship rel = this.createRelationship(node1, node2, TestTypes.TEST);
        RelationshipIndex relIndex = graphdb.index().forRelationships("relIndex");
        this.indexAdd((Index)relIndex, (PropertyContainer)rel, "key", "value");
        Assert.assertEquals((Object)rel, (Object)relIndex.get("key", (Object)"value").getSingle());
        Assert.assertEquals((Object)rel, (Object)relIndex.get("key", (Object)"value", node1, node2).getSingle());
        Assert.assertNull((Object)relIndex.get("key", (Object)"value", node1, node3).getSingle());
        Assert.assertEquals((Object)rel, (Object)relIndex.query((Object)"key:value").getSingle());
        Assert.assertEquals((Object)rel, (Object)relIndex.query("key", (Object)"value").getSingle());
        Assert.assertEquals((Object)rel, (Object)relIndex.query("key", (Object)"value", node1, node2).getSingle());
        Assert.assertEquals((Object)rel, (Object)relIndex.query((Object)"key:value", node1, node2).getSingle());
        Assert.assertNull((Object)relIndex.query("key", (Object)"value", node1, node3).getSingle());
        this.assertContainsAll((Iterable)relIndex.get("key", (Object)"value"), (T[])new Relationship[]{rel});
        Assert.assertEquals((long)1L, (long)relIndex.get("key", (Object)"value").size());
        this.indexRemove((Index)relIndex, (PropertyContainer)rel);
        Assert.assertNull((Object)relIndex.get("key", (Object)"value").getSingle());
        this.indexAdd((Index)relIndex, (PropertyContainer)rel, "key", "value");
        Assert.assertEquals((Object)rel, (Object)relIndex.get("key", (Object)"value").getSingle());
        this.indexRemove((Index)relIndex, (PropertyContainer)rel, "key");
        Assert.assertNull((Object)relIndex.get("key", (Object)"value").getSingle());
        this.indexAdd((Index)relIndex, (PropertyContainer)rel, "key", "value");
        Assert.assertEquals((Object)rel, (Object)relIndex.get("key", (Object)"value").getSingle());
        this.indexRemove((Index)relIndex, (PropertyContainer)rel, "key", "value");
        Assert.assertNull((Object)relIndex.get("key", (Object)"value").getSingle());
        Assert.assertEquals((Object)"relIndex", (Object)relIndex.getName());
        Assert.assertEquals(Relationship.class, (Object)relIndex.getEntityType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends PropertyContainer> void indexRemove(Index<T> nodeIndex, T node) {
        Transaction tx = graphdb.beginTx();
        try {
            nodeIndex.remove(node);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends PropertyContainer> void indexRemove(Index<T> nodeIndex, T node, String key) {
        Transaction tx = graphdb.beginTx();
        try {
            nodeIndex.remove(node, key);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends PropertyContainer> void indexRemove(Index<T> nodeIndex, T node, String key, Object value) {
        Transaction tx = graphdb.beginTx();
        try {
            nodeIndex.remove(node, key, value);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends PropertyContainer> void indexAdd(Index<T> nodeIndex, T node, String key, String value) {
        Transaction tx = graphdb.beginTx();
        try {
            nodeIndex.add(node, key, (Object)value);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node createNode() {
        Transaction tx = graphdb.beginTx();
        try {
            Node node = graphdb.createNode();
            Assert.assertNotNull((Object)node);
            tx.success();
            Node node2 = node;
            return node2;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Relationship createRelationship(Node from, Node to, TestTypes type) {
        Transaction tx = graphdb.beginTx();
        try {
            Relationship rel = from.createRelationshipTo(to, (RelationshipType)type);
            tx.success();
            Relationship relationship = rel;
            return relationship;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Relationship createRelationship() {
        Transaction tx = graphdb.beginTx();
        try {
            Relationship rel = this.createNode().createRelationshipTo(this.createNode(), (RelationshipType)TestTypes.TEST);
            Assert.assertNotNull((Object)rel);
            tx.success();
            Relationship relationship = rel;
            return relationship;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void canOperateWithProperty(EntityType entityType) throws Exception {
        PropertyContainer entity;
        Transaction tx = graphdb.beginTx();
        try {
            entity = entityType.create(this);
            Assert.assertFalse((boolean)entity.hasProperty("key"));
            Assert.assertNull((Object)entity.getProperty("key", null));
            this.assertContainsAll(entity.getPropertyKeys(), new String[0]);
            this.assertContainsAll(entity.getPropertyValues(), new Object[0]);
            entity.setProperty("key", (Object)"value");
            Assert.assertTrue((boolean)entity.hasProperty("key"));
            Assert.assertEquals((Object)"value", (Object)entity.getProperty("key"));
            Assert.assertEquals((Object)"value", (Object)entity.getProperty("key", null));
            Assert.assertNull((Object)entity.getProperty("foo", null));
            tx.success();
        }
        finally {
            tx.finish();
        }
        Assert.assertTrue((boolean)entity.hasProperty("key"));
        Assert.assertEquals((Object)"value", (Object)entity.getProperty("key"));
        Assert.assertEquals((Object)"value", (Object)entity.getProperty("key", null));
        this.assertContainsAll(entity.getPropertyKeys(), "key");
        this.assertContainsAll(entity.getPropertyValues(), "value");
        tx = graphdb.beginTx();
        try {
            Assert.assertEquals((Object)"value", (Object)entity.removeProperty("key"));
            Assert.assertFalse((boolean)entity.hasProperty("key"));
            tx.success();
        }
        finally {
            tx.finish();
        }
        Assert.assertFalse((boolean)entity.hasProperty("key"));
        Assert.assertNull((Object)entity.getProperty("key", null));
        this.assertContainsAll(entity.getPropertyKeys(), new String[0]);
        this.assertContainsAll(entity.getPropertyValues(), new Object[0]);
    }

    private <T> void assertContainsAll(Iterable<T> actual, T ... values) {
        HashSet<T> expected = new HashSet<T>(Arrays.asList(values));
        for (T value : actual) {
            Assert.assertTrue((String)String.format("Unexpected value <%s>", value), (boolean)expected.remove(value));
        }
        Assert.assertTrue((String)String.format("Missing values %s", expected), (boolean)expected.isEmpty());
    }

    public static class RelationshipOtherNodeIterableWrapper
    extends IterableWrapper<Node, Relationship> {
        private final Node node;

        public RelationshipOtherNodeIterableWrapper(Node node, Iterable<Relationship> relationships) {
            super(relationships);
            this.node = node;
        }

        protected Node underlyingObjectToObject(Relationship relationship) {
            return relationship.getOtherNode(this.node);
        }

        public static RelationshipOtherNodeIterableWrapper otherNodes(Node node, Iterable<Relationship> relationships) {
            return new RelationshipOtherNodeIterableWrapper(node, relationships);
        }
    }

    static enum TestTypes implements RelationshipType
    {
        TEST,
        FOO;

    }

    static enum EntityType {
        NODE{

            @Override
            PropertyContainer create(TestHABugWorkaroundGraphDatabaseWrapper test) {
                return test.createNode();
            }
        }
        ,
        REL{

            @Override
            PropertyContainer create(TestHABugWorkaroundGraphDatabaseWrapper test) {
                return test.createRelationship();
            }
        };


        abstract PropertyContainer create(TestHABugWorkaroundGraphDatabaseWrapper var1);
    }
}

