/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.ReadableIndex;
import org.neo4j.graphdb.index.ReadableRelationshipIndex;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.HAGraphDb;
import org.neo4j.tooling.wrap.WrappedGraphDatabase;
import org.neo4j.tooling.wrap.WrappedIndex;
import org.neo4j.tooling.wrap.WrappedNode;
import org.neo4j.tooling.wrap.WrappedRelationship;

public class HighlyAvailableGraphDatabase
extends WrappedGraphDatabase {
    public static final String CONFIG_KEY_OLD_SERVER_ID = "ha.machine_id";
    public static final String CONFIG_KEY_SERVER_ID = "ha.server_id";
    public static final String CONFIG_KEY_OLD_COORDINATORS = "ha.zoo_keeper_servers";
    public static final String CONFIG_KEY_COORDINATORS = "ha.coordinators";
    public static final String CONFIG_KEY_SERVER = "ha.server";
    public static final String CONFIG_KEY_CLUSTER_NAME = "ha.cluster_name";
    public static final String CONFIG_KEY_PULL_INTERVAL = "ha.pull_interval";
    public static final String CONFIG_KEY_ALLOW_INIT_CLUSTER = "ha.allow_init_cluster";
    public static final String CONFIG_KEY_MAX_CONCURRENT_CHANNELS_PER_SLAVE = "ha.max_concurrent_channels_per_slave";
    public static final String CONFIG_KEY_BRANCHED_DATA_POLICY = "ha.branched_data_policy";
    public static final String CONFIG_KEY_READ_TIMEOUT = "ha.read_timeout";
    public static final String CONFIG_KEY_LOCK_READ_TIMEOUT = "ha.lock_read_timeout";
    public static final String CONFIG_KEY_SLAVE_COORDINATOR_UPDATE_MODE = "ha.slave_coordinator_update_mode";

    public HighlyAvailableGraphDatabase(String storeDir, Map<String, String> config) {
        this(new HAGraphDb(storeDir, config));
    }

    public HighlyAvailableGraphDatabase(HAGraphDb graphdb) {
        super((GraphDatabaseService)graphdb);
    }

    HighlyAvailableGraphDatabase(AbstractGraphDatabase graphdb) {
        super((GraphDatabaseService)graphdb);
    }

    public static Map<String, String> loadConfigurations(String file) {
        return EmbeddedGraphDatabase.loadConfigurations((String)file);
    }

    public void pullUpdates() {
        ((HAGraphDb)this.graphdb).pullUpdates();
    }

    public boolean isMaster() {
        return ((HAGraphDb)this.graphdb).isMaster();
    }

    public HAGraphDb getRawHaDb() {
        return (HAGraphDb)this.graphdb;
    }

    protected WrappedNode<? extends WrappedGraphDatabase> node(Node node, boolean created) {
        if (node == null) {
            return null;
        }
        return new LookupNode(this, node.getId());
    }

    protected WrappedRelationship<? extends WrappedGraphDatabase> relationship(Relationship relationship, boolean created) {
        if (relationship == null) {
            return null;
        }
        return new LookupRelationship(this, relationship.getId());
    }

    protected WrappedIndex.WrappedNodeIndex nodeIndex(Index<Node> index, final String indexName) {
        return new WrappedIndex.WrappedNodeIndex(this){

            protected ReadableIndex<Node> actual() {
                return HighlyAvailableGraphDatabase.this.graphdb.index().forNodes(indexName);
            }
        };
    }

    protected WrappedIndex.WrappedRelationshipIndex relationshipIndex(RelationshipIndex index, final String indexName) {
        return new WrappedIndex.WrappedRelationshipIndex(this){

            protected ReadableRelationshipIndex actual() {
                return HighlyAvailableGraphDatabase.this.graphdb.index().forRelationships(indexName);
            }
        };
    }

    protected WrappedIndex.WrappedNodeIndex automaticNodeIndex(ReadableIndex<Node> index) {
        return new WrappedIndex.WrappedNodeIndex(this){

            protected ReadableIndex<Node> actual() {
                return HighlyAvailableGraphDatabase.this.graphdb.index().getNodeAutoIndexer().getAutoIndex();
            }
        };
    }

    protected WrappedIndex.WrappedRelationshipIndex automaticRelationshipIndex(ReadableRelationshipIndex index) {
        return new WrappedIndex.WrappedRelationshipIndex(this){

            protected ReadableRelationshipIndex actual() {
                return HighlyAvailableGraphDatabase.this.graphdb.index().getRelationshipAutoIndexer().getAutoIndex();
            }
        };
    }

    private static class LookupRelationship
    extends WrappedRelationship<HighlyAvailableGraphDatabase> {
        private final long id;

        LookupRelationship(HighlyAvailableGraphDatabase graphdb, long id) {
            super((WrappedGraphDatabase)graphdb);
            this.id = id;
        }

        protected Relationship actual() {
            return ((HighlyAvailableGraphDatabase)this.graphdb).graphdb.getRelationshipById(this.id);
        }

        public long getId() {
            return this.id;
        }

        public int hashCode() {
            return (int)(this.id >>> 32 ^ this.id);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof LookupRelationship) {
                LookupRelationship that = (LookupRelationship)((Object)obj);
                return this.id == that.id && this.graphdb == that.graphdb;
            }
            return false;
        }
    }

    private static class LookupNode
    extends WrappedNode<HighlyAvailableGraphDatabase> {
        private final long id;

        LookupNode(HighlyAvailableGraphDatabase graphdb, long id) {
            super((WrappedGraphDatabase)graphdb);
            this.id = id;
        }

        protected Node actual() {
            return ((HighlyAvailableGraphDatabase)this.graphdb).graphdb.getNodeById(this.id);
        }

        public long getId() {
            return this.id;
        }

        public int hashCode() {
            return (int)(this.id >>> 32 ^ this.id);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof LookupNode) {
                LookupNode that = (LookupNode)((Object)obj);
                return this.id == that.id && this.graphdb == that.graphdb;
            }
            return false;
        }
    }
}

