/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.zookeeper;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.neo4j.kernel.impl.nioneo.store.StoreId;

public class NeoStoreUtil {
    private static final int RECORD_SIZE = 9;
    private final long creationTime;
    private final long storeId;
    private final long txId;
    private final long logVersion;
    private final long storeVersion;

    public NeoStoreUtil(String storeDir) {
        try {
            FileChannel fileChannel = new RandomAccessFile(NeoStoreUtil.neoStoreFile(storeDir), "r").getChannel();
            int recordsToRead = 5;
            ByteBuffer buf = ByteBuffer.allocate(recordsToRead * 9);
            if (fileChannel.read(buf) != recordsToRead * 9) {
                throw new RuntimeException("Unable to read neo store header information");
            }
            buf.flip();
            this.creationTime = this.nextRecord(buf);
            this.storeId = this.nextRecord(buf);
            this.logVersion = this.nextRecord(buf);
            this.txId = this.nextRecord(buf);
            this.storeVersion = this.nextRecord(buf);
            fileChannel.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private long nextRecord(ByteBuffer buf) {
        buf.get();
        return buf.getLong();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getStoreId() {
        return this.storeId;
    }

    public long getLastCommittedTx() {
        return this.txId;
    }

    public long getLogVersion() {
        return this.logVersion;
    }

    public long getStoreVersion() {
        return this.storeVersion;
    }

    public StoreId asStoreId() {
        return new StoreId(this.creationTime, this.storeId, this.storeVersion);
    }

    public static boolean storeExists(String storeDir) {
        return NeoStoreUtil.neoStoreFile(storeDir).exists();
    }

    private static File neoStoreFile(String storeDir) {
        return new File(storeDir, "neostore");
    }
}

