/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.HAGraphDb;
import org.neo4j.kernel.ha.zookeeper.ZooClient;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperBroker;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperClusterClient;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;

public class TestConfig {
    private LocalhostZooKeeperCluster zoo;
    private final TargetDirectory dir = TargetDirectory.forTest(this.getClass());

    @Before
    public void doBefore() throws Exception {
        this.zoo = LocalhostZooKeeperCluster.singleton().clearDataAndVerifyConnection();
    }

    @Test
    public void testZkSessionTimeout() throws Exception {
        long timeout = 80000L;
        HAGraphDb db = new HAGraphDb(this.dir.directory("zkTimeout").getAbsolutePath(), MapUtil.stringMap((String[])new String[]{"ha.server_id", "1", "ha.coordinators", this.zoo.getConnectionString(), "ha.zk_session_timeout", timeout + "ms"}));
        ZooKeeperBroker broker = (ZooKeeperBroker)db.getBroker();
        Field f = broker.getClass().getDeclaredField("zooClient");
        f.setAccessible(true);
        ZooClient zooClient = (ZooClient)f.get(broker);
        Method m = zooClient.getClass().getSuperclass().getDeclaredMethod("getSessionTimeout", new Class[0]);
        m.setAccessible(true);
        Integer timeoutParsed = (Integer)m.invoke((Object)zooClient, new Object[0]);
        Assert.assertEquals((long)timeout, (long)timeoutParsed.intValue());
        f = db.getClass().getDeclaredField("clusterClient");
        f.setAccessible(true);
        ZooKeeperClusterClient clusterClient = (ZooKeeperClusterClient)f.get(db);
        m = clusterClient.getClass().getSuperclass().getDeclaredMethod("getSessionTimeout", new Class[0]);
        m.setAccessible(true);
        timeoutParsed = (Integer)m.invoke((Object)clusterClient, new Object[0]);
        Assert.assertEquals((long)timeout, (long)timeoutParsed.intValue());
        db.shutdown();
    }
}

