/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperClusterClient;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;
import org.neo4j.tooling.wrap.WrappedGraphDatabase;

public class TestPullUpdates {
    private LocalhostZooKeeperCluster zoo;
    private final HighlyAvailableGraphDatabase[] dbs = new HighlyAvailableGraphDatabase[3];
    private final TargetDirectory dir = TargetDirectory.forTest(this.getClass());
    private static final int PULL_INTERVAL = 100;

    @Before
    public void doBefore() throws Exception {
        this.zoo = LocalhostZooKeeperCluster.singleton().clearDataAndVerifyConnection();
        for (int i = 0; i < this.dbs.length; ++i) {
            this.dbs[i] = this.newDb(i);
        }
    }

    private HighlyAvailableGraphDatabase newDb(int i) {
        return new HighlyAvailableGraphDatabase(this.dir.directory("" + i, true).getAbsolutePath(), MapUtil.stringMap((String[])new String[]{"ha.server_id", "" + i, "ha.server", "localhost:" + (6666 + i), "ha.coordinators", this.zoo.getConnectionString(), "ha.pull_interval", "100ms"}));
    }

    @After
    public void doAfter() throws Exception {
        for (HighlyAvailableGraphDatabase db : this.dbs) {
            if (db == null) continue;
            db.shutdown();
        }
    }

    @Test
    public void makeSureUpdatePullerGetsGoingAfterMasterSwitch() throws Exception {
        int master = this.getCurrentMaster();
        this.setProperty(master, 1);
        this.waitForPropagation(1);
        this.kill(master);
        this.setProperty(this.awaitNewMaster(master), 2);
        this.start(master);
        this.waitForPropagation(2);
    }

    private int awaitNewMaster(int master) throws Exception {
        int newMaster = this.getCurrentMaster();
        while ((newMaster = this.getCurrentMaster()) == master) {
            Thread.sleep(50L);
        }
        return newMaster;
    }

    private void start(int master) {
        this.dbs[master] = this.newDb(master);
    }

    private void kill(int master) {
        this.dbs[master].shutdown();
        this.dbs[master] = null;
    }

    private void waitForPropagation(int i) throws Exception {
        long maxTime = System.currentTimeMillis() + 1000L;
        boolean ok = false;
        while (!ok && System.currentTimeMillis() < maxTime) {
            ok = true;
            for (HighlyAvailableGraphDatabase db : this.dbs) {
                Object value = db.getReferenceNode().getProperty("i", null);
                if (value != null && (Integer)value == i) continue;
                ok = false;
            }
            if (ok) continue;
            Thread.sleep(50L);
        }
        Assert.assertTrue((String)"Change wasn't propagated by pulling updates", (boolean)ok);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProperty(int dbId, int i) {
        HighlyAvailableGraphDatabase db = this.dbs[dbId];
        WrappedGraphDatabase.WrappedTransaction tx = db.beginTx();
        try {
            db.getReferenceNode().setProperty("i", (Object)i);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCurrentMaster() {
        ZooKeeperClusterClient client = new ZooKeeperClusterClient(this.zoo.getConnectionString());
        try {
            int n = client.getMaster().getMachineId();
            return n;
        }
        finally {
            client.shutdown();
        }
    }
}

