/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.zookeeper;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.com.Response;
import org.neo4j.com.SlaveContext;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.ha.ResponseReceiver;
import org.neo4j.kernel.ha.zookeeper.AbstractZooKeeperManager;
import org.neo4j.kernel.ha.zookeeper.ZooClient;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperTimedOutException;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;

public class TestZooClient {
    private static final ResponseReceiver DummyResponseReceiver = new ResponseReceiver(){

        public void reconnect(Exception cause) {
            StringLogger.SYSTEM.logMessage("reconnect called", (Throwable)cause);
        }

        public void newMaster(Exception cause) {
            StringLogger.SYSTEM.logMessage("newMaster called", (Throwable)cause);
        }

        public SlaveContext getSlaveContext(int eventIdentifier) {
            return null;
        }

        public void handle(Exception e) {
        }

        public <T> T receive(Response<T> response) {
            return null;
        }
    };

    @Test
    public void testWaitsForZKQuorumToComeUp() throws Exception {
        long millisForSessionToExpire = 1000L;
        HashMap<String, String> stringConfig = new HashMap<String, String>();
        stringConfig.put("ha.coordinators", "127.0.0.1:3181");
        stringConfig.put("ha.server_id", "1");
        stringConfig.put("ha.zk_session_timeout", Long.toString(1000L));
        ZooClient client = new ZooClient((AbstractGraphDatabase)new ImpermanentGraphDatabase(), stringConfig, DummyResponseReceiver);
        final AtomicBoolean stop = new AtomicBoolean(false);
        Thread launchesZK = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LocalhostZooKeeperCluster cluster = null;
                try {
                    Thread.sleep(2000L);
                    cluster = new LocalhostZooKeeperCluster(this.getClass(), 3181);
                    while (!stop.get()) {
                        Thread.sleep(150L);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                finally {
                    if (cluster != null) {
                        cluster.shutdown();
                    }
                }
            }
        });
        launchesZK.setDaemon(true);
        launchesZK.start();
        client.waitForSyncConnected(AbstractZooKeeperManager.WaitMode.STARTUP);
        client.shutdown();
        stop.set(true);
        launchesZK.join();
    }

    @Test
    public void sessionWaitSyncConnectedTimesOut() throws Exception {
        long secondsForSessionToExpire = 1L;
        HashMap<String, String> stringConfig = new HashMap<String, String>();
        stringConfig.put("ha.coordinators", "localhost:4181");
        stringConfig.put("ha.server_id", "1");
        stringConfig.put("ha.zk_session_timeout", Long.toString(1L));
        ZooClient client = new ZooClient((AbstractGraphDatabase)new ImpermanentGraphDatabase(), stringConfig, DummyResponseReceiver);
        final Thread me = Thread.currentThread();
        final AtomicBoolean allOk = new AtomicBoolean(false);
        Thread wakeMeUp = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                    if (!allOk.get()) {
                        me.interrupt();
                    }
                }
                catch (Exception e) {
                    if (!allOk.get()) {
                        throw new RuntimeException(e);
                    }
                    Thread.interrupted();
                }
            }
        });
        wakeMeUp.setDaemon(true);
        wakeMeUp.start();
        try {
            client.waitForSyncConnected();
            Assert.fail((String)"There is no zookeeper here, it should time out within a session timeout");
        }
        catch (ZooKeeperTimedOutException success) {
            allOk.set(true);
        }
        wakeMeUp.interrupt();
        wakeMeUp.join();
        client.shutdown();
    }
}

