/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.HAGraphDb;
import org.neo4j.kernel.ha.zookeeper.NeoStoreUtil;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperClusterClient;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;

public class TestClusterNames {
    private LocalhostZooKeeperCluster zoo;

    @Before
    public void up() throws Exception {
        this.zoo = LocalhostZooKeeperCluster.singleton().clearDataAndVerifyConnection();
    }

    @Test
    public void makeSureStoreIdInStoreMatchesZKData() throws Exception {
        HAGraphDb db0 = this.db(0, "neo4j.ha", 6361);
        HAGraphDb db1 = this.db(1, "neo4j.ha", 6361);
        this.awaitStarted((GraphDatabaseService)db0);
        this.awaitStarted((GraphDatabaseService)db1);
        db1.shutdown();
        db0.shutdown();
        ZooKeeperClusterClient cm = new ZooKeeperClusterClient(this.zoo.getConnectionString());
        cm.waitForSyncConnected();
        StoreId zkStoreId = StoreId.deserialize((byte[])cm.getZooKeeper(false).getData("/neo4j.ha", false, null));
        StoreId storeId = new NeoStoreUtil(db0.getStoreDir()).asStoreId();
        Assert.assertEquals((Object)storeId, (Object)zkStoreId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void makeSureMultipleHaClustersCanLiveInTheSameZKCluster() throws Exception {
        HAGraphDb db0Cluster1 = null;
        HAGraphDb db1Cluster1 = null;
        HAGraphDb db0Cluster2 = null;
        HAGraphDb db1Cluster2 = null;
        try {
            String cluster1Name = "cluster_1";
            db0Cluster1 = this.db(0, cluster1Name, 6361);
            db1Cluster1 = this.db(1, cluster1Name, 6361);
            this.awaitStarted((GraphDatabaseService)db0Cluster1);
            this.awaitStarted((GraphDatabaseService)db1Cluster1);
            String cluster2Name = "cluster.2";
            db0Cluster2 = this.db(0, cluster2Name, 6362);
            db1Cluster2 = this.db(1, cluster2Name, 6362);
            this.awaitStarted((GraphDatabaseService)db0Cluster2);
            this.awaitStarted((GraphDatabaseService)db1Cluster2);
            String cluster1PropertyName = "c1";
            this.setRefNodeName((AbstractGraphDatabase)db1Cluster1, cluster1PropertyName);
            this.pullUpdates(db0Cluster1, db1Cluster1, db0Cluster2, db1Cluster2);
            Assert.assertEquals((Object)cluster1PropertyName, (Object)db0Cluster1.getReferenceNode().getProperty("name"));
            Assert.assertEquals((Object)cluster1PropertyName, (Object)db1Cluster1.getReferenceNode().getProperty("name"));
            Assert.assertNull((Object)db0Cluster2.getReferenceNode().getProperty("name", null));
            Assert.assertNull((Object)db1Cluster2.getReferenceNode().getProperty("name", null));
            String cluster2PropertyName = "c2";
            this.setRefNodeName((AbstractGraphDatabase)db1Cluster2, cluster2PropertyName);
            this.pullUpdates(db0Cluster1, db1Cluster1, db0Cluster2, db1Cluster2);
            Assert.assertEquals((Object)cluster1PropertyName, (Object)db0Cluster1.getReferenceNode().getProperty("name"));
            Assert.assertEquals((Object)cluster1PropertyName, (Object)db1Cluster1.getReferenceNode().getProperty("name"));
            Assert.assertEquals((Object)cluster2PropertyName, (Object)db0Cluster2.getReferenceNode().getProperty("name"));
            Assert.assertEquals((Object)cluster2PropertyName, (Object)db1Cluster2.getReferenceNode().getProperty("name"));
            db0Cluster1.shutdown();
            this.pullUpdates(db1Cluster1);
            this.setRefNodeName((AbstractGraphDatabase)db1Cluster1, cluster1PropertyName);
            Assert.assertTrue((boolean)db1Cluster1.isMaster());
            db0Cluster1 = this.db(0, cluster1Name, 6361);
            this.pullUpdates(db0Cluster1, db1Cluster1);
            db1Cluster2.shutdown();
            this.pullUpdates(db0Cluster2);
            db1Cluster2 = this.db(1, cluster2Name, 6364);
            this.pullUpdates(db0Cluster2, db1Cluster2);
            cluster1PropertyName = "new c1";
            this.setRefNodeName((AbstractGraphDatabase)db1Cluster1, cluster1PropertyName);
            this.pullUpdates(db0Cluster1, db1Cluster1, db0Cluster2, db1Cluster2);
            Assert.assertEquals((Object)cluster1PropertyName, (Object)db0Cluster1.getReferenceNode().getProperty("name"));
            Assert.assertEquals((Object)cluster1PropertyName, (Object)db1Cluster1.getReferenceNode().getProperty("name"));
            Assert.assertEquals((Object)cluster2PropertyName, (Object)db0Cluster2.getReferenceNode().getProperty("name"));
            Assert.assertEquals((Object)cluster2PropertyName, (Object)db1Cluster2.getReferenceNode().getProperty("name"));
            cluster2PropertyName = "new new c2";
            this.setRefNodeName((AbstractGraphDatabase)db1Cluster2, cluster2PropertyName);
            this.pullUpdates(db0Cluster1, db1Cluster1, db0Cluster2, db1Cluster2);
            Assert.assertEquals((Object)cluster1PropertyName, (Object)db0Cluster1.getReferenceNode().getProperty("name"));
            Assert.assertEquals((Object)cluster1PropertyName, (Object)db1Cluster1.getReferenceNode().getProperty("name"));
            Assert.assertEquals((Object)cluster2PropertyName, (Object)db0Cluster2.getReferenceNode().getProperty("name"));
            Assert.assertEquals((Object)cluster2PropertyName, (Object)db1Cluster2.getReferenceNode().getProperty("name"));
            db0Cluster1.shutdown();
            db0Cluster1 = null;
            db1Cluster1.shutdown();
            db1Cluster1 = null;
            db0Cluster2.shutdown();
            db0Cluster2 = null;
            db1Cluster2.shutdown();
            db1Cluster2 = null;
        }
        catch (Throwable throwable) {
            this.safelyShutdownDbs(db0Cluster1, db1Cluster1, db1Cluster1, db1Cluster2);
            throw throwable;
        }
        this.safelyShutdownDbs(db0Cluster1, db1Cluster1, db1Cluster1, db1Cluster2);
    }

    private void safelyShutdownDbs(HAGraphDb ... dbs) {
        for (HAGraphDb db : dbs) {
            try {
                if (db == null) continue;
                db.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void pullUpdates(HAGraphDb ... dbs) {
        for (HAGraphDb db : dbs) {
            this.pullUpdatesWithRetry(db);
        }
    }

    private void pullUpdatesWithRetry(HAGraphDb db) {
        try {
            db.pullUpdates();
        }
        catch (RuntimeException e) {
            db.pullUpdates();
        }
    }

    private void setRefNodeName(AbstractGraphDatabase db, String name) {
        Transaction tx = db.beginTx();
        db.getReferenceNode().setProperty("name", (Object)name);
        tx.success();
        tx.finish();
    }

    private HAGraphDb db(int serverId, String clusterName, int serverPort) {
        TargetDirectory dir = TargetDirectory.forTest(this.getClass());
        return new HAGraphDb(dir.directory(clusterName + "-" + serverId, true).getAbsolutePath(), MapUtil.stringMap((String[])new String[]{"ha.server_id", String.valueOf(serverId), "ha.coordinators", this.zoo.getConnectionString(), "ha.cluster_name", clusterName, "ha.server", "localhost:" + serverPort, "ha.read_timeout", String.valueOf(2)}));
    }

    private void awaitStarted(GraphDatabaseService db) {
        while (true) {
            try {
                db.getReferenceNode();
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }
}

