/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import java.io.File;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.ha.LocalhostZooKeeperCluster;
import org.neo4j.tooling.wrap.WrappedGraphDatabase;

public class TestInstanceJoin {
    private static LocalhostZooKeeperCluster zoo;
    private final TargetDirectory dir = TargetDirectory.forTest(this.getClass());

    @BeforeClass
    public static void startZoo() throws Exception {
        zoo = LocalhostZooKeeperCluster.singleton().clearDataAndVerifyConnection();
    }

    @Test
    public void testIt() throws Exception {
        HighlyAvailableGraphDatabase master = TestInstanceJoin.start(this.dir.directory("master", true).getAbsolutePath(), 1, zoo.getConnectionString());
        WrappedGraphDatabase.WrappedTransaction tx = master.beginTx();
        master.getReferenceNode().setProperty("foo", (Object)"bar");
        tx.success();
        tx.finish();
        master.shutdown();
        master = TestInstanceJoin.start(this.dir.directory("master", false).getAbsolutePath(), 1, zoo.getConnectionString());
        tx = master.beginTx();
        master.createNode();
        tx.success();
        tx.finish();
        master.shutdown();
        new File(this.dir.directory("master", false), "nioneo_logical.log.v0").delete();
        new File(this.dir.directory("master", false), "nioneo_logical.log.v1").delete();
        HighlyAvailableGraphDatabase slave = TestInstanceJoin.start(this.dir.directory("slave", true).getAbsolutePath(), 2, zoo.getConnectionString());
        tx = slave.beginTx();
        slave.createNode();
        tx.success();
        tx.finish();
        slave.shutdown();
        master = TestInstanceJoin.start(this.dir.directory("master", false).getAbsolutePath(), 1, zoo.getConnectionString());
        slave = TestInstanceJoin.start(this.dir.directory("slave", false).getAbsolutePath(), 2, zoo.getConnectionString());
        Assert.assertEquals((String)"store contents don't seem to be the same", (Object)"bar", (Object)slave.getReferenceNode().getProperty("foo"));
        slave.shutdown();
        master.shutdown();
    }

    private static HighlyAvailableGraphDatabase start(String storeDir, int i, String zkConnectString) {
        return new HighlyAvailableGraphDatabase(storeDir, MapUtil.stringMap((String[])new String[]{"ha.server_id", "" + i, "ha.server", "localhost:" + (6666 + i), "ha.coordinators", zkConnectString, "ha.pull_interval", "0ms"}));
    }
}

