/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.neo4j.com.ComException;
import org.neo4j.com.MasterUtil;
import org.neo4j.com.Response;
import org.neo4j.com.SlaveContext;
import org.neo4j.com.StoreWriter;
import org.neo4j.com.ToFileStoreWriter;
import org.neo4j.com.TxExtractor;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.ErrorState;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Triplet;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.CommonFactories;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.EmbeddedGraphDbImpl;
import org.neo4j.kernel.HaConfig;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.LockManagerFactory;
import org.neo4j.kernel.ha.BranchedDataException;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.BrokerFactory;
import org.neo4j.kernel.ha.ClusterClient;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterIdGeneratorFactory;
import org.neo4j.kernel.ha.MasterServer;
import org.neo4j.kernel.ha.MasterTxHook;
import org.neo4j.kernel.ha.MasterTxIdGenerator;
import org.neo4j.kernel.ha.ResponseReceiver;
import org.neo4j.kernel.ha.SlaveIdGenerator;
import org.neo4j.kernel.ha.SlaveLockManager;
import org.neo4j.kernel.ha.SlaveRelationshipTypeCreator;
import org.neo4j.kernel.ha.SlaveTxHook;
import org.neo4j.kernel.ha.SlaveTxIdGenerator;
import org.neo4j.kernel.ha.ZooKeeperLastCommittedTxIdSetter;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.ha.zookeeper.NoMasterException;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperBroker;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperClusterClient;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperException;
import org.neo4j.kernel.impl.core.LastCommittedTxIdSetter;
import org.neo4j.kernel.impl.core.RelationshipTypeCreator;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.TxHook;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.LogIoUtils;
import org.neo4j.kernel.impl.transaction.xaframework.NoSuchLogVersionException;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGeneratorFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.impl.util.StringLogger;

public class HAGraphDb
extends AbstractGraphDatabase
implements GraphDatabaseService,
ResponseReceiver {
    private final String storeDir;
    private static final int STORE_COPY_RETRIES = 3;
    private static final int NEW_MASTER_STARTUP_RETRIES = 3;
    public static final String COPY_FROM_MASTER_TEMP = "temp-copy";
    private final Map<String, String> config;
    private final BrokerFactory brokerFactory;
    private final Broker broker;
    private ClusterClient clusterClient;
    private volatile EmbeddedGraphDbImpl localGraph;
    private final int machineId;
    private volatile MasterServer masterServer;
    private volatile ScheduledExecutorService updatePuller;
    private volatile long updateTime = 0L;
    private volatile Throwable causeOfShutdown;
    private long startupTime;
    private final BranchedDataPolicy branchedDataPolicy;
    private final HaConfig.SlaveUpdateMode slaveUpdateMode;
    private final int readTimeout;
    private volatile boolean pullUpdates;
    private final List<KernelEventHandler> kernelEventHandlers = new CopyOnWriteArrayList<KernelEventHandler>();
    private final Collection<TransactionEventHandler<?>> transactionEventHandlers = new CopyOnWriteArraySet();
    private final StringLogger msgLog;

    public HAGraphDb(String storeDir, Map<String, String> config) {
        this(storeDir, config, null, null);
    }

    public HAGraphDb(String storeDir, Map<String, String> config, BrokerFactory brokerFactory) {
        this(storeDir, config, brokerFactory, null);
    }

    public HAGraphDb(String storeDir, Map<String, String> config, BrokerFactory brokerFactory, ClusterClient clusterClient) {
        if (config == null) {
            throw new IllegalArgumentException("null config, proper configuration required");
        }
        this.storeDir = storeDir;
        this.config = config;
        this.initializeTxManagerKernelPanicEventHandler();
        this.readTimeout = HaConfig.getClientReadTimeoutFromConfig(config);
        this.slaveUpdateMode = HaConfig.getSlaveUpdateModeFromConfig(config);
        this.machineId = HaConfig.getMachineIdFromConfig(config);
        this.branchedDataPolicy = HaConfig.getBranchedDataPolicyFromConfig(config);
        config.put("keep_logical_logs", "true");
        this.brokerFactory = brokerFactory != null ? brokerFactory : this.defaultBrokerFactory();
        this.broker = this.brokerFactory.create(this, config);
        this.msgLog = StringLogger.getLogger((String)storeDir);
        this.clusterClient = clusterClient != null ? clusterClient : this.defaultClusterClient();
        this.pullUpdates = false;
        this.startUp(HaConfig.getAllowInitFromConfig(config));
    }

    private void initializeTxManagerKernelPanicEventHandler() {
        this.kernelEventHandlers.add(new KernelEventHandler(){

            public void beforeShutdown() {
            }

            public void kernelPanic(ErrorState error) {
                if (error == ErrorState.TX_MANAGER_NOT_OK) {
                    HAGraphDb.this.msgLog.logMessage("TxManager not ok, doing internal restart");
                    HAGraphDb.this.internalShutdown(true);
                    HAGraphDb.this.newMaster(new Exception("Tx manager not ok"));
                }
            }

            public Object getResource() {
                return null;
            }

            public KernelEventHandler.ExecutionOrder orderComparedTo(KernelEventHandler other) {
                return KernelEventHandler.ExecutionOrder.DOESNT_MATTER;
            }
        });
    }

    private void getFreshDatabaseFromMaster(boolean branched) {
        this.broker.shutdown();
        try {
            Pair<Master, Machine> master = this.clusterClient.getMasterClient();
            this.internalShutdown(false);
            if (branched) {
                this.makeWayForNewDb();
            }
            Exception exception = null;
            for (int i = 0; i < 3; ++i) {
                try {
                    BranchedDataPolicy.keep_none.handle(this);
                    this.copyStoreFromMaster(master);
                    this.moveCopiedStoreIntoWorkingDir();
                    return;
                }
                catch (Exception e) {
                    this.msgLog.logMessage("Problems copying store from master", (Throwable)e);
                    this.sleepWithoutInterruption(1000L, "");
                    exception = e;
                    master = this.clusterClient.getMasterClient();
                    continue;
                }
            }
            throw new RuntimeException("Gave up trying to copy store from master", exception);
        }
        finally {
            this.broker.start();
        }
    }

    private File getTempDir() {
        return new File(this.getStoreDir(), COPY_FROM_MASTER_TEMP);
    }

    private void moveCopiedStoreIntoWorkingDir() {
        File storeDir = new File(this.getStoreDir());
        for (File candidate : this.getTempDir().listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getName().equals("messages.log");
            }
        })) {
            FileUtils.moveFile((File)candidate, (File)storeDir);
        }
    }

    private File getClearedTempDir() throws IOException {
        File temp = this.getTempDir();
        if (!temp.mkdir()) {
            FileUtils.deleteRecursively((File)temp);
            temp.mkdir();
        }
        return temp;
    }

    void makeWayForNewDb() {
        this.msgLog.logMessage("Cleaning database " + this.storeDir + " (" + this.branchedDataPolicy.name() + ") to make way for new db from master");
        this.branchedDataPolicy.handle(this);
    }

    private synchronized void startUp(boolean allowInit) {
        this.msgLog.logMessage("Starting up highly available graph database '" + this.storeDir + "'");
        StoreId storeId = null;
        if (!new File(this.storeDir, "neostore").exists()) {
            Pair<Master, Machine> master;
            long endTime = System.currentTimeMillis() + 60000L;
            Exception exception = null;
            while (System.currentTimeMillis() < endTime && (master = this.broker.bootstrap()) != null && !((Machine)master.other()).equals(Machine.NO_MACHINE) && ((Machine)master.other()).getMachineId() != this.machineId) {
                try {
                    this.getFreshDatabaseFromMaster(false);
                    this.msgLog.logMessage("copied store from master");
                    exception = null;
                    break;
                }
                catch (Exception e) {
                    exception = e;
                    master = this.broker.getMasterReally(true);
                    this.msgLog.logMessage("Problems copying store from master", (Throwable)e);
                    this.sleepWithoutInterruption(300L, "Startup interrupted");
                }
            }
            if (exception != null) {
                throw new RuntimeException("Tried to join the cluster, but was unable to", exception);
            }
        }
        storeId = this.broker.getClusterStoreId(true);
        this.newMaster(storeId, new Exception("Starting up for the first time"));
        this.localGraph();
    }

    private void checkAndRecoverCorruptLogs(EmbeddedGraphDbImpl localDb, boolean copiedStore) {
        this.msgLog.logMessage("Checking for log consistency");
        XaDataSource dataSource = localDb.getConfig().getTxModule().getXaDataSourceManager().getXaDataSource("nioneodb");
        this.msgLog.logMessage("Checking dataSource " + dataSource.getName());
        boolean corrupted = false;
        long version = -1L;
        long myLastCommittedTx = dataSource.getLastCommittedTxId();
        if (myLastCommittedTx == 1L) {
            return;
        }
        try {
            int masterId = (Integer)dataSource.getMasterForCommittedTx(myLastCommittedTx).first();
            if (masterId == -1) {
                corrupted = true;
            }
        }
        catch (NoSuchLogVersionException e) {
            this.msgLog.logMessage("Missing log version " + e.getVersion() + " for transaction " + myLastCommittedTx + " and datasource " + dataSource.getName());
            corrupted = true;
            version = e.getVersion();
        }
        catch (IOException e) {
            this.msgLog.logMessage("IO exceptions while trying to retrieve the master for the latest txid (= " + myLastCommittedTx + " )", (Throwable)e);
        }
        catch (RuntimeException e) {
            this.msgLog.logMessage("Runtime exception while getting master id for for transaction " + myLastCommittedTx + " and datasource " + dataSource.getName(), (Throwable)e);
            corrupted = true;
            version = dataSource.getCurrentLogVersion() - 1L;
        }
        if (corrupted) {
            if (version != -1L) {
                this.msgLog.logMessage("Logical log file for transaction " + myLastCommittedTx + " not found.");
            } else {
                this.msgLog.logMessage("Tried to extract transaction " + myLastCommittedTx + " but it was not present in the log. Trying to retrieve it from master.");
            }
            if (copiedStore) {
                this.msgLog.logMessage("A store copy might be in progress. Will not act on the apparent corruption");
            } else {
                try {
                    this.copyLogFromMaster(this.broker.getMaster(), "nioneodb", version, myLastCommittedTx, myLastCommittedTx);
                    dataSource.getMasterForCommittedTx(myLastCommittedTx);
                    this.msgLog.logMessage("Log copy finished without problems");
                }
                catch (Exception e) {
                    this.msgLog.logMessage("Failed to retrieve log version " + version + " from master.", (Throwable)e);
                }
            }
        }
    }

    private void sleepWithoutInterruption(long time, String errorMessage) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(errorMessage, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStoreFromMaster(Pair<Master, Machine> master) throws Exception {
        this.msgLog.logMessage("Copying store from master");
        String temp = this.getClearedTempDir().getAbsolutePath();
        Response<Void> response = ((Master)master.first()).copyStore(this.emptyContext(), (StoreWriter)new ToFileStoreWriter(temp));
        long highestLogVersion = this.highestLogVersion(temp);
        if (highestLogVersion > -1L) {
            NeoStore.setVersion((String)temp, (long)(highestLogVersion + 1L));
        }
        EmbeddedGraphDatabase copiedDb = new EmbeddedGraphDatabase(temp, MapUtil.stringMap((String[])new String[]{"keep_logical_logs", "true"}));
        try {
            MasterUtil.applyReceivedTransactions(response, (GraphDatabaseService)copiedDb, (MasterUtil.TxHandler)MasterUtil.txHandlerForFullCopy());
        }
        finally {
            copiedDb.shutdown();
            response.close();
        }
        this.msgLog.logMessage("Done copying store from master");
    }

    private SlaveContext emptyContext() {
        return new SlaveContext(0L, this.machineId, 0, new SlaveContext.Tx[0], 0, 0L);
    }

    private void copyLogFromMaster(Pair<Master, Machine> master, String datasource, long logVersion, long startTxId, long endTxId) throws Exception {
        Response<Void> response = ((Master)master.first()).copyTransactions(this.emptyContext(), datasource, startTxId, endTxId);
        if (logVersion == -1L) {
            this.receive(response);
            return;
        }
        XaDataSource ds = this.localGraph().getConfig().getTxModule().getXaDataSourceManager().getXaDataSource(datasource);
        FileChannel newLog = ((FileSystemAbstraction)this.localGraph().getConfig().getParams().get(FileSystemAbstraction.class)).open(ds.getFileName(logVersion), "rw");
        newLog.truncate(0L);
        ByteBuffer scratch = ByteBuffer.allocate(64);
        LogIoUtils.writeLogHeader((ByteBuffer)scratch, (long)logVersion, (long)startTxId);
        newLog.write(scratch);
        ReadableByteChannel received = ((TxExtractor)((Triplet)response.transactions().next()).third()).extract();
        scratch.flip();
        while (received.read(scratch) > 0) {
            scratch.flip();
            newLog.write(scratch);
            scratch.flip();
        }
        newLog.force(false);
        newLog.close();
    }

    private long highestLogVersion(String targetStoreDir) {
        return XaLogicalLog.getHighestHistoryLogVersion((File)new File(targetStoreDir), (String)"nioneo_logical.log");
    }

    private EmbeddedGraphDbImpl localGraph() {
        if (this.localGraph != null) {
            return this.localGraph;
        }
        int secondsWait = Math.max(HaConfig.getClientReadTimeoutFromConfig(this.config) - 5, 5);
        return this.waitForCondition(new LocalGraphAvailableCondition(), secondsWait * 1000);
    }

    private <T, E extends Exception> T waitForCondition(Condition<T, E> condition, int timeMillis) throws E {
        long endTime = System.currentTimeMillis() + (long)timeMillis;
        T result = condition.tryToFullfill();
        while (result == null && System.currentTimeMillis() < endTime) {
            this.sleepWithoutInterruption(1L, "Failed waiting for " + condition + " to be fulfilled");
            result = condition.tryToFullfill();
            if (result == null) continue;
            return result;
        }
        throw condition.failure();
    }

    private BrokerFactory defaultBrokerFactory() {
        return new BrokerFactory(){

            @Override
            public Broker create(AbstractGraphDatabase graphDb, Map<String, String> config) {
                return new ZooKeeperBroker(graphDb, config, HAGraphDb.this);
            }
        };
    }

    private ClusterClient defaultClusterClient() {
        return new ZooKeeperClusterClient(HaConfig.getCoordinatorsFromConfig(this.config), HaConfig.getClusterNameFromConfig(this.config), this, HaConfig.getZKSessionTimeoutFromConfig(this.config));
    }

    public Broker getBroker() {
        return this.broker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pullUpdates() {
        block12: {
            try {
                if (this.masterServer != null) break block12;
                if (this.broker.getMaster() == null && this.broker instanceof ZooKeeperBroker) {
                    this.msgLog.logMessage("ZooKeeper broker returned null master");
                    this.newMaster(new NullPointerException("master returned from broker"));
                } else if (this.broker.getMaster().first() == null) {
                    this.newMaster(new NullPointerException("master returned from broker"));
                }
                SlaveContext slaveContext = null;
                if (!this.pullUpdates) {
                    throw new NoMasterException();
                }
                HAGraphDb hAGraphDb = this;
                synchronized (hAGraphDb) {
                    if (!this.pullUpdates) {
                        return;
                    }
                    slaveContext = this.getSlaveContext(-1);
                }
                this.receive(((Master)this.broker.getMaster().first()).pullUpdates(slaveContext));
            }
            catch (ZooKeeperException e) {
                this.newMaster(e);
                throw e;
            }
            catch (NoMasterException e) {
                this.newMaster((Exception)((Object)e));
                throw e;
            }
            catch (ComException e) {
                throw e;
            }
        }
    }

    private void updateTime() {
        this.updateTime = System.currentTimeMillis();
    }

    long lastUpdateTime() {
        return this.updateTime;
    }

    public Config getConfig() {
        return this.localGraph().getConfig();
    }

    public String getStoreDir() {
        return this.storeDir;
    }

    public <T> Collection<T> getManagementBeans(Class<T> type) {
        return this.localGraph().getManagementBeans(type);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getStoreDir() + ", " + "ha.server_id" + ":" + this.machineId + "]";
    }

    @Override
    public synchronized void reconnect(Exception e) {
        if (this.broker != null) {
            this.broker.restart();
        }
        this.newMaster(e);
    }

    protected synchronized void reevaluateMyself(StoreId storeId) {
        Pair<Master, Machine> master = this.broker.getMasterReally(true);
        boolean iAmCurrentlyMaster = this.masterServer != null;
        this.msgLog.logMessage("ReevaluateMyself: machineId=" + this.machineId + " with master[" + master + "] (I am master=" + iAmCurrentlyMaster + ", " + this.localGraph + ")");
        this.pullUpdates = false;
        EmbeddedGraphDbImpl newDb = null;
        try {
            if (((Machine)master.other()).getMachineId() == this.machineId) {
                if (this.localGraph == null || !iAmCurrentlyMaster) {
                    this.internalShutdown(true);
                    newDb = this.startAsMaster(storeId);
                }
                this.broker.rebindMaster();
            } else {
                this.broker.notifyMasterChange((Machine)master.other());
                if (this.localGraph == null || iAmCurrentlyMaster) {
                    this.internalShutdown(true);
                    newDb = this.startAsSlave(storeId, master);
                } else {
                    ((SlaveIdGenerator.SlaveIdGeneratorFactory)this.getConfig().getIdGeneratorFactory()).forgetIdAllocationsFromMaster();
                }
            }
            if (this.masterServer == null) {
                this.instantiateAutoUpdatePullerIfConfigSaysSo();
                this.checkAndRecoverCorruptLogs(newDb != null ? newDb : this.localGraph, false);
                this.ensureDataConsistencyWithMaster(newDb != null ? newDb : this.localGraph, master);
                this.msgLog.logMessage("Data consistent with master");
            }
            if (newDb != null) {
                this.doAfterLocalGraphStarted(newDb);
                this.localGraph = newDb;
            }
            this.pullUpdates = true;
        }
        catch (Throwable t) {
            this.safelyShutdownDb(newDb);
            throw Exceptions.launderedException((Throwable)t);
        }
    }

    private void safelyShutdownDb(EmbeddedGraphDbImpl newDb) {
        try {
            if (newDb != null) {
                newDb.shutdown();
            }
        }
        catch (Exception e) {
            this.msgLog.logMessage("Couldn't shut down newly started db", (Throwable)e);
        }
    }

    private void doAfterLocalGraphStarted(EmbeddedGraphDbImpl newDb) {
        this.broker.setConnectionInformation(newDb.getKernelData());
        for (TransactionEventHandler<?> transactionEventHandler : this.transactionEventHandlers) {
            newDb.registerTransactionEventHandler(transactionEventHandler);
        }
        for (KernelEventHandler kernelEventHandler : this.kernelEventHandlers) {
            newDb.registerKernelEventHandler(kernelEventHandler);
        }
    }

    private void logHaInfo(String started) {
        this.msgLog.logMessage(started, true);
        this.msgLog.logMessage("--- HIGH AVAILABILITY CONFIGURATION START ---");
        this.broker.logStatus(this.msgLog);
        this.msgLog.logMessage("--- HIGH AVAILABILITY CONFIGURATION END ---", true);
    }

    private EmbeddedGraphDbImpl startAsSlave(StoreId storeId, Pair<Master, Machine> master) {
        this.msgLog.logMessage("Starting[" + this.machineId + "] as slave", true);
        EmbeddedGraphDbImpl result = new EmbeddedGraphDbImpl(this.storeDir, storeId, this.config, (GraphDatabaseService)this, (LockManagerFactory)new SlaveLockManager.SlaveLockManagerFactory(this.broker, this), (IdGeneratorFactory)new SlaveIdGenerator.SlaveIdGeneratorFactory(this.broker, this), (RelationshipTypeCreator)new SlaveRelationshipTypeCreator(this.broker, this), (TxIdGeneratorFactory)new SlaveTxIdGenerator.SlaveTxIdGeneratorFactory(this.broker, this), (TxHook)new SlaveTxHook(this.broker, this), this.slaveUpdateMode.createUpdater(this.broker), CommonFactories.defaultFileSystemAbstraction());
        this.logHaInfo("Started as slave");
        this.startupTime = System.currentTimeMillis();
        return result;
    }

    private EmbeddedGraphDbImpl startAsMaster(StoreId storeId) {
        this.msgLog.logMessage("Starting[" + this.machineId + "] as master", true);
        EmbeddedGraphDbImpl result = new EmbeddedGraphDbImpl(this.storeDir, storeId, this.config, (GraphDatabaseService)this, CommonFactories.defaultLockManagerFactory(), (IdGeneratorFactory)new MasterIdGeneratorFactory(), CommonFactories.defaultRelationshipTypeCreator(), (TxIdGeneratorFactory)new MasterTxIdGenerator.MasterTxIdGeneratorFactory(this.broker), (TxHook)new MasterTxHook(), (LastCommittedTxIdSetter)new ZooKeeperLastCommittedTxIdSetter(this.broker), CommonFactories.defaultFileSystemAbstraction());
        this.masterServer = (MasterServer)((Object)this.broker.instantiateMasterServer(this));
        this.logHaInfo("Started as master");
        this.startupTime = System.currentTimeMillis();
        return result;
    }

    private void ensureDataConsistencyWithMaster(EmbeddedGraphDbImpl newDb, Pair<Master, Machine> master) {
        Pair mastersMaster;
        Pair myMaster;
        if (((Machine)master.other()).getMachineId() == this.machineId) {
            this.msgLog.logMessage("I am master so cannot consistency check data with master");
            return;
        }
        if (master.first() == null) {
            RuntimeException cause = new RuntimeException("Unable to get master from ZK");
            this.shutdown(cause, false);
            throw cause;
        }
        XaDataSource nioneoDataSource = newDb.getConfig().getTxModule().getXaDataSourceManager().getXaDataSource("nioneodb");
        long myLastCommittedTx = nioneoDataSource.getLastCommittedTxId();
        try {
            myMaster = nioneoDataSource.getMasterForCommittedTx(myLastCommittedTx);
        }
        catch (NoSuchLogVersionException e) {
            this.msgLog.logMessage("Logical log file for txId " + myLastCommittedTx + " missing [version=" + e.getVersion() + "]. If this is startup then it will be recovered later, otherwise it might be a problem.");
            return;
        }
        catch (IOException e) {
            this.msgLog.logMessage("Failed to get master ID for txId " + myLastCommittedTx + ".", (Throwable)e);
            return;
        }
        catch (Exception e) {
            this.msgLog.logMessage("Exception while getting master ID for txId " + myLastCommittedTx + ".", (Throwable)e);
            throw new BranchedDataException("Maybe not branched data, but it could solve it", e);
        }
        Response<Pair<Integer, Long>> response = null;
        try {
            response = ((Master)master.first()).getMasterIdForCommittedTx(myLastCommittedTx, this.getStoreId(newDb));
            mastersMaster = (Pair)response.response();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof NoSuchLogVersionException) {
                throw new BranchedDataException("Maybe not branched data, but it could solve it", e.getCause());
            }
            throw e;
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        if ((Integer)myMaster.first() != -1 && !myMaster.equals((Object)mastersMaster)) {
            String msg = "Branched data, I (machineId:" + this.machineId + ") think machineId for txId (" + myLastCommittedTx + ") is " + myMaster + ", but master (machineId:" + ((Machine)master.other()).getMachineId() + ") says that it's " + mastersMaster;
            this.msgLog.logMessage(msg, true);
            BranchedDataException exception = new BranchedDataException(msg);
            this.safelyShutdownDb(newDb);
            this.shutdown(exception, false);
            throw exception;
        }
        this.msgLog.logMessage("Master id for last committed tx ok with highestTxId=" + myLastCommittedTx + " with masterId=" + myMaster, true);
    }

    private StoreId getStoreId(EmbeddedGraphDbImpl db) {
        XaDataSource ds = db.getConfig().getTxModule().getXaDataSourceManager().getXaDataSource("nioneodb");
        return ((NeoStoreXaDataSource)ds).getStoreId();
    }

    private void instantiateAutoUpdatePullerIfConfigSaysSo() {
        long pullInterval = HaConfig.getPullIntervalFromConfig(this.config);
        if (pullInterval > 0L && this.updatePuller == null) {
            this.updatePuller = new ScheduledThreadPoolExecutor(1);
            this.updatePuller.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (!HAGraphDb.this.pullUpdates) {
                        return;
                    }
                    try {
                        HAGraphDb.this.pullUpdates();
                    }
                    catch (Exception e) {
                        HAGraphDb.this.msgLog.logMessage("Pull updates failed", (Throwable)e);
                    }
                }
            }, pullInterval, pullInterval, TimeUnit.MILLISECONDS);
        }
    }

    public Transaction beginTx() {
        return this.localGraph().beginTx();
    }

    public Node createNode() {
        return this.localGraph().createNode();
    }

    public Iterable<Node> getAllNodes() {
        return this.localGraph().getAllNodes();
    }

    public Node getNodeById(long id) {
        return this.localGraph().getNodeById(id);
    }

    public Node getReferenceNode() {
        return this.localGraph().getReferenceNode();
    }

    public Relationship getRelationshipById(long id) {
        return this.localGraph().getRelationshipById(id);
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.localGraph().getRelationshipTypes();
    }

    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        this.kernelEventHandlers.add(handler);
        return this.localGraph().registerKernelEventHandler(handler);
    }

    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        this.transactionEventHandlers.add(handler);
        return this.localGraph().registerTransactionEventHandler(handler);
    }

    public synchronized void internalShutdown(boolean rotateLogs) {
        this.msgLog.logMessage("Internal shutdown of HA db[" + this.machineId + "] reference=" + this + ", masterServer=" + (Object)((Object)this.masterServer), (Throwable)new Exception("Internal shutdown"), true);
        this.pullUpdates = false;
        if (this.updatePuller != null) {
            this.msgLog.logMessage("Internal shutdown updatePuller", true);
            try {
                this.updatePuller.shutdown();
                this.updatePuller.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.msgLog.logMessage("Got exception while waiting for update puller termination", (Throwable)e, true);
            }
            this.msgLog.logMessage("Internal shutdown updatePuller DONE", true);
            this.updatePuller = null;
        }
        if (this.masterServer != null) {
            this.msgLog.logMessage("Internal shutdown masterServer", true);
            this.masterServer.shutdown();
            this.msgLog.logMessage("Internal shutdown masterServer DONE", true);
            this.masterServer = null;
        }
        if (this.localGraph != null) {
            if (rotateLogs) {
                for (XaDataSource dataSource : this.getConfig().getTxModule().getXaDataSourceManager().getAllRegisteredDataSources()) {
                    try {
                        dataSource.rotateLogicalLog();
                    }
                    catch (IOException e) {
                        this.msgLog.logMessage("Couldn't rotate logical log for " + dataSource.getName(), (Throwable)e);
                    }
                }
            }
            this.msgLog.logMessage("Internal shutdown localGraph", true);
            this.localGraph.shutdown();
            this.msgLog.logMessage("Internal shutdown localGraph DONE", true);
            this.localGraph = null;
        }
        this.msgLog.flush();
        StringLogger.close((String)this.storeDir);
    }

    private synchronized void shutdown(Throwable cause, boolean shutdownBroker) {
        this.causeOfShutdown = cause;
        this.msgLog.logMessage("Shutdown[" + this.machineId + "], " + this, true);
        if (shutdownBroker && this.broker != null) {
            this.broker.shutdown();
        }
        this.internalShutdown(false);
    }

    public synchronized void shutdown() {
        this.shutdown(new IllegalStateException("shutdown called"), true);
    }

    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        return this.localGraph().unregisterKernelEventHandler(handler);
    }

    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.localGraph().unregisterTransactionEventHandler(handler);
    }

    @Override
    public SlaveContext getSlaveContext(int eventIdentifier) {
        try {
            XaDataSourceManager localDataSourceManager = this.getConfig().getTxModule().getXaDataSourceManager();
            Collection dataSources = localDataSourceManager.getAllRegisteredDataSources();
            SlaveContext.Tx[] txs = new SlaveContext.Tx[dataSources.size()];
            int i = 0;
            Pair master = null;
            for (XaDataSource dataSource : dataSources) {
                long txId = dataSource.getLastCommittedTxId();
                if (dataSource.getName().equals("nioneodb")) {
                    master = dataSource.getMasterForCommittedTx(txId);
                }
                txs[i++] = SlaveContext.lastAppliedTx((String)dataSource.getName(), (long)txId);
            }
            return new SlaveContext(this.startupTime, this.machineId, eventIdentifier, txs, ((Integer)master.first()).intValue(), ((Long)master.other()).longValue());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T receive(Response<T> response) {
        try {
            MasterUtil.applyReceivedTransactions(response, (GraphDatabaseService)this, (MasterUtil.TxHandler)MasterUtil.NO_ACTION);
            this.updateTime();
            Object object = response.response();
            return (T)object;
        }
        catch (IOException e) {
            this.newMaster(e);
            throw new RuntimeException(e);
        }
        finally {
            response.close();
        }
    }

    public void handle(Exception e) {
        this.newMaster(e);
    }

    @Override
    public void newMaster(Exception e) {
        this.newMaster(null, e);
    }

    private synchronized void newMaster(StoreId storeId, Exception e) {
        if (e instanceof ComException && e.getCause() instanceof BranchedDataException) {
            BranchedDataException bde = (BranchedDataException)e.getCause();
            this.msgLog.logMessage("Master says I've got branched data: " + bde);
        }
        Throwable cause = null;
        int i = 0;
        boolean unexpectedException = false;
        while (i++ < 3) {
            try {
                this.msgLog.logMessage("newMaster called", e, true);
                this.reevaluateMyself(storeId);
                return;
            }
            catch (ZooKeeperException zke) {
                this.msgLog.logMessage("ZooKeeper exception in newMaster, retry #" + i, (Throwable)zke);
                e = zke;
                cause = zke;
                this.sleepWithoutInterruption(500L, "");
            }
            catch (ComException ce) {
                this.msgLog.logMessage("Communication exception in newMaster, retry #" + i, (Throwable)ce);
                e = ce;
                cause = ce;
                this.sleepWithoutInterruption(500L, "");
            }
            catch (BranchedDataException bde) {
                this.msgLog.logMessage("Branched data occurred, during newMaster retry #" + i, (Throwable)bde);
                this.getFreshDatabaseFromMaster(true);
                e = bde;
                cause = bde;
            }
            catch (Throwable t) {
                cause = t;
                unexpectedException = true;
                break;
            }
        }
        if (cause != null && unexpectedException) {
            this.msgLog.logMessage("Reevaluation ended in unknown exception " + cause + " so shutting down", cause, true);
            this.shutdown(cause, false);
        }
        throw Exceptions.launderedException(cause);
    }

    public MasterServer getMasterServerIfMaster() {
        return this.masterServer;
    }

    int getMachineId() {
        return this.machineId;
    }

    public boolean isMaster() {
        return this.getMasterServerIfMaster() != null;
    }

    public boolean isReadOnly() {
        return false;
    }

    public IndexManager index() {
        return this.localGraph().index();
    }

    public void shutdownBroker() {
        this.broker.shutdown();
    }

    private class LocalGraphAvailableCondition
    implements Condition<EmbeddedGraphDbImpl, RuntimeException> {
        private LocalGraphAvailableCondition() {
        }

        @Override
        public EmbeddedGraphDbImpl tryToFullfill() {
            return HAGraphDb.this.localGraph;
        }

        @Override
        public RuntimeException failure() {
            if (HAGraphDb.this.causeOfShutdown != null) {
                return new RuntimeException("Graph database not started", HAGraphDb.this.causeOfShutdown);
            }
            return new RuntimeException("Graph database not assigned and no cause of shutdown, maybe not started yet or in the middle of master/slave swap?");
        }
    }

    private static interface Condition<T, E extends Exception> {
        public T tryToFullfill();

        public E failure();
    }

    static enum BranchedDataPolicy {
        keep_all{

            @Override
            void handle(HAGraphDb db) {
                this.moveAwayDb(db, this.branchedDataDir(db));
            }
        }
        ,
        keep_last{

            @Override
            void handle(HAGraphDb db) {
                File branchedDataDir = this.branchedDataDir(db);
                this.moveAwayDb(db, branchedDataDir);
                for (File file : new File(db.storeDir).listFiles()) {
                    if (!this.isBranchedDataDirectory(file) || file.equals(branchedDataDir)) continue;
                    try {
                        FileUtils.deleteRecursively((File)file);
                    }
                    catch (IOException e) {
                        db.msgLog.logMessage("Couldn't delete old branched data directory " + file, (Throwable)e);
                    }
                }
            }
        }
        ,
        keep_none{

            @Override
            void handle(HAGraphDb db) {
                for (File file : this.relevantDbFiles(db)) {
                    try {
                        FileUtils.deleteRecursively((File)file);
                    }
                    catch (IOException e) {
                        db.msgLog.logMessage("Couldn't delete file " + file, (Throwable)e);
                    }
                }
            }
        }
        ,
        shutdown{

            @Override
            void handle(HAGraphDb db) {
                db.shutdown();
            }
        };

        static String BRANCH_PREFIX;

        abstract void handle(HAGraphDb var1);

        protected void moveAwayDb(HAGraphDb db, File branchedDataDir) {
            for (File file : this.relevantDbFiles(db)) {
                File dest = new File(branchedDataDir, file.getName());
                if (file.renameTo(dest)) continue;
                db.msgLog.logMessage("Couldn't move " + file.getPath());
            }
        }

        File branchedDataDir(HAGraphDb db) {
            File result = new File(db.storeDir, BRANCH_PREFIX + System.currentTimeMillis());
            result.mkdirs();
            return result;
        }

        File[] relevantDbFiles(HAGraphDb db) {
            return new File(db.storeDir).listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return !file.getName().equals("messages.log") && !BranchedDataPolicy.this.isBranchedDataDirectory(file);
                }
            });
        }

        boolean isBranchedDataDirectory(File file) {
            return file.isDirectory() && file.getName().startsWith(BRANCH_PREFIX);
        }

        static {
            BRANCH_PREFIX = "branched-";
        }
    }
}

