/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.zookeeper;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.neo4j.com.Client;
import org.neo4j.com.ComException;
import org.neo4j.com.Response;
import org.neo4j.com.SlaveContext;
import org.neo4j.com.StoreWriter;
import org.neo4j.com.TxExtractor;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.ha.IdAllocation;
import org.neo4j.kernel.ha.LockResult;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterClient;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.ha.zookeeper.NoMasterException;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperException;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperMachine;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.util.StringLogger;

public abstract class AbstractZooKeeperManager
implements Watcher {
    protected static final String HA_SERVERS_CHILD = "ha-servers";
    private final String servers;
    private final Map<Integer, String> haServersCache = Collections.synchronizedMap(new HashMap());
    private volatile Pair<Master, Machine> cachedMaster = NO_MASTER_MACHINE_PAIR;
    private final AbstractGraphDatabase graphDb;
    private final StringLogger msgLog;
    private final int maxConcurrentChannelsPerSlave;
    private final int clientReadTimeout;
    private final int clientLockReadTimeout;
    private final long sessionTimeout;
    private static final Master NO_MASTER = new Master(){

        @Override
        public void shutdown() {
        }

        @Override
        public Response<Void> pullUpdates(SlaveContext context) {
            throw this.noMasterException();
        }

        private ComException noMasterException() {
            return new NoMasterException();
        }

        @Override
        public Response<Void> initializeTx(SlaveContext context) {
            throw this.noMasterException();
        }

        @Override
        public Response<Pair<Integer, Long>> getMasterIdForCommittedTx(long txId, StoreId myStoreId) {
            throw this.noMasterException();
        }

        @Override
        public Response<Void> finishTransaction(SlaveContext context, boolean success) {
            throw this.noMasterException();
        }

        @Override
        public Response<Integer> createRelationshipType(SlaveContext context, String name) {
            throw this.noMasterException();
        }

        @Override
        public Response<Void> copyStore(SlaveContext context, StoreWriter writer) {
            throw this.noMasterException();
        }

        @Override
        public Response<Void> copyTransactions(SlaveContext context, String dsName, long startTxId, long endTxId) {
            throw this.noMasterException();
        }

        @Override
        public Response<Long> commitSingleResourceTransaction(SlaveContext context, String resource, TxExtractor txGetter) {
            throw this.noMasterException();
        }

        @Override
        public Response<IdAllocation> allocateIds(IdType idType) {
            throw this.noMasterException();
        }

        @Override
        public Response<LockResult> acquireRelationshipWriteLock(SlaveContext context, long ... relationships) {
            throw this.noMasterException();
        }

        @Override
        public Response<LockResult> acquireRelationshipReadLock(SlaveContext context, long ... relationships) {
            throw this.noMasterException();
        }

        @Override
        public Response<LockResult> acquireNodeWriteLock(SlaveContext context, long ... nodes) {
            throw this.noMasterException();
        }

        @Override
        public Response<LockResult> acquireNodeReadLock(SlaveContext context, long ... nodes) {
            throw this.noMasterException();
        }

        @Override
        public Response<LockResult> acquireIndexReadLock(SlaveContext context, String index, String key) {
            throw this.noMasterException();
        }

        @Override
        public Response<LockResult> acquireIndexWriteLock(SlaveContext context, String index, String key) {
            throw this.noMasterException();
        }

        public String toString() {
            return "NO_MASTER";
        }
    };
    public static final Pair<Master, Machine> NO_MASTER_MACHINE_PAIR = Pair.of((Object)NO_MASTER, (Object)ZooKeeperMachine.NO_MACHINE);

    public AbstractZooKeeperManager(String servers, AbstractGraphDatabase graphDb, int clientReadTimeout, int clientLockReadTimeout, int maxConcurrentChannelsPerSlave, long sessionTimeout) {
        this.servers = servers;
        this.graphDb = graphDb;
        this.clientLockReadTimeout = clientLockReadTimeout;
        this.maxConcurrentChannelsPerSlave = maxConcurrentChannelsPerSlave;
        this.clientReadTimeout = clientReadTimeout;
        if (graphDb != null) {
            String storeDir = graphDb.getStoreDir();
            this.msgLog = StringLogger.getLogger((String)storeDir);
        } else {
            this.msgLog = null;
        }
        this.sessionTimeout = sessionTimeout;
    }

    protected ZooKeeper instantiateZooKeeper() {
        try {
            return new ZooKeeper(this.getServers(), this.getSessionTimeout(), (Watcher)this);
        }
        catch (IOException e) {
            throw new ZooKeeperException("Unable to create zoo keeper client", e);
        }
    }

    protected int getSessionTimeout() {
        return (int)this.sessionTimeout;
    }

    public abstract ZooKeeper getZooKeeper(boolean var1);

    public abstract String getRoot();

    protected AbstractGraphDatabase getGraphDb() {
        return this.graphDb;
    }

    protected Pair<Integer, Integer> parseChild(String child) {
        int index = child.indexOf(95);
        if (index == -1) {
            return null;
        }
        int id = Integer.parseInt(child.substring(0, index));
        int seq = Integer.parseInt(child.substring(index + 1));
        return Pair.of((Object)id, (Object)seq);
    }

    protected Pair<Long, Integer> readDataRepresentingInstance(String path) throws InterruptedException, KeeperException {
        byte[] data = this.getZooKeeper(false).getData(path, false, null);
        ByteBuffer buf = ByteBuffer.wrap(data);
        return Pair.of((Object)buf.getLong(), (Object)buf.getInt());
    }

    protected void invalidateMaster() {
        if (this.cachedMaster != null) {
            Master client = (Master)this.cachedMaster.first();
            if (client != null) {
                client.shutdown();
            }
            this.cachedMaster = NO_MASTER_MACHINE_PAIR;
        }
    }

    protected Pair<Master, Machine> getMasterFromZooKeeper(boolean wait, boolean allowChange) {
        return this.getMasterFromZooKeeper(wait, WaitMode.SESSION, allowChange);
    }

    protected Pair<Master, Machine> bootstrap() {
        return this.getMasterFromZooKeeper(true, WaitMode.STARTUP, true);
    }

    private Pair<Master, Machine> getMasterFromZooKeeper(boolean wait, WaitMode mode, boolean allowChange) {
        ZooKeeperMachine master = this.getMasterBasedOn(this.getAllMachines(wait, mode).values());
        Master masterClient = NO_MASTER;
        if (((Machine)this.cachedMaster.other()).getMachineId() != master.getMachineId()) {
            this.invalidateMaster();
            if (!allowChange) {
                return NO_MASTER_MACHINE_PAIR;
            }
            if (master != Machine.NO_MACHINE && master.getMachineId() != this.getMyMachineId()) {
                masterClient = this.getMasterClientToMachine(master);
            }
            this.cachedMaster = Pair.of((Object)masterClient, (Object)master);
        }
        return this.cachedMaster;
    }

    protected Master getMasterClientToMachine(Machine master) {
        if (master == Machine.NO_MACHINE || master.getServer() == null) {
            return NO_MASTER;
        }
        return new MasterClient((String)master.getServer().first(), (Integer)master.getServer().other(), this.graphDb, this.getConnectionLostHandler(), this.clientReadTimeout, this.clientLockReadTimeout, this.maxConcurrentChannelsPerSlave);
    }

    protected abstract int getMyMachineId();

    public Pair<Master, Machine> getCachedMaster() {
        return this.cachedMaster;
    }

    protected ZooKeeperMachine getMasterBasedOn(Collection<ZooKeeperMachine> machines) {
        Machine master = null;
        int lowestSeq = Integer.MAX_VALUE;
        long highestTxId = -1L;
        for (ZooKeeperMachine info : machines) {
            if (info.getLastCommittedTxId() == -1L || info.getLastCommittedTxId() < highestTxId || info.getLastCommittedTxId() <= highestTxId && !info.wasCommittingMaster() && (master.wasCommittingMaster() || info.getSequenceId() >= lowestSeq)) continue;
            master = info;
            lowestSeq = info.getSequenceId();
            highestTxId = info.getLastCommittedTxId();
        }
        this.log("getMaster " + (master != null ? Integer.valueOf(master.getMachineId()) : "none") + " based on " + machines);
        if (master != null) {
            try {
                this.getZooKeeper(false).getData(this.getRoot() + "/" + ((ZooKeeperMachine)master).getZooKeeperPath(), true, null);
            }
            catch (KeeperException e) {
                throw new ZooKeeperException("Unable to get master data while setting watch", e);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new ZooKeeperException("Interrupted while setting watch on master.", e);
            }
            return master;
        }
        return ZooKeeperMachine.NO_MACHINE;
    }

    protected Client.ConnectionLostHandler getConnectionLostHandler() {
        return Client.ConnectionLostHandler.NO_ACTION;
    }

    protected Map<Integer, ZooKeeperMachine> getAllMachines(boolean wait) {
        return this.getAllMachines(wait, WaitMode.SESSION);
    }

    protected Map<Integer, ZooKeeperMachine> getAllMachines(boolean wait, WaitMode mode) {
        if (wait) {
            this.waitForSyncConnected(mode);
        }
        try {
            HashMap<Integer, ZooKeeperMachine> result = new HashMap<Integer, ZooKeeperMachine>();
            String root = this.getRoot();
            List children = this.getZooKeeper(true).getChildren(root, false);
            for (String child : children) {
                Pair<Integer, Integer> parsedChild = this.parseChild(child);
                if (parsedChild == null) continue;
                try {
                    int id = (Integer)parsedChild.first();
                    int seq = (Integer)parsedChild.other();
                    Pair<Long, Integer> instanceData = this.readDataRepresentingInstance(root + "/" + child);
                    if (result.containsKey(id) && seq <= ((ZooKeeperMachine)result.get(id)).getSequenceId()) continue;
                    result.put(id, new ZooKeeperMachine(id, seq, (Long)instanceData.first(), (Integer)instanceData.other(), this.getHaServer(id, wait), "ha-servers/" + id));
                }
                catch (KeeperException inner) {
                    if (inner.code() == KeeperException.Code.NONODE) continue;
                    throw new ZooKeeperException("Unable to get master.", inner);
                }
            }
            return result;
        }
        catch (KeeperException e) {
            throw new ZooKeeperException("Unable to get master", e);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ZooKeeperException("Interrupted.", e);
        }
    }

    protected String getHaServer(int machineId, boolean wait) {
        String result = this.haServersCache.get(machineId);
        if (result == null) {
            result = (String)this.readHaServer(machineId, wait).first();
            this.haServersCache.put(machineId, result);
        }
        return result;
    }

    protected Pair<String, Integer> readHaServer(int machineId, boolean wait) {
        if (wait) {
            this.waitForSyncConnected();
        }
        String rootPath = this.getRoot();
        String haServerPath = rootPath + "/" + HA_SERVERS_CHILD + "/" + machineId;
        try {
            byte[] serverData = this.getZooKeeper(true).getData(haServerPath, false, null);
            ByteBuffer buffer = ByteBuffer.wrap(serverData);
            int backupPort = buffer.getInt();
            byte length = buffer.get();
            char[] chars = new char[length];
            buffer.asCharBuffer().get(chars);
            String result = String.valueOf(chars);
            this.log("Read HA server:" + result + " (for machineID " + machineId + ") from zoo keeper");
            return Pair.of((Object)result, (Object)backupPort);
        }
        catch (KeeperException e) {
            throw new ZooKeeperException("Couldn't find the HA server: " + rootPath, e);
        }
        catch (InterruptedException e) {
            throw new ZooKeeperException("Interrupted", e);
        }
    }

    private void log(String string) {
        if (this.msgLog != null) {
            this.msgLog.logMessage(string);
        }
    }

    public void shutdown() {
        try {
            this.invalidateMaster();
            this.cachedMaster = NO_MASTER_MACHINE_PAIR;
            this.getZooKeeper(false).close();
        }
        catch (InterruptedException e) {
            throw new ZooKeeperException("Error closing zookeeper connection", e);
        }
    }

    public final void waitForSyncConnected() {
        this.waitForSyncConnected(WaitMode.SESSION);
    }

    abstract void waitForSyncConnected(WaitMode var1);

    public String getServers() {
        return this.servers;
    }

    private static class StartupWaitStrategy
    implements WaitStrategy {
        static final long SECONDS_TO_WAIT_BETWEEN_NOTIFICATIONS = 30L;
        private long lastNotification = 0L;
        private final StringLogger msgLog;

        public StartupWaitStrategy(StringLogger msgLog) {
            this.msgLog = msgLog;
        }

        @Override
        public boolean waitMore(long waitedSoFar) {
            long currentNotification = waitedSoFar / 30000L;
            if (currentNotification > this.lastNotification) {
                this.lastNotification = currentNotification;
                this.msgLog.logMessage("Have been waiting for " + 30L * currentNotification + " seconds for the ZooKeeper cluster to respond.");
            }
            return true;
        }
    }

    private static class SessionWaitStrategy
    implements WaitStrategy {
        private final long sessionTimeout;

        SessionWaitStrategy(long sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
        }

        @Override
        public boolean waitMore(long waitedSoFar) {
            return waitedSoFar < this.sessionTimeout;
        }
    }

    static interface WaitStrategy {
        public boolean waitMore(long var1);
    }

    static enum WaitMode {
        STARTUP{

            @Override
            public WaitStrategy getStrategy(AbstractZooKeeperManager zooClient) {
                return new StartupWaitStrategy(zooClient.msgLog);
            }
        }
        ,
        SESSION{

            @Override
            public WaitStrategy getStrategy(AbstractZooKeeperManager zooClient) {
                return new SessionWaitStrategy(zooClient.getSessionTimeout());
            }
        };


        public abstract WaitStrategy getStrategy(AbstractZooKeeperManager var1);
    }
}

