/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.AbstractBroker;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterClient;
import org.neo4j.kernel.ha.MasterImpl;
import org.neo4j.kernel.ha.zookeeper.Machine;
import slavetest.SingleJvmTest;

public class SingleJvmWithNettyTest
extends SingleJvmTest {
    @Test
    public void assertThatNettyIsUsed() throws Exception {
        this.initializeDbs(1);
        Assert.assertTrue((String)"Slave Broker is not a client", (boolean)(((HighlyAvailableGraphDatabase)this.getSlave(0)).getBroker().getMaster().first() instanceof MasterClient));
    }

    @Override
    protected Broker makeSlaveBroker(MasterImpl master, int masterId, int id, GraphDatabaseService graphDb) {
        Machine masterMachine = new Machine(masterId, -1, 1L, -1, "localhost:8901");
        MasterClient client = new MasterClient(masterMachine, graphDb);
        return new AbstractBroker(id, graphDb, (Master)client, masterMachine){
            final /* synthetic */ Master val$client;
            final /* synthetic */ Machine val$masterMachine;
            {
                this.val$client = master;
                this.val$masterMachine = machine;
                super(x0, x1);
            }

            public boolean iAmMaster() {
                return false;
            }

            public Pair<Master, Machine> getMasterReally() {
                return this.getMaster();
            }

            public Pair<Master, Machine> getMaster() {
                return Pair.of((Object)this.val$client, (Object)this.val$masterMachine);
            }

            public Object instantiateMasterServer(GraphDatabaseService graphDb) {
                throw new UnsupportedOperationException("cannot instantiate master server on slave");
            }
        };
    }

    @Test
    public void makeSureLogMessagesIsWrittenEvenAfterInternalRestart() throws Exception {
        this.initializeDbs(1);
        final CountDownLatch latch1 = new CountDownLatch(1);
        final GraphDatabaseService slave = this.getSlave(0);
        Thread t1 = new Thread(){

            @Override
            public void run() {
                try {
                    Transaction tx = slave.beginTx();
                    slave.createNode();
                    latch1.await();
                    tx.success();
                    tx.finish();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        t1.start();
        Thread t2 = new Thread(){

            @Override
            public void run() {
                Transaction tx = slave.beginTx();
                slave.createNode();
                latch1.countDown();
                tx.success();
                tx.finish();
            }
        };
        t2.start();
        t1.join();
        t2.join();
        Assert.assertEquals((long)2L, (long)this.countOccurences("Opened a new channel", new File(this.dbPath(1), "messages.log")));
    }

    private int countOccurences(String string, File file) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        int counter = 0;
        while ((line = reader.readLine()) != null) {
            System.out.println(line);
            if (!line.contains(string)) continue;
            ++counter;
        }
        reader.close();
        return counter;
    }
}

