/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.neo4j.backup.OnlineBackupExtension;
import org.neo4j.com.ComException;
import org.neo4j.com.MasterUtil;
import org.neo4j.com.Response;
import org.neo4j.com.SlaveContext;
import org.neo4j.com.StoreWriter;
import org.neo4j.com.ToFileStoreWriter;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.CommonFactories;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.EmbeddedGraphDbImpl;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.LockManagerFactory;
import org.neo4j.kernel.ha.BranchedDataException;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.BrokerFactory;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterIdGeneratorFactory;
import org.neo4j.kernel.ha.MasterServer;
import org.neo4j.kernel.ha.MasterTxIdGenerator;
import org.neo4j.kernel.ha.ResponseReceiver;
import org.neo4j.kernel.ha.SlaveIdGenerator;
import org.neo4j.kernel.ha.SlaveLockManager;
import org.neo4j.kernel.ha.SlaveRelationshipTypeCreator;
import org.neo4j.kernel.ha.SlaveTxIdGenerator;
import org.neo4j.kernel.ha.SlaveTxRollbackHook;
import org.neo4j.kernel.ha.TimeUtil;
import org.neo4j.kernel.ha.ZooKeeperLastCommittedTxIdSetter;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperBroker;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperException;
import org.neo4j.kernel.impl.core.LastCommittedTxIdSetter;
import org.neo4j.kernel.impl.core.RelationshipTypeCreator;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.transaction.TxFinishHook;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGeneratorFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.StringLogger;

public class HighlyAvailableGraphDatabase
extends AbstractGraphDatabase
implements GraphDatabaseService,
ResponseReceiver {
    public static final String CONFIG_KEY_HA_MACHINE_ID = "ha.machine_id";
    public static final String CONFIG_KEY_HA_ZOO_KEEPER_SERVERS = "ha.zoo_keeper_servers";
    public static final String CONFIG_KEY_HA_SERVER = "ha.server";
    public static final String CONFIG_KEY_HA_CLUSTER_NAME = "ha.cluster_name";
    private static final String CONFIG_DEFAULT_HA_CLUSTER_NAME = "neo4j.ha";
    private static final int CONFIG_DEFAULT_PORT = 6361;
    public static final String CONFIG_KEY_HA_PULL_INTERVAL = "ha.pull_interval";
    public static final String CONFIG_KEY_ALLOW_INIT_CLUSTER = "ha.allow_init_cluster";
    private final String storeDir;
    private final Map<String, String> config;
    private final BrokerFactory brokerFactory;
    private final Broker broker;
    private volatile EmbeddedGraphDbImpl localGraph;
    private final int machineId;
    private volatile MasterServer masterServer;
    private ScheduledExecutorService updatePuller;
    private volatile long updateTime = 0L;
    private volatile RuntimeException causeOfShutdown;
    private final long startupTime;
    private final List<KernelEventHandler> kernelEventHandlers = new CopyOnWriteArrayList<KernelEventHandler>();
    private final Collection<TransactionEventHandler<?>> transactionEventHandlers = new CopyOnWriteArraySet();
    private final StringLogger msgLog;

    public HighlyAvailableGraphDatabase(String storeDir, Map<String, String> config) {
        this(storeDir, config, null);
    }

    public HighlyAvailableGraphDatabase(String storeDir, Map<String, String> config, BrokerFactory brokerFactory) {
        if (config == null) {
            throw new IllegalArgumentException("null config, proper configuration required");
        }
        this.startupTime = System.currentTimeMillis();
        this.storeDir = storeDir;
        this.config = config;
        config.put("keep_logical_logs", "true");
        this.brokerFactory = brokerFactory != null ? brokerFactory : this.defaultBrokerFactory(this, config);
        this.machineId = HighlyAvailableGraphDatabase.getMachineIdFromConfig(config);
        this.broker = this.brokerFactory.create(this, config);
        this.msgLog = StringLogger.getLogger((String)storeDir);
        boolean allowInitFromConfig = HighlyAvailableGraphDatabase.getAllowInitFromConfig(config);
        this.startUp(allowInitFromConfig);
    }

    private void getFreshDatabaseFromMaster(Pair<Master, Machine> master) {
        master = master != null ? master : this.broker.getMasterReally();
        this.moveAwayCurrentDatabase();
        Exception exception = null;
        for (int i = 0; i < 10; ++i) {
            try {
                this.copyStoreFromMaster(master);
                return;
            }
            catch (Exception e) {
                this.msgLog.logMessage("Problems copying store from master", (Throwable)e);
                this.sleepWithoutInterruption(1000L, "");
                exception = e;
                continue;
            }
        }
        throw new RuntimeException("Gave up trying to copy store from master", exception);
    }

    private void moveAwayCurrentDatabase() {
        this.msgLog.logMessage("Cleaning database " + this.storeDir + " to make way for new db from master");
        File oldDir = new File(this.storeDir, "broken-" + System.currentTimeMillis());
        oldDir.mkdirs();
        for (File file : new File(this.storeDir).listFiles()) {
            File dest;
            if (file.equals(oldDir) || file.getName().equals("messages.log") || file.renameTo(dest = new File(oldDir, file.getName()))) continue;
            System.out.println("Couldn't move " + file.getPath());
        }
    }

    public static Map<String, String> loadConfigurations(String file) {
        return EmbeddedGraphDatabase.loadConfigurations((String)file);
    }

    private synchronized void startUp(boolean allowInit) {
        StoreId storeId = null;
        if (!new File(this.storeDir, "neostore").exists()) {
            long endTime = System.currentTimeMillis() + 10000L;
            Exception exception = null;
            while (System.currentTimeMillis() < endTime) {
                Pair<Master, Machine> master = this.broker.getMaster();
                Pair<Master, Machine> pair = master = master.first() != null ? master : this.broker.getMasterReally();
                if (master != null && master.first() != null) {
                    try {
                        this.copyStoreFromMaster(master);
                        this.msgLog.logMessage("copied store from master");
                        exception = null;
                        break;
                    }
                    catch (Exception e) {
                        exception = e;
                        this.broker.getMasterReally();
                        this.msgLog.logMessage("Problems copying store from master", (Throwable)e);
                    }
                } else if (allowInit) {
                    exception = null;
                    StoreId myStoreId = new StoreId();
                    storeId = this.broker.createCluster(myStoreId);
                    if (storeId.equals((Object)myStoreId)) break;
                }
                this.sleepWithoutInterruption(300L, "Startup interrupted");
            }
            if (exception != null) {
                throw new RuntimeException("Tried to join the cluster, but was unable to", exception);
            }
        }
        this.newMaster(null, storeId, new Exception());
        this.localGraph();
    }

    private void sleepWithoutInterruption(long time, String errorMessage) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(errorMessage, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStoreFromMaster(Pair<Master, Machine> master) throws Exception {
        this.msgLog.logMessage("Copying store from master");
        Response<Void> response = ((Master)master.first()).copyStore(new SlaveContext(0L, this.machineId, 0, new Pair[0]), (StoreWriter)new ToFileStoreWriter(this.storeDir));
        EmbeddedGraphDatabase tempDb = new EmbeddedGraphDatabase(this.storeDir);
        try {
            MasterUtil.applyReceivedTransactions(response, (GraphDatabaseService)tempDb, (MasterUtil.TxHandler)MasterUtil.txHandlerForFullCopy());
        }
        finally {
            tempDb.shutdown();
        }
        this.msgLog.logMessage("Done copying store from master");
    }

    private EmbeddedGraphDbImpl localGraph() {
        if (this.localGraph == null) {
            if (this.causeOfShutdown != null) {
                throw this.causeOfShutdown;
            }
            throw new RuntimeException("Graph database not assigned and no cause of shutdown, maybe not started yet or in the middle of master/slave swap?");
        }
        return this.localGraph;
    }

    private BrokerFactory defaultBrokerFactory(GraphDatabaseService graphDb, Map<String, String> config) {
        return new BrokerFactory(){

            @Override
            public Broker create(GraphDatabaseService graphDb, Map<String, String> config) {
                return new ZooKeeperBroker(graphDb, HighlyAvailableGraphDatabase.getClusterNameFromConfig(config), HighlyAvailableGraphDatabase.getMachineIdFromConfig(config), HighlyAvailableGraphDatabase.getZooKeeperServersFromConfig(config), HighlyAvailableGraphDatabase.getHaServerFromConfig(config), HighlyAvailableGraphDatabase.getBackupPortFromConfig(config), HighlyAvailableGraphDatabase.this);
            }
        };
    }

    private static int getBackupPortFromConfig(Map<?, ?> config) {
        String backupConfig = (String)config.get("enable_online_backup");
        Integer port = OnlineBackupExtension.parsePort((String)backupConfig);
        return port != null ? port : 0;
    }

    private static String getClusterNameFromConfig(Map<?, ?> config) {
        String clusterName = (String)config.get(CONFIG_KEY_HA_CLUSTER_NAME);
        if (clusterName == null) {
            clusterName = CONFIG_DEFAULT_HA_CLUSTER_NAME;
        }
        return clusterName;
    }

    private static String getHaServerFromConfig(Map<?, ?> config) {
        String haServer = (String)config.get(CONFIG_KEY_HA_SERVER);
        if (haServer == null) {
            InetAddress host = null;
            try {
                host = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            if (host == null) {
                throw new IllegalStateException("Could not auto configure host name, please supply ha.server");
            }
            haServer = host.getHostAddress() + ":" + 6361;
        }
        return haServer;
    }

    private static boolean getAllowInitFromConfig(Map<?, ?> config) {
        String allowInit = (String)config.get(CONFIG_KEY_ALLOW_INIT_CLUSTER);
        if (allowInit == null) {
            return true;
        }
        return Boolean.parseBoolean(allowInit);
    }

    private static String getZooKeeperServersFromConfig(Map<String, String> config) {
        return config.get(CONFIG_KEY_HA_ZOO_KEEPER_SERVERS);
    }

    private static int getMachineIdFromConfig(Map<String, String> config) {
        return Integer.parseInt(config.get(CONFIG_KEY_HA_MACHINE_ID));
    }

    public Broker getBroker() {
        return this.broker;
    }

    public void pullUpdates() {
        try {
            if (this.masterServer == null) {
                this.receive(((Master)this.broker.getMaster().first()).pullUpdates(this.getSlaveContext(-1)));
            }
        }
        catch (ZooKeeperException e) {
            this.newMaster(null, e);
            throw e;
        }
        catch (ComException e) {
            this.newMaster(null, (Exception)((Object)e));
            throw e;
        }
    }

    private void updateTime() {
        this.updateTime = System.currentTimeMillis();
    }

    long lastUpdateTime() {
        return this.updateTime;
    }

    public Config getConfig() {
        return this.localGraph().getConfig();
    }

    public String getStoreDir() {
        return this.storeDir;
    }

    public <T> Collection<T> getManagementBeans(Class<T> type) {
        return this.localGraph().getManagementBeans(type);
    }

    protected synchronized void reevaluateMyself(Pair<Master, Machine> master, StoreId storeId) {
        if (master == null) {
            master = this.broker.getMasterReally();
        }
        boolean restarted = false;
        boolean iAmCurrentlyMaster = this.masterServer != null;
        this.msgLog.logMessage("ReevaluateMyself: machineId=" + this.machineId + " with master[" + master + "] (I am master=" + iAmCurrentlyMaster + ")");
        if (((Machine)master.other()).getMachineId() == this.machineId) {
            if (this.localGraph == null || !iAmCurrentlyMaster) {
                this.internalShutdown();
                this.startAsMaster(storeId);
                restarted = true;
            }
            this.broker.rebindMaster();
        } else {
            this.broker.notifyMasterChange((Machine)master.other());
            if (this.localGraph == null || iAmCurrentlyMaster) {
                this.internalShutdown();
                this.startAsSlave(storeId);
                restarted = true;
            } else {
                ((SlaveIdGenerator.SlaveIdGeneratorFactory)this.getConfig().getIdGeneratorFactory()).forgetIdAllocationsFromMaster();
            }
            this.tryToEnsureIAmNotABrokenMachine(this.broker.getMaster());
        }
        if (restarted) {
            this.doAfterLocalGraphStarted();
        }
    }

    private void doAfterLocalGraphStarted() {
        this.broker.setConnectionInformation(this.localGraph.getKernelData());
        for (TransactionEventHandler<?> transactionEventHandler : this.transactionEventHandlers) {
            this.localGraph().registerTransactionEventHandler(transactionEventHandler);
        }
        for (KernelEventHandler kernelEventHandler : this.kernelEventHandlers) {
            this.localGraph().registerKernelEventHandler(kernelEventHandler);
        }
    }

    private void startAsSlave(StoreId storeId) {
        this.msgLog.logMessage("Starting[" + this.machineId + "] as slave", true);
        this.localGraph = new EmbeddedGraphDbImpl(this.storeDir, storeId, this.config, (GraphDatabaseService)this, (LockManagerFactory)new SlaveLockManager.SlaveLockManagerFactory(this.broker, this), (IdGeneratorFactory)new SlaveIdGenerator.SlaveIdGeneratorFactory(this.broker, this), (RelationshipTypeCreator)new SlaveRelationshipTypeCreator(this.broker, this), (TxIdGeneratorFactory)new SlaveTxIdGenerator.SlaveTxIdGeneratorFactory(this.broker, this), (TxFinishHook)new SlaveTxRollbackHook(this.broker, this), (LastCommittedTxIdSetter)new ZooKeeperLastCommittedTxIdSetter(this.broker), CommonFactories.defaultFileSystemAbstraction());
        this.instantiateAutoUpdatePullerIfConfigSaysSo();
        this.msgLog.logMessage("Started as slave", true);
    }

    private void startAsMaster(StoreId storeId) {
        this.msgLog.logMessage("Starting[" + this.machineId + "] as master", true);
        this.localGraph = new EmbeddedGraphDbImpl(this.storeDir, storeId, this.config, (GraphDatabaseService)this, CommonFactories.defaultLockManagerFactory(), (IdGeneratorFactory)new MasterIdGeneratorFactory(), CommonFactories.defaultRelationshipTypeCreator(), (TxIdGeneratorFactory)new MasterTxIdGenerator.MasterTxIdGeneratorFactory(this.broker), CommonFactories.defaultTxFinishHook(), (LastCommittedTxIdSetter)new ZooKeeperLastCommittedTxIdSetter(this.broker), CommonFactories.defaultFileSystemAbstraction());
        this.masterServer = (MasterServer)((Object)this.broker.instantiateMasterServer(this));
        this.msgLog.logMessage("Started as master", true);
    }

    private void tryToEnsureIAmNotABrokenMachine(Pair<Master, Machine> master) {
        if (((Machine)master.other()).getMachineId() == this.machineId) {
            return;
        }
        if (master.first() == null) {
            RuntimeException cause = new RuntimeException("Unable to get master from ZK");
            this.shutdown(cause, false);
            throw cause;
        }
        XaDataSource nioneoDataSource = this.getConfig().getTxModule().getXaDataSourceManager().getXaDataSource("nioneodb");
        long myLastCommittedTx = nioneoDataSource.getLastCommittedTxId();
        long highestCommonTxId = Math.min(myLastCommittedTx, ((Machine)master.other()).getLastCommittedTxId());
        int masterForMyHighestCommonTxId = -1;
        try {
            masterForMyHighestCommonTxId = nioneoDataSource.getMasterForCommittedTx(highestCommonTxId);
        }
        catch (IOException e) {
            this.msgLog.logMessage("Couldn't get master ID for txId " + highestCommonTxId + ". It may be that a log file is missing due to the db being copied from master?", (Throwable)e);
            return;
        }
        int masterForMastersHighestCommonTxId = (Integer)((Master)master.first()).getMasterIdForCommittedTx(highestCommonTxId).response();
        if (masterForMyHighestCommonTxId == masterForMastersHighestCommonTxId) {
            this.msgLog.logMessage("Master id for last committed tx ok with highestCommonTxId=" + highestCommonTxId + " with masterId=" + masterForMyHighestCommonTxId, true);
            return;
        }
        String msg = "Broken store, I (machineId:" + this.machineId + ") think machineId for txId (" + highestCommonTxId + ") is " + masterForMyHighestCommonTxId + ", but master (machineId:" + ((Machine)master.other()).getMachineId() + ") says that it's " + masterForMastersHighestCommonTxId;
        this.msgLog.logMessage(msg, true);
        BranchedDataException exception = new BranchedDataException(msg);
        this.shutdown(exception, false);
        throw exception;
    }

    private void instantiateAutoUpdatePullerIfConfigSaysSo() {
        String pullInterval = this.config.get(CONFIG_KEY_HA_PULL_INTERVAL);
        if (pullInterval != null) {
            long timeMillis = TimeUtil.parseTimeMillis(pullInterval);
            this.updatePuller = new ScheduledThreadPoolExecutor(1);
            this.updatePuller.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        HighlyAvailableGraphDatabase.this.pullUpdates();
                    }
                    catch (Exception e) {
                        HighlyAvailableGraphDatabase.this.msgLog.logMessage("Pull updates failed", (Throwable)e);
                    }
                }
            }, timeMillis, timeMillis, TimeUnit.MILLISECONDS);
        }
    }

    public Transaction beginTx() {
        return this.localGraph().beginTx();
    }

    public Node createNode() {
        return this.localGraph().createNode();
    }

    public Iterable<Node> getAllNodes() {
        return this.localGraph().getAllNodes();
    }

    public Node getNodeById(long id) {
        return this.localGraph().getNodeById(id);
    }

    public Node getReferenceNode() {
        return this.localGraph().getReferenceNode();
    }

    public Relationship getRelationshipById(long id) {
        return this.localGraph().getRelationshipById(id);
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.localGraph().getRelationshipTypes();
    }

    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        this.kernelEventHandlers.add(handler);
        return this.localGraph().registerKernelEventHandler(handler);
    }

    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        this.transactionEventHandlers.add(handler);
        return this.localGraph().registerTransactionEventHandler(handler);
    }

    public synchronized void internalShutdown() {
        this.msgLog.logMessage("Internal shutdown of HA db[" + this.machineId + "] reference=" + this + ", masterServer=" + (Object)((Object)this.masterServer), true);
        if (this.updatePuller != null) {
            this.msgLog.logMessage("Internal shutdown updatePuller", true);
            this.updatePuller.shutdown();
            this.msgLog.logMessage("Internal shutdown updatePuller DONE", true);
            this.updatePuller = null;
        }
        if (this.masterServer != null) {
            this.msgLog.logMessage("Internal shutdown masterServer", true);
            this.masterServer.shutdown();
            this.msgLog.logMessage("Internal shutdown masterServer DONE", true);
            this.masterServer = null;
        }
        if (this.localGraph != null) {
            this.msgLog.logMessage("Internal shutdown localGraph", true);
            this.localGraph.shutdown();
            this.msgLog.logMessage("Internal shutdown localGraph DONE", true);
            this.localGraph = null;
        }
        this.msgLog.flush();
        StringLogger.close((String)this.storeDir);
    }

    private synchronized void shutdown(RuntimeException cause, boolean shutdownBroker) {
        this.causeOfShutdown = cause;
        this.msgLog.logMessage("Shutdown[" + this.machineId + "], " + this, true);
        if (shutdownBroker && this.broker != null) {
            this.broker.shutdown();
        }
        this.internalShutdown();
    }

    public synchronized void shutdown() {
        this.shutdown(new IllegalStateException(), true);
    }

    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        return this.localGraph().unregisterKernelEventHandler(handler);
    }

    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.localGraph().unregisterTransactionEventHandler(handler);
    }

    @Override
    public SlaveContext getSlaveContext(int eventIdentifier) {
        XaDataSourceManager localDataSourceManager = this.getConfig().getTxModule().getXaDataSourceManager();
        Collection dataSources = localDataSourceManager.getAllRegisteredDataSources();
        Pair[] txs = new Pair[dataSources.size()];
        int i = 0;
        for (XaDataSource dataSource : dataSources) {
            txs[i++] = Pair.of((Object)dataSource.getName(), (Object)dataSource.getLastCommittedTxId());
        }
        return new SlaveContext(this.startupTime, this.machineId, eventIdentifier, txs);
    }

    @Override
    public <T> T receive(Response<T> response) {
        try {
            MasterUtil.applyReceivedTransactions(response, (GraphDatabaseService)this, (MasterUtil.TxHandler)MasterUtil.NO_ACTION);
            this.updateTime();
            return (T)response.response();
        }
        catch (IOException e) {
            this.newMaster(this.broker.getMaster(), e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void newMaster(Pair<Master, Machine> master, Exception e) {
        this.newMaster(master, null, e);
    }

    private synchronized void newMaster(Pair<Master, Machine> master, StoreId storeId, Exception e) {
        try {
            this.doNewMaster(master, storeId, e);
        }
        catch (BranchedDataException bde) {
            System.out.println("Branched data occured, retrying");
            this.getFreshDatabaseFromMaster(master);
            this.doNewMaster(master, storeId, bde);
        }
    }

    private void doNewMaster(Pair<Master, Machine> master, StoreId storeId, Exception e) {
        try {
            this.msgLog.logMessage("newMaster(" + master + ") called", (Throwable)e, true);
            this.reevaluateMyself(master, storeId);
        }
        catch (ZooKeeperException ee) {
            this.msgLog.logMessage("ZooKeeper exception in newMaster", (Throwable)ee);
        }
        catch (ComException ee) {
            this.msgLog.logMessage("Communication exception in newMaster", (Throwable)ee);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.msgLog.logMessage("Reevaluation ended in unknown exception " + t + " so shutting down", true);
            this.shutdown(t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t), false);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public MasterServer getMasterServerIfMaster() {
        return this.masterServer;
    }

    int getMachineId() {
        return this.machineId;
    }

    public boolean isMaster() {
        return this.broker.iAmMaster();
    }

    public boolean isReadOnly() {
        return false;
    }

    public IndexManager index() {
        return this.localGraph().index();
    }

    public void shutdownBroker() {
        this.broker.shutdown();
    }
}

