/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.AbstractBroker;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterClient;
import org.neo4j.kernel.ha.MasterImpl;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.impl.util.FileUtils;
import slavetest.CommonJobs;
import slavetest.PlaceHolderGraphDatabaseService;
import slavetest.SingleJvmTest;

public class SingleJvmWithNettyTest
extends SingleJvmTest {
    @Test
    public void assertThatNettyIsUsed() throws Exception {
        this.initializeDbs(1);
        Assert.assertTrue((String)"Slave Broker is not a client", (boolean)(((HighlyAvailableGraphDatabase)this.getSlave(0)).getBroker().getMaster().first() instanceof MasterClient));
    }

    @Override
    protected Broker makeSlaveBroker(MasterImpl master, int masterId, int id, GraphDatabaseService graphDb) {
        Machine masterMachine = new Machine(masterId, -1, 1L, -1, "localhost:8901");
        MasterClient client = new MasterClient((String)masterMachine.getServer().first(), ((Integer)masterMachine.getServer().other()).intValue(), graphDb, 20, 20);
        return new AbstractBroker(id, graphDb, (Master)client, masterMachine){
            final /* synthetic */ Master val$client;
            final /* synthetic */ Machine val$masterMachine;
            {
                this.val$client = master;
                this.val$masterMachine = machine;
                super(x0, x1);
            }

            public boolean iAmMaster() {
                return false;
            }

            public Pair<Master, Machine> getMasterReally() {
                return this.getMaster();
            }

            public Pair<Master, Machine> getMaster() {
                return Pair.of((Object)this.val$client, (Object)this.val$masterMachine);
            }

            public Object instantiateMasterServer(GraphDatabaseService graphDb) {
                throw new UnsupportedOperationException("cannot instantiate master server on slave");
            }
        };
    }

    @Test
    public void makeSureLogMessagesIsWrittenEvenAfterInternalRestart() throws Exception {
        this.initializeDbs(1);
        final CountDownLatch latch1 = new CountDownLatch(1);
        final GraphDatabaseService slave = this.getSlave(0);
        Thread t1 = new Thread(){

            @Override
            public void run() {
                try {
                    Transaction tx = slave.beginTx();
                    slave.createNode();
                    latch1.await();
                    tx.success();
                    tx.finish();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        t1.start();
        Thread t2 = new Thread(){

            @Override
            public void run() {
                Transaction tx = slave.beginTx();
                slave.createNode();
                latch1.countDown();
                tx.success();
                tx.finish();
            }
        };
        t2.start();
        t1.join();
        t2.join();
        Assert.assertEquals((long)2L, (long)this.countOccurences("Opened a new channel", new File(this.dbPath(1), "messages.log")));
    }

    private int countOccurences(String string, File file) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        int counter = 0;
        while ((line = reader.readLine()) != null) {
            if (!line.contains(string)) continue;
            ++counter;
        }
        reader.close();
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMixingEntitiesFromWrongDbs() throws Exception {
        this.initializeDbs(1);
        GraphDatabaseService haDb1 = this.getSlave(0);
        GraphDatabaseService mDb = this.getMaster().getGraphDb();
        Transaction tx = mDb.beginTx();
        try {
            Node masterNode = mDb.createNode();
            mDb.getReferenceNode().createRelationshipTo(masterNode, CommonJobs.REL_TYPE);
            tx.success();
        }
        finally {
            tx.finish();
        }
        tx = haDb1.beginTx();
        try {
            Node node = haDb1.createNode();
            mDb.getReferenceNode().createRelationshipTo(node, CommonJobs.KNOWS);
            Assert.fail((String)"Should throw NotFoundException");
        }
        catch (NotFoundException e) {
        }
        finally {
            tx.finish();
        }
    }

    private HighlyAvailableGraphDatabase getMasterHaDb() {
        PlaceHolderGraphDatabaseService db = (PlaceHolderGraphDatabaseService)this.getMaster().getGraphDb();
        return (HighlyAvailableGraphDatabase)db.getDb();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void slaveWriteThatOnlyModifyRelationshipRecordsCanUpdateCachedNodeOnMaster() throws Exception {
        long relId;
        Node node;
        this.initializeDbs(1, MapUtil.stringMap((String[])new String[]{"cache_type", "strong"}));
        HighlyAvailableGraphDatabase sDb = (HighlyAvailableGraphDatabase)this.getSlave(0);
        HighlyAvailableGraphDatabase mDb = this.getMasterHaDb();
        Transaction tx = mDb.beginTx();
        try {
            node = mDb.createNode();
            node.createRelationshipTo(mDb.createNode(), REL_TYPE);
            relId = node.createRelationshipTo(mDb.createNode(), REL_TYPE).getId();
            node.createRelationshipTo(mDb.createNode(), REL_TYPE);
            tx.success();
        }
        finally {
            tx.finish();
        }
        sDb.pullUpdates();
        tx = sDb.beginTx();
        try {
            sDb.getRelationshipById(relId).delete();
            tx.success();
        }
        finally {
            tx.finish();
        }
        int relCount = 0;
        for (Relationship rel : node.getRelationships()) {
            rel.getOtherNode(node);
            ++relCount;
        }
        Assert.assertEquals((String)"wrong number of relationships", (long)2L, (long)relCount);
    }

    @Test
    public void mastersMessagesLogShouldNotContainMentionsAboutAppliedTransactions() throws Exception {
        this.initializeDbs(1);
        for (int i = 0; i < 5; ++i) {
            this.executeJob(new CommonJobs.CreateNodeJob(), 0);
        }
        this.disableVerificationAfterTest();
        this.shutdownDbs();
        List<String> toLookFor = Arrays.asList("applyTxWithoutTxId log version", "Applied external tx and generated");
        Assert.assertEquals((long)0L, (long)this.countMentionsInMessagesLog(new File(this.dbPath(0), "messages.log"), toLookFor));
    }

    private int countMentionsInMessagesLog(File file, Collection<String> toLookFor) {
        int counter = 0;
        for (String line : IteratorUtil.asIterable((File)file)) {
            for (String lookFor : toLookFor) {
                if (!line.contains(lookFor)) continue;
                ++counter;
            }
        }
        return counter;
    }

    @Test
    public void halfWayCopyWithSuccessfulRetry() throws Exception {
        this.createBigMasterStore(10);
        this.startUpMaster(MapUtil.stringMap((String[])new String[0]));
        int slaveMachineId = this.addDb(MapUtil.stringMap((String[])new String[0]), false);
        this.awaitAllStarted();
        this.shutdownDb(slaveMachineId);
        FileUtils.deleteFiles((File)this.dbPath(slaveMachineId), (String)"nioneo.*\\.v.*");
        FileUtils.deleteRecursively((File)new File(this.dbPath(slaveMachineId), "index"));
        Assert.assertTrue((boolean)new File(this.dbPath(slaveMachineId), "neostore").delete());
        Assert.assertTrue((boolean)new File(this.dbPath(slaveMachineId), "neostore.relationshipstore.db").delete());
        File propertyStoreFile = new File(this.dbPath(slaveMachineId), "neostore.propertystore.db");
        FileUtils.truncateFile((File)propertyStoreFile, (long)(propertyStoreFile.length() / 2L));
        this.startDb(slaveMachineId, MapUtil.stringMap((String[])new String[0]), true);
        this.awaitAllStarted();
    }

    @Test
    public void failCommitLongGoingTxOnSlaveAfterMasterRestart() throws Exception {
        this.initializeDbs(1);
        GraphDatabaseService master = this.getMaster().getGraphDb();
        Transaction masterTx = master.beginTx();
        long masterNodeId = master.createNode().getId();
        masterTx.success();
        masterTx.finish();
        HighlyAvailableGraphDatabase slave = (HighlyAvailableGraphDatabase)this.getSlave(0);
        slave.pullUpdates();
        Transaction slaveTx = slave.beginTx();
        slave.getNodeById(masterNodeId).setProperty("key", (Object)"value");
        slave.index().forNodes("name").add((PropertyContainer)slave.getNodeById(masterNodeId), "key", (Object)"value");
        slave.createNode().getId();
        this.getMasterHaDb().shutdown();
        ((PlaceHolderGraphDatabaseService)this.getMaster().getGraphDb()).setDb(this.startUpMasterDb(MapUtil.stringMap((String[])new String[0])).getDb());
        slaveTx.success();
        try {
            slaveTx.finish();
            Assert.fail((String)"Shouldn't be able to commit here");
        }
        catch (TransactionFailureException e) {
            // empty catch block
        }
    }

    @Test
    public void committsAndRollbacksCountCorrectlyOnMaster() throws Exception {
        this.initializeDbs(1);
        GraphDatabaseService master = this.getMaster().getGraphDb();
        GraphDatabaseService slave = this.getSlave(0);
        Pair<Integer, Integer> masterTxsBefore = this.getTransactionCounts(master);
        this.executeJobOnMaster(new CommonJobs.CreateNodeJob());
        Assert.assertEquals((Object)Pair.of((Object)((Integer)masterTxsBefore.first() + 1), (Object)masterTxsBefore.other()), this.getTransactionCounts(master));
        masterTxsBefore = this.getTransactionCounts(master);
        Pair<Integer, Integer> slaveTxsBefore = this.getTransactionCounts(slave);
        this.executeJob(new CommonJobs.CreateNodeJob(), 0);
        Assert.assertEquals((Object)Pair.of((Object)((Integer)masterTxsBefore.first() + 1), (Object)masterTxsBefore.other()), this.getTransactionCounts(master));
        Assert.assertEquals((Object)Pair.of((Object)((Integer)slaveTxsBefore.first() + 1), (Object)slaveTxsBefore.other()), this.getTransactionCounts(slave));
        masterTxsBefore = this.getTransactionCounts(master);
        this.executeJobOnMaster(new CommonJobs.CreateNodeJob(false));
        Assert.assertEquals((Object)Pair.of((Object)masterTxsBefore.first(), (Object)((Integer)masterTxsBefore.other() + 1)), this.getTransactionCounts(master));
        masterTxsBefore = this.getTransactionCounts(master);
        slaveTxsBefore = this.getTransactionCounts(slave);
        this.executeJob(new CommonJobs.CreateNodeJob(false), 0);
        Assert.assertEquals((Object)Pair.of((Object)masterTxsBefore.first(), (Object)((Integer)masterTxsBefore.other() + 1)), this.getTransactionCounts(master));
        Assert.assertEquals((Object)Pair.of((Object)slaveTxsBefore.first(), (Object)((Integer)slaveTxsBefore.other() + 1)), this.getTransactionCounts(slave));
    }

    private Pair<Integer, Integer> getTransactionCounts(GraphDatabaseService master) {
        return Pair.of((Object)((AbstractGraphDatabase)master).getConfig().getTxModule().getCommittedTxCount(), (Object)((AbstractGraphDatabase)master).getConfig().getTxModule().getRolledbackTxCount());
    }
}

