/*
 * Decompiled with CFR 0.152.
 */
package slavetest.manual;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;

class ZooKeeperServerWrapper {
    private final int myId;
    private final File dataDirectory;
    private final int clientPort;
    private final Process process;
    private final Map<String, String> additionalConfig;
    private final Collection<String> allZooKeeperServers;

    public ZooKeeperServerWrapper(int myId, File dataDirectory, int clientPort, Collection<String> allZooKeeperServers, Map<String, String> additionalConfig) throws IOException {
        this.myId = myId;
        this.dataDirectory = dataDirectory;
        this.clientPort = clientPort;
        this.allZooKeeperServers = allZooKeeperServers;
        this.additionalConfig = additionalConfig;
        this.process = this.startServer();
    }

    private Process startServer() throws IOException {
        File configFile = this.createZooKeeperDirectory();
        return Runtime.getRuntime().exec(new String[]{"java", "-cp", System.getProperty("java.class.path"), "org.apache.zookeeper.server.quorum.QuorumPeerMain", configFile.getAbsolutePath()});
    }

    private File createZooKeeperDirectory() throws IOException {
        this.dataDirectory.mkdirs();
        File configFile = new File(this.dataDirectory, "config.cfg");
        Properties props = new Properties();
        this.populateZooConfig(props);
        FileWriter writer = null;
        writer = new FileWriter(configFile);
        for (Object key : new TreeSet<Object>(props.keySet())) {
            writer.write(key + " = " + props.get(key) + "\n");
        }
        writer.close();
        writer = new FileWriter(new File(this.dataDirectory, "myid"));
        writer.write("" + this.myId);
        writer.close();
        return configFile;
    }

    private void populateZooConfig(Properties props) {
        props.setProperty("clientPort", "" + this.clientPort);
        props.setProperty("dataDir", this.dataDirectory.getPath());
        this.fillPropsOrDefault(props, "tickTime", "2000");
        this.fillPropsOrDefault(props, "initLimit", "10");
        this.fillPropsOrDefault(props, "syncLimit", "5");
        int counter = 1;
        for (String server : this.allZooKeeperServers) {
            props.setProperty("server." + counter++, server);
        }
    }

    private void fillPropsOrDefault(Properties props, String key, String defaultValue) {
        String value = this.additionalConfig != null && this.additionalConfig.containsKey(key) ? this.additionalConfig.get(key) : defaultValue;
        props.setProperty(key, value);
    }

    public void shutdown() {
        this.process.destroy();
    }
}

